/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflow;
import org.eclipse.sphinx.emf.mwe.dynamic.IWorkflowHandler;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.platform.util.ExtensionClassDescriptor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class WorkflowHandlerDescriptor
extends ExtensionClassDescriptor<IWorkflowHandler> {
    private static final String NODE_APPLICABLE_FOR = "applicableFor";
    private static final String NODE_INSTANCEOF = "instanceof";
    private static final String ATTR_PRIORITY = "priority";
    private static final String ATTR_VALUE = "value";
    private int priority = -1;
    private Set<String> applicableWorkflowClassNames;

    public WorkflowHandlerDescriptor(IConfigurationElement configurationElement) {
        super(configurationElement);
        String prioAttr = configurationElement.getAttribute(ATTR_PRIORITY);
        if (prioAttr != null && !prioAttr.isEmpty()) {
            try {
                this.priority = Integer.valueOf(prioAttr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.initApplicableWorkflows(configurationElement);
    }

    private void initApplicableWorkflows(IConfigurationElement configurationElement) {
        IConfigurationElement[] applicableForElements;
        this.applicableWorkflowClassNames = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = applicableForElements = configurationElement.getChildren(NODE_APPLICABLE_FOR);
        int n = applicableForElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement applicableFor = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = applicableFor.getChildren(NODE_INSTANCEOF);
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                String workflowClass = child.getAttribute(ATTR_VALUE);
                if (workflowClass != null) {
                    this.applicableWorkflowClassNames.add(workflowClass);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isApplicableFor(Class<? extends IWorkflow> workflowClass) {
        String workflowClassName = workflowClass.getName();
        for (String applicableWorkflowClassName : this.applicableWorkflowClassNames) {
            block4: {
                if (!workflowClassName.equals(applicableWorkflowClassName)) break block4;
                return true;
            }
            try {
                Class<? extends IWorkflow> applicableWorkflowClass = Class.forName(applicableWorkflowClassName);
                if (!applicableWorkflowClass.isAssignableFrom(workflowClass)) continue;
                return true;
            }
            catch (ClassNotFoundException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
        return false;
    }
}

