/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.scoping.ProjectResourceScope;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.loading.UnresolveUnreachableCrossProjectReferencesJob;
import org.eclipse.sphinx.emf.workspace.internal.loading.UpdateResourceURIJob;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.LoadOperationRunnerHelper;
import org.eclipse.sphinx.emf.workspace.loading.operations.FileLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.FileReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.FileUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ModelLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ModelUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ProjectLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ProjectReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.UnresolveUnreachableCrossProjectReferencesOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.UpdateResourceURIOperation;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public final class ModelLoadManager {
    public static final ModelLoadManager INSTANCE = new ModelLoadManager();

    private ModelLoadManager() {
    }

    private Map<TransactionalEditingDomain, Collection<Resource>> detectResourcesToUnload(final IProject project, final boolean includeReferencedScopes, final IMetaModelDescriptor mmFilter, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)project);
        Collection editingDomains = WorkspaceEditingDomainUtil.getAllEditingDomains();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)editingDomains.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
        for (final TransactionalEditingDomain editingDomain : editingDomains) {
            try {
                List resourcesToUnloadInEditingDomain = (List)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<List<Resource>>(){

                    public void run() {
                        ArrayList<Resource> resources = new ArrayList<Resource>();
                        ProjectResourceScope projectResourceScope = new ProjectResourceScope((IResource)project);
                        for (Resource resource : editingDomain.getResourceSet().getResources()) {
                            if (!projectResourceScope.belongsTo(resource, includeReferencedScopes)) continue;
                            if (mmFilter != null) {
                                IMetaModelDescriptor mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(resource);
                                if (mmDescriptor == null) {
                                    mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getOldDescriptor(resource);
                                }
                                if (!mmFilter.equals(mmDescriptor)) continue;
                                resources.add(resource);
                                continue;
                            }
                            resources.add(resource);
                        }
                        this.setResult(resources);
                    }
                });
                if (resourcesToUnloadInEditingDomain.size() > 0) {
                    resourcesToUnload.put(editingDomain, resourcesToUnloadInEditingDomain);
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return resourcesToUnload;
    }

    public void loadWorkspace(boolean async, IProgressMonitor monitor) {
        this.loadAllProjects(null, async, monitor);
    }

    public void loadAllProjects(IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Collection projects = ExtendedPlatform.getRootProjects();
        if (projects.size() == 0) {
            return;
        }
        this.loadProjects(projects, true, mmDescriptor, async, monitor);
    }

    public void loadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.loadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    public void loadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    public void loadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.loadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    public void loadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        if (!projects.isEmpty()) {
            ProjectLoadOperation projectLoadOperation = new ProjectLoadOperation(projects, includeReferencedProjects, mmDescriptor);
            LoadOperationRunnerHelper.run(projectLoadOperation, async, monitor);
        }
    }

    public void loadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.loadFiles(Collections.singleton(file), null, async, monitor);
    }

    public void loadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadFiles(Collections.singleton(file), mmDescriptor, async, monitor);
    }

    public void loadFiles(Collection<IFile> files, boolean async, IProgressMonitor monitor) {
        this.loadFiles(files, null, async, monitor);
    }

    public void loadFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (!files.isEmpty()) {
            FileLoadOperation fileLoadOperation = new FileLoadOperation(files, mmDescriptor);
            LoadOperationRunnerHelper.run(fileLoadOperation, async, monitor);
        }
    }

    public void loadURI(URI uri, boolean async, IProgressMonitor monitor) {
        this.loadURIs(Collections.singleton(uri), null, async, monitor);
    }

    public void loadURI(URI uri, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadURIs(Collections.singleton(uri), mmDescriptor, async, monitor);
    }

    public void loadURIs(Collection<URI> uris, boolean async, IProgressMonitor monitor) {
        this.loadURIs(uris, null, async, monitor);
    }

    public void loadURIs(Collection<URI> uris, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(uris);
        this.loadFiles(this.getFiles(uris), mmDescriptor, async, monitor);
    }

    public void unloadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    public void unloadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    public void unloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    public void unloadAllProjects(IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Collection projects = ExtendedPlatform.getRootProjects();
        if (projects.size() == 0) {
            return;
        }
        this.unloadProjects(projects, true, mmDescriptor, async, monitor);
    }

    public void unloadWorkspace(boolean async, IProgressMonitor monitor) {
        this.unloadAllProjects(null, async, monitor);
    }

    public void unloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        try {
            for (IProject project : projects) {
                String taskName = mmDescriptor != null ? NLS.bind((String)Messages.task_unloadingModelInProject, (Object)mmDescriptor.getName(), (Object)project.getName()) : NLS.bind((String)Messages.task_unloadingModelsInProject, (Object)project.getName());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = this.detectResourcesToUnload(project, includeReferencedProjects, mmDescriptor, (IProgressMonitor)progress.newChild(1));
                if (resourcesToUnload.size() == 0) {
                    progress.done();
                    continue;
                }
                this.internalUnloadResources(resourcesToUnload, ExtendedPlatform.isRootProject((IProject)project), async, (IProgressMonitor)progress.newChild(99));
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void internalUnloadResources(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload, boolean memoryOptimized, boolean async, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(resourcesToUnload);
        if (!resourcesToUnload.isEmpty()) {
            ModelUnloadOperation unloadModelResourceOperation = new ModelUnloadOperation(resourcesToUnload, memoryOptimized);
            LoadOperationRunnerHelper.run(unloadModelResourceOperation, async, monitor);
        }
    }

    public void unloadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(Collections.singleton(file), null, false, async, monitor);
    }

    public void unloadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(Collections.singleton(file), mmDescriptor, false, async, monitor);
    }

    public void unloadFiles(Collection<IFile> files, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(files, null, memoryOptimized, async, monitor);
    }

    public void unloadFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (!files.isEmpty()) {
            FileUnloadOperation fileUnloadOperation = new FileUnloadOperation(files, mmDescriptor, memoryOptimized);
            LoadOperationRunnerHelper.run(fileUnloadOperation, async, monitor);
        }
    }

    public void unloadURI(URI uri, boolean async, IProgressMonitor monitor) {
        this.unloadURIs(Collections.singleton(uri), null, false, async, monitor);
    }

    public void unloadURI(URI uri, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadURIs(Collections.singleton(uri), mmDescriptor, false, async, monitor);
    }

    public void unloadURIs(Collection<URI> uris, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.unloadURIs(uris, null, memoryOptimized, async, monitor);
    }

    public void unloadURIs(Collection<URI> uris, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(uris);
        this.unloadFiles(this.getFiles(uris), mmDescriptor, memoryOptimized, async, monitor);
    }

    public void reloadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    public void reloadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    public void reloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    public void reloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        if (!projects.isEmpty()) {
            ProjectReloadOperation projectReloadOperation = new ProjectReloadOperation(projects, includeReferencedProjects, mmDescriptor);
            LoadOperationRunnerHelper.run(projectReloadOperation, async, monitor);
        }
    }

    public void reloadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(Collections.singleton(file), null, false, async, monitor);
    }

    public void reloadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(Collections.singleton(file), mmDescriptor, false, async, monitor);
    }

    public void reloadFiles(Collection<IFile> files, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(files, null, memoryOptimized, async, monitor);
    }

    public void reloadFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (!files.isEmpty()) {
            FileReloadOperation fileReloadOperation = new FileReloadOperation(files, mmDescriptor, memoryOptimized);
            LoadOperationRunnerHelper.run(fileReloadOperation, async, monitor);
        }
    }

    public void reloadURI(URI uri, boolean async, IProgressMonitor monitor) {
        this.reloadURIs(Collections.singleton(uri), null, false, async, monitor);
    }

    public void reloadURI(URI uri, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadURIs(Collections.singleton(uri), mmDescriptor, false, async, monitor);
    }

    public void reloadURIs(Collection<URI> uris, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.reloadURIs(uris, null, memoryOptimized, async, monitor);
    }

    public void reloadURIs(Collection<URI> uris, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(uris);
        this.reloadFiles(this.getFiles(uris), mmDescriptor, memoryOptimized, async, monitor);
    }

    public void unresolveUnreachableCrossProjectReferences(Collection<IProject> projects, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        HashSet<IProject> projectsWithUnreachableCrossRefrencesToUnresolve = new HashSet<IProject>(projects);
        for (IProject project : projects) {
            Collection referencingProjects = ExtendedPlatform.getAllReferencingProjects((IProject)project);
            projectsWithUnreachableCrossRefrencesToUnresolve.addAll(referencingProjects);
        }
        UnresolveUnreachableCrossProjectReferencesOperation unresolveUnreachableCrossProjectReferencesOperation = new UnresolveUnreachableCrossProjectReferencesOperation(projectsWithUnreachableCrossRefrencesToUnresolve);
        if (async && projectsWithUnreachableCrossRefrencesToUnresolve.size() > 0) {
            UnresolveUnreachableCrossProjectReferencesJob job = new UnresolveUnreachableCrossProjectReferencesJob(unresolveUnreachableCrossProjectReferencesOperation);
            job.setPriority(40);
            job.setRule(unresolveUnreachableCrossProjectReferencesOperation.getRule());
            job.schedule();
        } else {
            try {
                unresolveUnreachableCrossProjectReferencesOperation.run(monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
        }
    }

    public void loadModel(IModelDescriptor modelDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadModel(modelDescriptor, true, async, monitor);
    }

    public void loadModel(IModelDescriptor modelDescriptor, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull((Object)modelDescriptor);
        ModelLoadOperation modelLoadOperation = new ModelLoadOperation(modelDescriptor, includeReferencedScopes);
        LoadOperationRunnerHelper.run(modelLoadOperation, async, monitor);
    }

    public void loadModels(Collection<IModelDescriptor> modelDescriptors, boolean async, IProgressMonitor monitor) {
        this.loadModels(modelDescriptors, true, async, monitor);
    }

    public void loadModels(Collection<IModelDescriptor> modelDescriptors, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(modelDescriptors);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)modelDescriptors.size());
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            this.loadModel(modelDescriptor, includeReferencedScopes, async, (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    public void unloadModel(IModelDescriptor modelDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadModel(modelDescriptor, true, async, monitor);
    }

    public void unloadModel(IModelDescriptor modelDescriptor, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull((Object)modelDescriptor);
        HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
        resourcesToUnload.put(modelDescriptor.getEditingDomain(), modelDescriptor.getLoadedResources(includeReferencedScopes));
        this.internalUnloadResources(resourcesToUnload, true, async, monitor);
    }

    public void unloadModels(Collection<IModelDescriptor> modelDescriptors, boolean async, IProgressMonitor monitor) {
        this.unloadModels(modelDescriptors, true, async, monitor);
    }

    public void unloadModels(Collection<IModelDescriptor> modelDescriptors, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(modelDescriptors);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)modelDescriptors.size());
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            this.unloadModel(modelDescriptor, includeReferencedScopes, async, (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    public void updateResourceURIs(Map<IFile, IPath> filesToUpdate, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(filesToUpdate);
        UpdateResourceURIOperation updateResourceURIOperation = new UpdateResourceURIOperation(filesToUpdate);
        if (async && filesToUpdate.size() > 0) {
            UpdateResourceURIJob job = new UpdateResourceURIJob(updateResourceURIOperation);
            job.setPriority(40);
            job.setRule(updateResourceURIOperation.getRule());
            job.schedule();
        } else {
            try {
                updateResourceURIOperation.run(monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
        }
    }

    private Collection<IFile> getFiles(Collection<URI> uris) {
        HashSet<IFile> files = new HashSet<IFile>();
        if (uris != null) {
            HashSet<URI> modelResourceURIs = new HashSet<URI>();
            for (URI uri : uris) {
                modelResourceURIs.add(uri.trimFragment());
            }
            for (URI modelResourceURI : modelResourceURIs) {
                IFile file = EcorePlatformUtil.getFile((URI)modelResourceURI);
                if (file == null) continue;
                files.add(file);
            }
        }
        return files;
    }
}

