/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sphinx.emf.ecore.ExtendedEObjectImpl;
import org.eclipse.sphinx.examples.hummingbird20.common.Identifiable;

public class Hummingbird20EObjectImpl
extends ExtendedEObjectImpl {
    private static final String[] ESCAPE;

    static {
        String[] stringArray = new String[64];
        stringArray[0] = "%00";
        stringArray[1] = "%01";
        stringArray[2] = "%02";
        stringArray[3] = "%03";
        stringArray[4] = "%04";
        stringArray[5] = "%05";
        stringArray[6] = "%06";
        stringArray[7] = "%07";
        stringArray[8] = "%08";
        stringArray[9] = "%09";
        stringArray[10] = "%0A";
        stringArray[11] = "%0B";
        stringArray[12] = "%0C";
        stringArray[13] = "%0D";
        stringArray[14] = "%0E";
        stringArray[15] = "%0F";
        stringArray[16] = "%10";
        stringArray[17] = "%11";
        stringArray[18] = "%12";
        stringArray[19] = "%13";
        stringArray[20] = "%14";
        stringArray[21] = "%15";
        stringArray[22] = "%16";
        stringArray[23] = "%17";
        stringArray[24] = "%18";
        stringArray[25] = "%19";
        stringArray[26] = "%1A";
        stringArray[27] = "%1B";
        stringArray[28] = "%1C";
        stringArray[29] = "%1D";
        stringArray[30] = "%1E";
        stringArray[31] = "%1F";
        stringArray[32] = "%20";
        stringArray[34] = "%22";
        stringArray[35] = "%23";
        stringArray[37] = "%25";
        stringArray[38] = "%26";
        stringArray[39] = "%27";
        stringArray[44] = "%2C";
        stringArray[47] = "%2F";
        stringArray[58] = "%3A";
        stringArray[60] = "%3C";
        stringArray[62] = "%3E";
        ESCAPE = stringArray;
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        if (eObject instanceof Identifiable) {
            Identifiable identifiable = (Identifiable)eObject;
            String name = identifiable.getName();
            int count = 0;
            for (Object otherEObject : this.eContents()) {
                if (otherEObject == eObject) break;
                if (!(otherEObject instanceof Identifiable)) continue;
                Identifiable otherIdentifiable = (Identifiable)otherEObject;
                String otherName = otherIdentifiable.getName();
                if (!(name == null ? otherName == null : name.equals(otherName))) continue;
                ++count;
            }
            name = name == null ? "%" : Hummingbird20EObjectImpl.eEncodeValue(name);
            return count > 0 ? String.valueOf(name) + "." + count : name;
        }
        return super.eURIFragmentSegment(eStructuralFeature, eObject);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        char firstCharacter;
        int length = uriFragmentSegment.length();
        if (length > 0 && (firstCharacter = uriFragmentSegment.charAt(0)) != '@') {
            int index;
            if (firstCharacter == '%') {
                index = uriFragmentSegment.lastIndexOf("%");
                boolean hasCount = false;
                if (index != 0 && (index == length - 1 || (hasCount = uriFragmentSegment.charAt(index + 1) == '.'))) {
                    String encodedSource = uriFragmentSegment.substring(1, index);
                    String source = "%".equals(encodedSource) ? null : URI.decode((String)encodedSource);
                    int count = 0;
                    if (hasCount) {
                        try {
                            count = Integer.parseInt(uriFragmentSegment.substring(index + 2));
                        }
                        catch (NumberFormatException exception) {
                            throw new WrappedException((Exception)exception);
                        }
                    }
                    for (Object object : this.eContents()) {
                        if (!(object instanceof EAnnotation)) continue;
                        EAnnotation eAnnotation = (EAnnotation)object;
                        String otherSource = eAnnotation.getSource();
                        if (!(source == null ? otherSource == null : source.equals(otherSource)) || count-- != 0) continue;
                        return eAnnotation;
                    }
                    return null;
                }
            }
            String name = (index = uriFragmentSegment.lastIndexOf(".")) == -1 ? uriFragmentSegment : uriFragmentSegment.substring(0, index);
            int count = 0;
            if (index != -1) {
                try {
                    count = Integer.parseInt(uriFragmentSegment.substring(index + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    name = uriFragmentSegment;
                }
            }
            name = "%".equals(name) ? null : URI.decode((String)name);
            for (Object object : this.eContents()) {
                if (!(object instanceof Identifiable)) continue;
                Identifiable identifiable = (Identifiable)object;
                String otherName = identifiable.getName();
                if (!(name == null ? otherName == null : name.equals(otherName)) || count-- != 0) continue;
                return identifiable;
            }
            return null;
        }
        return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    static String eEncodeValue(String value) {
        int length = value.length();
        StringBuilder result = null;
        int i = 0;
        while (i < length) {
            String escape;
            char character = value.charAt(i);
            if (character < ESCAPE.length && (escape = ESCAPE[character]) != null) {
                if (result == null) {
                    result = new StringBuilder(length + 2);
                    result.append(value, 0, i);
                }
                result.append(escape);
            } else if (result != null) {
                result.append(character);
            }
            ++i;
        }
        return result == null ? value : result.toString();
    }
}

