/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.syncing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.internal.metamodel.InternalMetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.syncing.IModelSyncRequest;
import org.eclipse.sphinx.platform.resources.syncing.AbstractResourceSynchronizerDelegate;

public class BasicModelSynchronizerDelegate
extends AbstractResourceSynchronizerDelegate<IModelSyncRequest> {
    public static final BasicModelSynchronizerDelegate INSTANCE = new BasicModelSynchronizerDelegate();

    public void handleProjectCreated(int eventType, IProject project) {
    }

    public void handleProjectOpened(int eventType, IProject project) {
        if (eventType == 1) {
            ((IModelSyncRequest)this.syncRequest).addProjectToLoad(project);
        }
    }

    public void handleProjectDescriptionChanged(int eventType, IProject project) {
        if (eventType == 1) {
            ((IModelSyncRequest)this.syncRequest).addProjectToUnresolveUnreachableCrossReferencesFor(project);
        }
    }

    public void handleProjectClosed(int eventType, IProject project) {
        if (eventType == 1) {
            ((IModelSyncRequest)this.syncRequest).addProjectToUnload(project);
        }
    }

    public void handleProjectRemoved(int eventType, IProject project) {
        if (eventType == 1) {
            ((IModelSyncRequest)this.syncRequest).addProjectToUnload(project);
        }
    }

    public void handleFileAdded(int eventType, IFile file) {
        if (eventType == 1) {
            ((IModelSyncRequest)this.syncRequest).addFileToLoad(file);
        }
    }

    public void handleFileChanged(int eventType, IFile file) {
        URI uri;
        TransactionalEditingDomain editingDomain;
        if (eventType == 1 && !SaveIndicatorUtil.isSaved((EditingDomain)(editingDomain = WorkspaceEditingDomainUtil.getMappedEditingDomain((IFile)file)), (URI)(uri = EcorePlatformUtil.createURI((IPath)file.getFullPath())))) {
            ((IModelSyncRequest)this.syncRequest).addFileToReload(file);
        }
    }

    public void handleFileMoved(int eventType, IFile oldFile, IFile newFile) {
        if (eventType == 1) {
            InternalMetaModelDescriptorRegistry.INSTANCE.moveCachedDescriptor(oldFile, newFile);
            IModelDescriptor oldModelDescriptor = ModelDescriptorRegistry.INSTANCE.getOldModel(oldFile);
            IModelDescriptor newModelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(newFile);
            if (oldModelDescriptor != null && oldModelDescriptor.getScope() != null && (newModelDescriptor == null || newModelDescriptor.getScope() == null)) {
                ((IModelSyncRequest)this.syncRequest).addFileToUnload(oldFile);
            } else if ((oldModelDescriptor == null || oldModelDescriptor.getScope() == null) && newModelDescriptor != null && newModelDescriptor.getScope() != null) {
                ((IModelSyncRequest)this.syncRequest).addFileToLoad(newFile);
            } else if (oldModelDescriptor != null && oldModelDescriptor.getScope() != null && newModelDescriptor != null && newModelDescriptor.getScope() != null) {
                if (!newModelDescriptor.getScope().belongsTo(oldFile, true) || !oldModelDescriptor.getScope().belongsTo(newFile, true)) {
                    ((IModelSyncRequest)this.syncRequest).addFileToUnload(oldFile);
                    ((IModelSyncRequest)this.syncRequest).addFileToLoad(newFile);
                } else {
                    ((IModelSyncRequest)this.syncRequest).addFileToUpdateResourceURIFor(oldFile, newFile.getFullPath());
                }
            }
        }
    }

    public void handleFileRemoved(int eventType, IFile file) {
        if (eventType == 1) {
            ((IModelSyncRequest)this.syncRequest).addFileToUnload(file);
        }
    }
}

