/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.ReportPlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResultTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private int metricsFinPos = this.guidelineHolder.getMetricsNames().length + 1;
    private int guidelineFinPos = this.metricsFinPos + this.guidelineHolder.getGuidelineData().length;
    private static Image HIGHLIGHT_IMAGE = ReportPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/star.gif").createImage();

    public Image getColumnImage(Object object, int n) {
        IProblemItem iProblemItem = (IProblemItem)object;
        if (n == 0) {
            if (iProblemItem.isCanHighlight()) {
                return HIGHLIGHT_IMAGE;
            }
        } else if (n < this.metricsFinPos) {
            return iProblemItem.getEvaluationItem().getMetricsIcons()[n - 1];
        }
        return null;
    }

    public String getColumnText(Object object, int n) {
        IProblemItem iProblemItem = (IProblemItem)object;
        IEvaluationItem iEvaluationItem = iProblemItem.getEvaluationItem();
        if (n != 0) {
            if (n < this.metricsFinPos) {
                return iEvaluationItem.getTableDataMetrics()[n - 1];
            }
            if (n < this.guidelineFinPos) {
                return iEvaluationItem.getTableDataGuideline()[n - this.metricsFinPos];
            }
            switch (n - this.guidelineFinPos) {
                case 0: {
                    return iEvaluationItem.getTableDataTechniques();
                }
                case 1: {
                    return iProblemItem.getLineStrMulti();
                }
                case 2: {
                    return iProblemItem.getDescription();
                }
            }
        }
        return "";
    }
}

