/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessible2;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;

public class InternalAccessibleAction
implements AccessibleAction {
    private IAccessibleAction accessibleAction = null;

    public InternalAccessibleAction(int n) {
        this.accessibleAction = new IAccessibleAction(n);
        this.accessibleAction.AddRef();
    }

    public void dispose() {
        if (this.accessibleAction != null) {
            this.accessibleAction.Release();
            this.accessibleAction = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public int getAccessibleActionCount() {
        if (this.accessibleAction != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleAction.nActions(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public boolean doAccessibleAction(int n) {
        if (this.accessibleAction != null) {
            return this.accessibleAction.doAction(n) == 0;
        }
        return false;
    }

    public String getAccessibleActionDescription(int n) {
        if (this.accessibleAction != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleAction.get_description(n, nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public String[] getAccessibleActionKeyBinding(int n, int n2) {
        if (this.accessibleAction != null && n2 > 0) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            try {
                if (this.accessibleAction.get_keyBinding(n, n2, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    String[] stringArray = InternalAccessible2.getStringArray(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1), true);
                    return stringArray;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public String getAccessibleActionName(int n) {
        if (this.accessibleAction != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleAction.get_name(n, nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public String getLocalizedAccessibleActionName(int n) {
        if (this.accessibleAction != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleAction.get_localizedName(n, nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }
}

