/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util.accessibility;

import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectBaseElement;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.EmbedDrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.content.IStylable;
import org.eclipse.actf.model.dom.odf.draw.ControlElement;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.form.FormControlElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.style.StylePropertiesBase;
import org.eclipse.actf.model.dom.odf.style.TableCellPropertiesElement;
import org.eclipse.actf.model.dom.odf.table.CoveredTableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.eclipse.actf.model.dom.odf.text.PElement;
import org.eclipse.actf.model.dom.odf.text.SequenceElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AccessibilityFixEngine {
    private static final String COLON = ":";
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./ancestor::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='section'][attribute::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='display']='none']");
    private static final Object EXP2 = xpathService.compile("./ancestor::*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table-cell') or (namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='covered-table-cell')]");
    private static final Object EXP3 = xpathService.compile("./ancestor::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table'][parent::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:office:1.0' and local-name()='spreadsheet']]");
    private double odfVersion = -1.0;

    public AccessibilityFixEngine() {
    }

    public AccessibilityFixEngine(double d) {
        this.odfVersion = d;
    }

    public boolean fixShortDesc(ODFElement oDFElement, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (oDFElement instanceof DrawingObjectBaseElement) {
            ODFElement oDFElement2 = null;
            oDFElement2 = this.odfVersion != -1.0 ? ((DrawingObjectBaseElement)oDFElement).getShortDescElement(this.odfVersion) : ((DrawingObjectBaseElement)oDFElement).getShortDescElement();
            if (oDFElement2 == null) {
                Document document = oDFElement.getOwnerDocument();
                if (document instanceof ODFDocument) {
                    Element element = null;
                    ODFDocument oDFDocument = (ODFDocument)document;
                    String string2 = oDFElement.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
                    if (string2 == null) {
                        return false;
                    }
                    if (this.odfVersion == 1.0 || this.odfVersion == -1.0 && oDFDocument.getODFVersion() == 1.0) {
                        element = document.createElement(String.valueOf(string2) + COLON + "desc");
                        element.setTextContent(string);
                    } else if (this.odfVersion > 1.0 || this.odfVersion == -1.0 && oDFDocument.getODFVersion() > 1.0) {
                        element = document.createElement(String.valueOf(string2) + COLON + "title");
                        element.setTextContent(string);
                    }
                    if (element != null) {
                        if (oDFElement instanceof EmbedDrawingObjectElement) {
                            Element element2 = (Element)oDFElement.getParentNode();
                            element2.appendChild(element);
                            return true;
                        }
                        if (oDFElement instanceof DrawingObjectElement) {
                            oDFElement.appendChild(element);
                            return true;
                        }
                    }
                }
            } else {
                oDFElement2.setTextContent(string);
                return true;
            }
        }
        return false;
    }

    public boolean fixLongDesc(ODFElement oDFElement, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (oDFElement instanceof DrawingObjectBaseElement) {
            ODFElement oDFElement2 = null;
            oDFElement2 = this.odfVersion != -1.0 ? ((DrawingObjectBaseElement)oDFElement).getLongDescElement(this.odfVersion) : ((DrawingObjectBaseElement)oDFElement).getLongDescElement();
            if (oDFElement2 == null) {
                Document document = oDFElement.getOwnerDocument();
                if (document instanceof ODFDocument) {
                    Element element = null;
                    ODFDocument oDFDocument = (ODFDocument)document;
                    Element element2 = (Element)oDFElement.getParentNode();
                    if (this.odfVersion > 1.0 || this.odfVersion == -1.0 && oDFDocument.getODFVersion() > 1.0) {
                        String string2 = oDFElement.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
                        if (string2 == null) {
                            return false;
                        }
                        element = document.createElement(String.valueOf(string2) + COLON + "desc");
                        element.setTextContent(string);
                    }
                    if (element != null) {
                        if (oDFElement instanceof EmbedDrawingObjectElement) {
                            element2.appendChild(element);
                            return true;
                        }
                        if (oDFElement instanceof DrawingObjectElement) {
                            oDFElement.appendChild(element);
                            return true;
                        }
                    }
                }
            } else {
                oDFElement2.setTextContent(string);
                return true;
            }
        }
        return false;
    }

    private void expandRepeatedTableRow(TableRowElement tableRowElement) {
        int n = tableRowElement.getAttrTableNumberRowsRepeated();
        if (n != -1) {
            Node node = tableRowElement.getParentNode();
            tableRowElement.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-repeated");
            int n2 = 0;
            while (n2 < n - 1) {
                TableRowElement tableRowElement2 = (TableRowElement)tableRowElement.cloneNode(false);
                node.insertBefore(tableRowElement2, tableRowElement);
                ++n2;
            }
        }
    }

    public boolean fixTableRowHeader(ODFElement oDFElement, int n) {
        if (oDFElement instanceof TableElement) {
            NodeList nodeList = ((TableElement)oDFElement).getTableHeaderRows();
            if (nodeList != null && nodeList.getLength() > 0) {
                return false;
            }
            Document document = oDFElement.getOwnerDocument();
            if (document instanceof ODFDocument) {
                String string = oDFElement.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:table:1.0");
                if (string == null) {
                    return false;
                }
                Element element = document.createElement(String.valueOf(string) + COLON + "table-header-rows");
                List<TableRowElement> list = ((TableElement)oDFElement).getTableRowChildren();
                int n2 = 0;
                while (n2 < list.size()) {
                    this.expandRepeatedTableRow(list.get(n2));
                    ++n2;
                }
                list = ((TableElement)oDFElement).getTableRowChildren();
                if (list.size() == 0 || n > list.size()) {
                    return false;
                }
                Node node = oDFElement.insertBefore(element, list.get(0));
                int n3 = 0;
                while (n3 < n) {
                    TableRowElement tableRowElement = list.get(n3);
                    node.appendChild(tableRowElement);
                    ++n3;
                }
                return true;
            }
        }
        return false;
    }

    private void expandRepeatedTableColumn(TableColumnElement tableColumnElement) {
        int n = tableColumnElement.getAttrTableNumberColumnsRepeated();
        if (n != -1) {
            Node node = tableColumnElement.getParentNode();
            tableColumnElement.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated");
            int n2 = 0;
            while (n2 < n - 1) {
                TableColumnElement tableColumnElement2 = (TableColumnElement)tableColumnElement.cloneNode(false);
                node.insertBefore(tableColumnElement2, tableColumnElement);
                ++n2;
            }
        }
    }

    public boolean fixTableColumnHeader(ODFElement oDFElement, int n) {
        if (oDFElement instanceof TableElement) {
            NodeList nodeList = ((TableElement)oDFElement).getTableHeaderColumns();
            if (nodeList != null && nodeList.getLength() > 0) {
                return false;
            }
            Document document = oDFElement.getOwnerDocument();
            if (document instanceof ODFDocument) {
                String string = oDFElement.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:table:1.0");
                if (string == null) {
                    return false;
                }
                Element element = document.createElement(String.valueOf(string) + COLON + "table-header-columns");
                List<TableColumnElement> list = ((TableElement)oDFElement).getTableColumnChildren();
                int n2 = 0;
                while (n2 < list.size()) {
                    this.expandRepeatedTableColumn(list.get(n2));
                    ++n2;
                }
                list = ((TableElement)oDFElement).getTableColumnChildren();
                if (list.size() == 0 || n > list.size()) {
                    return false;
                }
                Node node = oDFElement.insertBefore(element, list.get(0));
                int n3 = 0;
                while (n3 < n) {
                    TableColumnElement tableColumnElement = list.get(n3);
                    node.appendChild(tableColumnElement);
                    ++n3;
                }
                return true;
            }
        }
        return false;
    }

    public boolean fixTableCaption(ODFElement oDFElement, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (oDFElement instanceof TableElement) {
            SequenceElement sequenceElement = ((TableElement)oDFElement).getTextSequenceElement();
            if (sequenceElement != null) {
                return false;
            }
            Document document = oDFElement.getOwnerDocument();
            if (document instanceof ODFDocument) {
                Element element = null;
                String string2 = oDFElement.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:text:1.0");
                if (string2 == null) {
                    return false;
                }
                String string3 = oDFElement.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                if (string3 == null) {
                    return false;
                }
                Element element2 = document.createElement(String.valueOf(string2) + COLON + "p");
                element2.setAttribute(String.valueOf(string2) + COLON + "style-name", "Table");
                Node node = oDFElement.getParentNode();
                Node node2 = oDFElement.getNextSibling();
                element = node2 == null ? (Element)node.appendChild(element2) : (Element)node.insertBefore(element2, node2);
                if (element != null) {
                    element.appendChild(document.createTextNode("Table "));
                    Element element3 = document.createElement(String.valueOf(string2) + COLON + "sequence");
                    element3.setAttribute(String.valueOf(string2) + COLON + "name", "Table");
                    element3.setAttribute(String.valueOf(string2) + COLON + "formula", "ooow:Table+1");
                    element3.setAttribute(String.valueOf(string3) + COLON + "num-format", "1");
                    element.appendChild(element3);
                    Text text = document.createTextNode(" : " + string);
                    element.appendChild(text);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFormLabelFixCapable(ODFElement oDFElement) {
        FormControlElement formControlElement;
        String string;
        return oDFElement instanceof ControlElement && ((string = (formControlElement = ((ControlElement)oDFElement).getFormControlElement()).getAttrFormControlImplementation()).endsWith("com.sun.star.form.component.CheckBox") || string.endsWith("com.sun.star.form.component.OptionButton") || string.endsWith("com.sun.star.form.component.PushButton") || string.endsWith("com.sun.star.form.component.RadioButton") || string.endsWith("com.sun.star.form.component.GroupBox"));
    }

    public boolean fixFormLabel(ODFElement oDFElement, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (oDFElement instanceof ControlElement) {
            FormControlElement formControlElement = ((ControlElement)oDFElement).getFormControlElement();
            if (formControlElement.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "label")) {
                formControlElement.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "label");
            }
            String string2 = formControlElement.getPrefix();
            formControlElement.setAttribute(String.valueOf(string2) + COLON + "label", string);
            return true;
        }
        return false;
    }

    public boolean fixFormTabStop(ODFElement oDFElement, boolean bl) {
        if (oDFElement instanceof ControlElement) {
            FormControlElement formControlElement = ((ControlElement)oDFElement).getFormControlElement();
            if (formControlElement.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "tab-stop")) {
                formControlElement.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "tab-stop");
            }
            String string = formControlElement.getPrefix();
            formControlElement.setAttribute(String.valueOf(string) + COLON + "tab-stop", new Boolean(bl).toString());
            return true;
        }
        return false;
    }

    public boolean isInvisibleElement(ODFElement oDFElement) {
        NodeList nodeList = xpathService.evalForNodeList(EXP1, (Node)oDFElement);
        return nodeList != null && nodeList.getLength() > 0;
    }

    public String getInvisibleSectionName(ODFElement oDFElement) {
        Element element;
        NodeList nodeList = xpathService.evalForNodeList(EXP1, (Node)oDFElement);
        if (nodeList != null && nodeList.getLength() > 0 && nodeList.item(0) instanceof Element && (element = (Element)nodeList.item(0)).hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name")) {
            return element.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name");
        }
        return null;
    }

    public boolean isProtectedElement(ODFElement oDFElement) {
        Node node;
        NodeList nodeList;
        ODFConstants.ContentType contentType = ODFConstants.ContentType.NONE;
        Element element = oDFElement.getOwnerDocument().getDocumentElement();
        if (element instanceof DocumentContentElement) {
            contentType = ((DocumentContentElement)element).getBodyElement().getContent().getContentType();
        }
        if (contentType != ODFConstants.ContentType.SPREADSHEET) {
            return false;
        }
        if (oDFElement instanceof SpreadSheetElement) {
            SpreadSheetElement spreadSheetElement = (SpreadSheetElement)oDFElement;
            return spreadSheetElement.getAttrTableStructureProtected();
        }
        if (oDFElement instanceof TableElement) {
            TableElement tableElement = (TableElement)oDFElement;
            return tableElement.getAttrTableProtected();
        }
        SpreadSheetElement spreadSheetElement = null;
        Node node2 = null;
        IStylable iStylable = null;
        if (oDFElement instanceof TableCellElement || oDFElement instanceof CoveredTableCellElement) {
            iStylable = (IStylable)((Object)oDFElement);
        } else {
            nodeList = xpathService.evalForNodeList(EXP2, (Node)oDFElement);
            if (nodeList != null && nodeList.getLength() == 1 && ((node = nodeList.item(0)) instanceof TableCellElement || node instanceof CoveredTableCellElement)) {
                iStylable = (IStylable)((Object)node);
            }
        }
        if (iStylable == null) {
            return false;
        }
        nodeList = xpathService.evalForNodeList(EXP3, (Node)oDFElement);
        if (nodeList != null && nodeList.getLength() == 1 && (node = nodeList.item(0)) instanceof TableElement) {
            node2 = (TableElement)node;
        }
        if (node2 == null) {
            return false;
        }
        node = node2.getParentNode();
        if (node instanceof SpreadSheetElement) {
            spreadSheetElement = (SpreadSheetElement)node;
        }
        if (spreadSheetElement == null) {
            return false;
        }
        if (spreadSheetElement.getAttrTableStructureProtected() || node2.getAttrTableProtected()) {
            int n = 0;
            StyleElement styleElement = iStylable.getStyle();
            if (styleElement != null) {
                int n2 = 0;
                while ((long)n2 < styleElement.getPropertySize()) {
                    StylePropertiesBase stylePropertiesBase = styleElement.getPropertyElement(n2);
                    if (stylePropertiesBase instanceof TableCellPropertiesElement) {
                        TableCellPropertiesElement tableCellPropertiesElement = (TableCellPropertiesElement)stylePropertiesBase;
                        n = tableCellPropertiesElement.getAttrStyleCellProtect();
                    }
                    ++n2;
                }
            }
            if (n == 2 || n == 4) {
                return true;
            }
            if (n == 0) {
                if (node2.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protected")) {
                    return node2.getAttrTableProtected();
                }
                if (spreadSheetElement.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "structure-protected")) {
                    return spreadSheetElement.getAttrTableStructureProtected();
                }
            }
        }
        return false;
    }

    public void setSpeakerNotesContent(NotesElement notesElement, String string) {
        DrawingObjectBaseElement drawingObjectBaseElement;
        Object object;
        Node node;
        String[] stringArray = string.split("\n");
        NodeList nodeList = notesElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame");
        if (nodeList == null || nodeList.getLength() <= 0) {
            return;
        }
        Element element = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (node instanceof FrameElement && (object = (drawingObjectBaseElement = (FrameElement)node).getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:presentation:1.0", "class")) != null && ((String)object).equals("notes")) {
                element = drawingObjectBaseElement;
            }
            ++n;
        }
        if (element == null) {
            return;
        }
        NodeList nodeList2 = element.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "text-box");
        if (nodeList2 == null || nodeList2.getLength() != 1) {
            return;
        }
        node = notesElement.getOwnerDocument();
        drawingObjectBaseElement = (TextBoxElement)nodeList2.item(0);
        object = drawingObjectBaseElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
        int n2 = 0;
        while (n2 < stringArray.length) {
            PElement pElement = null;
            pElement = n2 == 0 && object != null && object.getLength() == 1 ? (PElement)object.item(0) : (PElement)node.createElementNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
            drawingObjectBaseElement.appendChild(pElement);
            Text text = node.createTextNode(stringArray[n2]);
            pElement.appendChild(text);
            ++n2;
        }
    }
}

