/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.LinkFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventTopics;
import org.osgi.service.prefs.BackingStoreException;

@Component(service={EventHandler.class})
@EventTopics(value={"org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class WindowsDefenderConfigurator
implements EventHandler {
    private static final String PREFERENCE_EXCLUDED_INSTALLATION_PATH = "windows.defender.excluded.path";
    private static final String PREFERENCE_STARTUP_CHECK_APP = "windows.defender.startup.check.app";
    public static final String PREFERENCE_STARTUP_CHECK_SKIP = "windows.defender.startup.check.skip";
    public static final boolean PREFERENCE_STARTUP_CHECK_SKIP_DEFAULT = false;
    @Reference
    protected IPreferencesService preferences;
    private static final String POWERSHELL_EXE = "powershell.exe";

    public void handleEvent(Event event) {
        if (this.runStartupCheck()) {
            Job job = Job.create((String)WorkbenchMessages.WindowsDefenderConfigurator_statusCheck, m -> {
                String checkedPath;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)10);
                Optional<Path> installLocation = WindowsDefenderConfigurator.getInstallationLocation();
                if (installLocation.isPresent() && !(checkedPath = WindowsDefenderConfigurator.getPreference(ConfigurationScope.INSTANCE).get(PREFERENCE_EXCLUDED_INSTALLATION_PATH, "")).isBlank() && installLocation.get().equals(Path.of(checkedPath, new String[0]))) {
                    return;
                }
                monitor.worked(1);
                WindowsDefenderConfigurator.runExclusionCheck((IProgressMonitor)monitor.split(9), installLocation);
            });
            job.setSystem(true);
            job.schedule();
        }
    }

    protected boolean runStartupCheck() {
        if (Platform.OS.isWindows() && !Platform.inDevelopmentMode()) {
            if (this.preferences.getBoolean(WorkbenchPlugin.PI_WORKBENCH, PREFERENCE_STARTUP_CHECK_SKIP, false, null)) {
                return false;
            }
            String permittedApp = this.preferences.getString(WorkbenchPlugin.PI_WORKBENCH, PREFERENCE_STARTUP_CHECK_APP, "org.eclipse.ui.ide.workbench", null);
            return permittedApp.equals(WindowsDefenderConfigurator.getRunningApplicationId());
        }
        return false;
    }

    private static String getRunningApplicationId() {
        String appId = System.getProperty("eclipse.application");
        if (appId != null) {
            return appId;
        }
        IProduct product = Platform.getProduct();
        return product != null ? product.getApplication() : null;
    }

    public static Boolean runCheckEnforced(IProgressMonitor m) throws CoreException {
        Optional<Path> installLocation = WindowsDefenderConfigurator.getInstallationLocation();
        return WindowsDefenderConfigurator.runExclusionCheck(m, installLocation);
    }

    private static Boolean runExclusionCheck(IProgressMonitor m, Optional<Path> installLocation) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)5);
        if (!WindowsDefenderConfigurator.isWindowsDefenderServiceRunning((IProgressMonitor)monitor.split(1)) || !WindowsDefenderConfigurator.isWindowsDefenderActive((IProgressMonitor)monitor.split(1))) {
            return Boolean.FALSE;
        }
        Display display = Display.getDefault();
        HandlingOption decision = WindowsDefenderConfigurator.askForDefenderHandlingDecision(display);
        if (decision == HandlingOption.EXECUTE_EXCLUSION) {
            if (WindowsDefenderConfigurator.isExclusionTamperProtectionEnabled((IProgressMonitor)monitor.split(1))) {
                display.syncExec(() -> MessageDialog.openError(null, (String)"Exclusion failed", (String)WindowsDefenderConfigurator.bindProductName(WorkbenchMessages.WindowsDefenderConfigurator_exclusionFailed_Protected)));
                WindowsDefenderConfigurator.savePreference(ConfigurationScope.INSTANCE, PREFERENCE_STARTUP_CHECK_SKIP, "true");
                return null;
            }
            try {
                WindowsDefenderConfigurator.excludeDirectoryFromScanning((IProgressMonitor)monitor.split(2));
                WindowsDefenderConfigurator.savePreference(ConfigurationScope.INSTANCE, PREFERENCE_EXCLUDED_INSTALLATION_PATH, installLocation.map(Path::toString).orElse(""));
            }
            catch (IOException e) {
                display.syncExec(() -> MessageDialog.openError(null, (String)"Exclusion failed", (String)WindowsDefenderConfigurator.bindProductName(WorkbenchMessages.WindowsDefenderConfigurator_exclusionFailed)));
            }
        } else if (decision == HandlingOption.IGNORE_THIS_INSTALLATION) {
            WindowsDefenderConfigurator.savePreference(ConfigurationScope.INSTANCE, PREFERENCE_STARTUP_CHECK_SKIP, "true");
        }
        return decision == HandlingOption.EXECUTE_EXCLUSION ? Boolean.TRUE : null;
    }

    private static HandlingOption askForDefenderHandlingDecision(Display display) {
        String message = WindowsDefenderConfigurator.bindProductName(WorkbenchMessages.WindowsDefenderConfigurator_exclusionCheckMessage);
        return (HandlingOption)((Object)display.syncCall(() -> {
            final HandlingOption[] choice = new HandlingOption[1];
            MessageDialog dialog = new MessageDialog(display.getActiveShell(), WorkbenchMessages.WindowsDefenderConfigurator_statusCheck, null, message, 2, 0, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}){

                protected Control createCustomArea(Composite parent) {
                    ButtonFactory radioButtonFactory = WidgetFactory.button((int)80);
                    Button performExclusion = (Button)radioButtonFactory.text(WindowsDefenderConfigurator.bindProductName(WorkbenchMessages.WindowsDefenderConfigurator_performExclusionChoice)).onSelect(e -> {
                        handlingOptionArray[0] = HandlingOption.EXECUTE_EXCLUSION;
                        this.getButton(0).setEnabled(true);
                    }).create((Widget)parent);
                    Point size = performExclusion.computeSize(-1, -1);
                    GridDataFactory.swtDefaults().hint((int)((double)size.x * 0.6), (int)((double)size.y * 2.3)).indent(0, 5).applyTo((Control)performExclusion);
                    Button keepScanning = (Button)radioButtonFactory.text(WindowsDefenderConfigurator.bindProductName(WorkbenchMessages.WindowsDefenderConfigurator_ignoreThisInstallationChoice)).onSelect(e -> {
                        handlingOptionArray[0] = HandlingOption.IGNORE_THIS_INSTALLATION;
                        this.getButton(0).setEnabled(true);
                    }).create((Widget)parent);
                    GridDataFactory.swtDefaults().indent(0, 5).applyTo((Control)keepScanning);
                    if (!PlatformUI.isWorkbenchRunning()) {
                        return parent;
                    }
                    LinkFactory.newLink((int)64).text(WorkbenchMessages.WindowsDefenderConfigurator_detailsAndOptionsLinkText).onSelect(e -> {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, "org.eclipse.ui.preferencePages.Startup", null, null);
                        dialog.setBlockOnOpen(false);
                        dialog.open();
                        this.setReturnCode(1);
                        this.close();
                    }).create((Widget)parent);
                    return parent;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    this.getButton(0).setEnabled(false);
                    this.getButton(1).forceFocus();
                }
            };
            int open = dialog.open();
            return open == 0 ? choice[0] : null;
        }));
    }

    public static String bindProductName(String message) {
        String name = Optional.ofNullable(Platform.getProduct()).map(IProduct::getName).orElse("this application");
        return NLS.bind((String)message, (Object)name);
    }

    public static IEclipsePreferences getPreference(IScopeContext instance) {
        return instance.getNode(WorkbenchPlugin.PI_WORKBENCH);
    }

    public static void savePreference(IScopeContext scope, String key, String value) throws CoreException {
        IEclipsePreferences preferences = WindowsDefenderConfigurator.getPreference(scope);
        if (value != null) {
            preferences.put(key, value);
        } else {
            preferences.remove(key);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)("Failed to safe preference " + String.valueOf(preferences)), (Throwable)e));
        }
    }

    private static Optional<Path> getInstallationLocation() {
        try {
            Location installLocation = Platform.getConfigurationLocation();
            URI location = URIUtil.toURI((URL)installLocation.getURL());
            return Optional.of(Path.of(location));
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.empty();
        }
    }

    private static List<Path> getExecutablePath() {
        String eclipseLauncher = System.getProperty("eclipse.launcher");
        return List.of(Path.of(eclipseLauncher, new String[0]));
    }

    private static boolean isExclusionTamperProtectionEnabled(IProgressMonitor monitor) {
        try {
            List<String> result = WindowsDefenderConfigurator.runPowershell(monitor, "-Command", "Get-ItemPropertyValue -Path 'HKLM:\\SOFTWARE\\Microsoft\\Windows Defender\\Features' -Name 'TPExclusions'");
            return result.size() == 1 && "1".equals(result.get(0));
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isWindowsDefenderServiceRunning(IProgressMonitor monitor) {
        try {
            List<String> result = WindowsDefenderConfigurator.runPowershell(monitor, "-Command", "(Get-Service 'WinDefend').Status");
            return result.size() == 1 && "Running".equalsIgnoreCase(result.get(0));
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("Cannot run program \"powershell.exe\": CreateProcess error=5")) {
                return false;
            }
            ILog.get().error("Failed to obtain 'WinDefend' service state", (Throwable)e);
            return false;
        }
    }

    private static boolean isWindowsDefenderActive(IProgressMonitor monitor) throws CoreException {
        try {
            List<String> lines = WindowsDefenderConfigurator.runPowershell(monitor, "-Command", "(Get-MpComputerStatus).AMRunningMode");
            String onlyLine = lines.size() == 1 ? lines.get(0) : "error";
            return switch (onlyLine.toLowerCase(Locale.ENGLISH).strip()) {
                case "sxs passive mode", "passive mode", "", "not running" -> false;
                case "edr block mode", "normal" -> true;
                default -> throw new IOException("Process terminated with unexpected result:\n" + String.join((CharSequence)"\n", lines));
            };
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)WorkbenchMessages.WindowsDefenderConfigurator_statusCheckFailed, (Throwable)e));
        }
    }

    public static String createAddExclusionsPowershellCommand(String extraSeparator) {
        List<Path> paths = WindowsDefenderConfigurator.getExecutablePath();
        String excludedPaths = paths.stream().map(Path::toString).map(p -> "\"" + p + "\"").collect(Collectors.joining("," + extraSeparator));
        return "Add-MpPreference -ExclusionProcess " + extraSeparator + excludedPaths;
    }

    private static void excludeDirectoryFromScanning(IProgressMonitor monitor) throws IOException {
        String exclusionsCommand = WindowsDefenderConfigurator.createAddExclusionsPowershellCommand("");
        String encodedCommand = Base64.getEncoder().encodeToString(exclusionsCommand.getBytes(StandardCharsets.UTF_16LE));
        WindowsDefenderConfigurator.runPowershell(monitor, "Start-Process", "powershell", "-Verb", "RunAs", "-Wait", "-ArgumentList", "'-EncodedCommand " + encodedCommand + "'");
    }

    private static List<String> runPowershell(IProgressMonitor monitor, String ... arguments) throws IOException {
        return WindowsDefenderConfigurator.runProcess(Stream.concat(Stream.of(POWERSHELL_EXE), Arrays.stream(arguments)).toList(), monitor);
    }

    private static List<String> runProcess(List<String> command, IProgressMonitor monitor) throws IOException {
        ExecutorService newSingleThreadExecutor = Executors.newSingleThreadExecutor();
        Process process = new ProcessBuilder(command).start();
        Future<List> processLines = newSingleThreadExecutor.submit(() -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader inputReader = process.inputReader();){
                return inputReader.lines().filter(l -> !l.isBlank()).map(String::strip).toList();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        newSingleThreadExecutor.shutdown();
        try {
            while (!processLines.isDone()) {
                if (monitor.isCanceled()) {
                    process.destroy();
                    process.descendants().forEach(ProcessHandle::destroy);
                    processLines.cancel(true);
                    throw new OperationCanceledException();
                }
                Thread.onSpinWait();
                Thread.sleep(5L);
            }
            if (process.isAlive()) {
                process.destroyForcibly();
                process.descendants().forEach(ProcessHandle::destroyForcibly);
                throw new IOException("Process timed-out and it was attempted to forcefully termiante it");
            }
            if (process.exitValue() != 0) {
                throw new IOException("Process failed with exit-code " + process.exitValue());
            }
            return processLines.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationCanceledException();
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    private static enum HandlingOption {
        EXECUTE_EXCLUSION,
        IGNORE_THIS_INSTALLATION;

    }
}

