/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.registry.TeamDecoratorDescription;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;

public class TeamDecoratorManager {
    public static final String PT_TEAM_DECORATORS = "teamDecorators";
    private static TeamDecoratorManager instance;
    Map<String, TeamDecoratorDescription> descriptors;

    public static TeamDecoratorManager getInstance() {
        if (instance == null) {
            instance = new TeamDecoratorManager();
        }
        return instance;
    }

    public ITeamContentProviderDescriptor[] getDescriptors() {
        this.lazyInitialize();
        return this.descriptors.values().toArray(new ITeamContentProviderDescriptor[this.descriptors.size()]);
    }

    public TeamDecoratorDescription getDecoratorDescription(String providerId) {
        this.lazyInitialize();
        return this.descriptors.get(providerId);
    }

    protected void lazyInitialize() {
        if (this.descriptors != null) {
            return;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.ui", PT_TEAM_DECORATORS);
        IExtension[] extensions = point.getExtensions();
        this.descriptors = new HashMap<String, TeamDecoratorDescription>(extensions.length * 2 + 1);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            TeamDecoratorDescription desc = null;
            try {
                desc = new TeamDecoratorDescription(extension);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            if (desc != null) {
                this.descriptors.put(desc.getRepositoryId(), desc);
            }
            ++n2;
        }
    }
}

