/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;
import org.eclipse.linuxtools.rpm.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RPMDetailsPanel {
    private Text locationPath;
    private ComboViewer typeCombo;
    private Button defaultSettings;
    private Composite parent;

    public RPMDetailsPanel(Composite parent) {
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.defaultSettings = new Button(this.parent, 32);
        this.defaultSettings.setText(Messages.getString("SRPMImportPage.0"));
        this.defaultSettings.setSelection(true);
        final Group specGrid = new Group(this.parent, 0);
        this.defaultSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RPMDetailsPanel.this.defaultSettings.getSelection()) {
                    Control[] controlArray = specGrid.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        specGrid.setEnabled(false);
                        control.setEnabled(false);
                        ++n2;
                    }
                } else {
                    Control[] controlArray = specGrid.getChildren();
                    int n = controlArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Control control = controlArray[n3];
                        specGrid.setEnabled(true);
                        control.setEnabled(true);
                        ++n3;
                    }
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        specGrid.setLayout((Layout)layout);
        specGrid.setText(Messages.getString("SRPMImportPage.1"));
        specGrid.setLayoutData((Object)new GridData(768));
        specGrid.setEnabled(false);
        Label locationLabel = new Label((Composite)specGrid, 0);
        locationLabel.setText(Messages.getString("SRPMImportPage.2"));
        locationLabel.setEnabled(false);
        this.locationPath = new Text((Composite)specGrid, 2052);
        this.locationPath.setEnabled(false);
        this.locationPath.setLayoutData((Object)new GridData(768));
        Button containerBrowseButton = new Button((Composite)specGrid, 8);
        containerBrowseButton.setText(Messages.getString("SRPMImportPage.3"));
        containerBrowseButton.setLayoutData((Object)new GridData(256));
        containerBrowseButton.setEnabled(false);
        Composite projectTypeGroup = new Composite(this.parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        projectTypeGroup.setLayout((Layout)layout);
        projectTypeGroup.setLayoutData((Object)new GridData(768));
        Label typeLabel = new Label(projectTypeGroup, 0);
        typeLabel.setText(Messages.getString("SRPMImportPage.4"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.typeCombo = new ComboViewer(projectTypeGroup, 8);
        this.typeCombo.getCombo().setLayoutData((Object)gridData);
        this.typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeCombo.setInput((Object)RPMProjectLayout.values());
        this.typeCombo.getCombo().select(0);
    }

    public RPMProjectLayout getSelectedLayout() {
        if (this.defaultSettings.getSelection()) {
            return RPMProjectLayout.RPMBUILD;
        }
        return RPMProjectLayout.valueOf((String)this.typeCombo.getCombo().getItem(this.typeCombo.getCombo().getSelectionIndex()));
    }

    public void setLocationPath(String absolutePath) {
        this.locationPath.setText(absolutePath);
    }

    public IPath getLocationPath() {
        return Path.fromOSString((String)this.locationPath.getText());
    }
}

