/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor;

import java.util.Vector;
import org.eclipse.linuxtools.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.core.state.model.LttngProcessState;
import org.eclipse.linuxtools.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComponent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEvent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.lttng.ui.views.common.AbsTRangeUpdate;
import org.eclipse.linuxtools.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.model.FlowModelFactory;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.model.FlowProcessContainer;

public abstract class AbsFlowTRangeUpdate
extends AbsTRangeUpdate
implements ILttngEventProcessor {
    protected FlowProcessContainer procContainer = FlowModelFactory.getProcContainer();
    protected ParamsUpdater params = FlowModelFactory.getParamsUpdater();
    protected static final Long ANY_CPU = 0L;

    protected TimeRangeEventProcess addLocalProcess(LttngProcessState stateProcess, long traceStartTime, long traceEndTime, String traceId) {
        TimeRangeEventProcess localProcess = new TimeRangeEventProcess((int)this.procContainer.getUniqueId(), stateProcess.getName(), traceStartTime, traceEndTime, "", stateProcess.getType().getInName(), stateProcess.getCpu(), (long)stateProcess.getInsertion_time());
        localProcess.setCreationTime(stateProcess.getCreation_time());
        localProcess.setPid(stateProcess.getPid());
        localProcess.setTgid(stateProcess.getTgid());
        localProcess.setPpid(stateProcess.getPpid());
        localProcess.setName(stateProcess.getName());
        localProcess.setBrand(stateProcess.getBrand());
        localProcess.setTraceID(traceId);
        localProcess.setProcessType(stateProcess.getType().getInName());
        this.procContainer.addItem(localProcess);
        if (TraceDebug.isCFV()) {
            TraceDebug.traceCFV("addLocalProcess():" + localProcess);
        }
        return localProcess;
    }

    protected boolean withinViewRange(long stime, long etime) {
        long windowStartTime = this.params.getStartTime();
        long windowEndTime = this.params.getEndTime();
        if (stime >= windowStartTime && stime <= windowEndTime) {
            return true;
        }
        if (etime >= windowStartTime && etime <= windowEndTime) {
            return true;
        }
        return stime < windowStartTime && etime > windowEndTime;
    }

    protected boolean makeDraw(LttngTraceState traceSt, long startTime, long endTime, TimeRangeEventProcess localProcess, ParamsUpdater params, String stateMode) {
        if (TraceDebug.isCFV()) {
            TraceDebug.traceCFV("makeDraw():[" + localProcess + ",candidate=[stime=" + startTime + ",etime=" + endTime + ",state=" + stateMode + "]]");
        }
        Long stime = startTime;
        Long etime = endTime;
        if (!this.withinViewRange(stime, etime)) {
            params.incrementEventsDiscarded(0);
            return false;
        }
        if (etime < stime) {
            params.incrementEventsDiscardedWrongOrder();
            return false;
        }
        if (stime < params.getStartTime()) {
            long insertion = localProcess.getInsertionTime();
            if (stime == insertion) {
                long halfPage = (params.getEndTime() - params.getStartTime()) / 2L;
                long initTime = params.getStartTime() - halfPage;
                if (initTime > insertion) {
                    stime = initTime;
                }
            }
        }
        double duration = etime - stime;
        double k = this.getPixelsPerNs(traceSt, params);
        double pixels = duration * k;
        boolean visible = true;
        if (pixels < 1.0) {
            boolean prevEventVisibility = true;
            Vector<TimeRangeComponent> inMemEvents = localProcess.getTraceEvents();
            if (inMemEvents.size() != 0) {
                TimeRangeComponent prevEvent = inMemEvents.get(inMemEvents.size() - 1);
                prevEventVisibility = prevEvent.isVisible();
                Long eventSpan = stime - prevEvent.getStartTime();
                if (!prevEventVisibility && (double)eventSpan.longValue() * k < 2.0) {
                    params.incrementEventsDiscarded(1);
                    return false;
                }
            }
            visible = false;
        }
        TimeRangeEvent time_window = new TimeRangeEvent(stime, etime, localProcess, TimeRangeEvent.Type.PROCESS_MODE, stateMode);
        time_window.setVisible(visible);
        localProcess.getTraceEvents().add(time_window);
        localProcess.setNext_good_time(etime);
        return false;
    }

    protected boolean makeDraw(LttngTraceState traceSt, long evTime, LttngProcessState process, TimeRangeEventProcess localProcess, ParamsUpdater params) {
        long stime = localProcess.getNext_good_time();
        StateStrings.ProcessStatus procStatus = process.getState().getProc_status();
        String stateMode = procStatus == StateStrings.ProcessStatus.LTTV_STATE_RUN ? process.getState().getExec_mode().getInName() : procStatus.getInName();
        return this.makeDraw(traceSt, stime, evTime, localProcess, params, stateMode);
    }
}

