/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.event;

import org.eclipse.linuxtools.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.lttng.core.event.LttngEventContent;
import org.eclipse.linuxtools.lttng.core.event.LttngEventType;
import org.eclipse.linuxtools.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class LttngSyntheticEvent
extends LttngEvent {
    public static final LttngSyntheticEvent NullEvent = new LttngSyntheticEvent();
    private SequenceInd sequence = SequenceInd.BEFORE;
    private LttngEvent baseEvent = null;
    private LttngTraceState fTraceModel = null;

    public LttngSyntheticEvent(LttngEvent baseEvent) {
        super(baseEvent);
        this.baseEvent = baseEvent;
    }

    public LttngSyntheticEvent(TmfTrace<LttngEvent> parent, LttngTimestamp timestamp, String source, LttngEventType type, LttngEventContent content, String reference, JniEvent lttEvent) {
        super(parent, timestamp, source, type, content, reference, lttEvent);
    }

    private LttngSyntheticEvent() {
        this(null, null, null, null, null, null, null);
    }

    public SequenceInd getSynType() {
        return this.sequence;
    }

    public void setSequenceInd(SequenceInd sequence) {
        this.sequence = sequence;
    }

    public LttngEvent getBaseEvent() {
        return this.baseEvent;
    }

    public void setTraceModel(LttngTraceState traceModel) {
        this.fTraceModel = traceModel;
    }

    public LttngTraceState getTraceModel() {
        return this.fTraceModel;
    }

    public TmfTrace<LttngEvent> getTrace() {
        if (this.baseEvent != null) {
            return (TmfTrace)this.baseEvent.getTrace();
        }
        return (TmfTrace)super.getTrace();
    }

    @Override
    public void setParentTrace(TmfTrace<LttngEvent> parentTrace) {
        if (this.baseEvent != null) {
            this.baseEvent.setParentTrace(parentTrace);
        } else {
            super.setParentTrace(parentTrace);
        }
    }

    @Override
    public String getChannelName() {
        if (this.baseEvent != null) {
            return this.baseEvent.getChannelName();
        }
        return super.getChannelName();
    }

    @Override
    public long getCpuId() {
        if (this.baseEvent != null) {
            return this.baseEvent.getCpuId();
        }
        return super.getCpuId();
    }

    @Override
    public String getMarkerName() {
        if (this.baseEvent != null) {
            return this.baseEvent.getMarkerName();
        }
        return super.getMarkerName();
    }

    @Override
    public LttngEventContent getContent() {
        if (this.baseEvent != null) {
            return this.baseEvent.getContent();
        }
        return super.getContent();
    }

    @Override
    public void setContent(LttngEventContent newContent) {
        if (this.baseEvent != null) {
            this.baseEvent.setContent(newContent);
        } else {
            super.setContent(newContent);
        }
    }

    @Override
    public LttngEventType getType() {
        if (this.baseEvent != null) {
            return this.baseEvent.getType();
        }
        return super.getType();
    }

    @Override
    public void setType(LttngEventType newType) {
        if (this.baseEvent != null) {
            this.baseEvent.setType(newType);
        } else {
            super.setType(newType);
        }
    }

    @Override
    public void updateJniEventReference(JniEvent newJniEventReference) {
        if (this.baseEvent != null) {
            this.baseEvent.updateJniEventReference(newJniEventReference);
        } else {
            super.updateJniEventReference(newJniEventReference);
        }
    }

    @Override
    public JniEvent convertEventTmfToJni() {
        if (this.baseEvent != null) {
            return this.baseEvent.convertEventTmfToJni();
        }
        return super.convertEventTmfToJni();
    }

    @Override
    public String toString() {
        if (this.baseEvent != null) {
            return this.baseEvent.toString();
        }
        return super.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.baseEvent == null ? 0 : this.baseEvent.hashCode());
        result = 31 * result + (this.fTraceModel == null ? 0 : this.fTraceModel.hashCode());
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LttngSyntheticEvent)) {
            return false;
        }
        LttngSyntheticEvent other = (LttngSyntheticEvent)((Object)obj);
        if (this.baseEvent == null ? other.baseEvent != null : !this.baseEvent.equals((Object)other.baseEvent)) {
            return false;
        }
        if (this.fTraceModel == null ? other.fTraceModel != null : !this.fTraceModel.equals(other.fTraceModel)) {
            return false;
        }
        return this.sequence == other.sequence;
    }

    public static enum SequenceInd {
        STARTREQ,
        BEFORE,
        UPDATE,
        AFTER,
        ENDREQ;

    }
}

