/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.dialogs;

import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.linuxtools.lttng.core.latency.analyzer.EventMatcher;
import org.eclipse.linuxtools.lttng.core.util.EventsPair;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.LatencyController;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialog
extends TitleAreaDialog {
    protected String fDialogTitle;
    protected String fDialogMessage;
    public static final int ADD = 53445;
    public static final int DELETE = 53446;
    public static final int RESET = 53447;
    protected static final String LATENCY_NB_MATCH_PAIRS = "NB_LATENCY_MATCH_PAIRS";
    protected static final String LATENCY_PAIRS_START = "LATENCY_PAIRS_START";
    protected static final String LATENCY_PAIRS_END = "LATENCY_PAIRS_END";
    protected IDialogSettings fSettings;
    protected boolean fRedrawGraphs = false;

    public AbstractDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.fDialogTitle = title;
        this.fDialogMessage = message;
        this.fSettings = LTTngUiPlugin.getDefault().getDialogSettings();
    }

    public AbstractDialog(Shell parentShell, String title) {
        this(parentShell, title, "");
    }

    public AbstractDialog(Shell parentShell) {
        this(parentShell, "", "");
    }

    public void create() {
        super.create();
        this.setTitle(this.fDialogTitle);
        this.setMessage(this.fDialogMessage, 1);
        int windowWidth = Display.getCurrent().getPrimaryMonitor().getBounds().width;
        int windowHeight = Display.getCurrent().getPrimaryMonitor().getBounds().height;
        int dialogWidth = this.getShell().getSize().x;
        int dialogHeight = windowHeight / 2;
        int x = (windowWidth - dialogWidth) / 2;
        int y = (windowHeight - dialogHeight) / 2;
        this.getShell().setSize(this.getShell().getSize().x, dialogHeight);
        this.getShell().setLocation(x, y);
    }

    protected String formatListNumber(int number, int max) {
        return String.format("%0" + max + "d", number);
    }

    protected EventsPair getMatchPairs() {
        try {
            this.fSettings.getInt(LATENCY_NB_MATCH_PAIRS);
            String[] starts = this.fSettings.getArray(LATENCY_PAIRS_START);
            String[] ends = this.fSettings.getArray(LATENCY_PAIRS_END);
            EventMatcher.getInstance().resetMatches();
            int i = 0;
            while (i < starts.length) {
                EventMatcher.getInstance().addMatch(starts[i], ends[i]);
                ++i;
            }
            return EventMatcher.getInstance().getEvents();
        }
        catch (NumberFormatException numberFormatException) {
            return EventMatcher.getInstance().getEvents();
        }
    }

    protected void saveMatchPairs(Vector<String> start, Vector<String> end) {
        this.fSettings.put(LATENCY_NB_MATCH_PAIRS, start.size());
        this.fSettings.put(LATENCY_PAIRS_START, start.toArray(new String[0]));
        this.fSettings.put(LATENCY_PAIRS_END, end.toArray(new String[0]));
    }

    protected void redrawGraphs() {
        LatencyController.getInstance().refreshModels();
    }

    protected abstract Control createDialogArea(Composite var1);

    protected abstract void createButtonsForButtonBar(Composite var1);

    protected boolean isResizable() {
        return true;
    }
}

