/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.model;

import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.lttng.ui.views.distribution.model.DistributionData;
import org.eclipse.linuxtools.lttng.ui.views.distribution.model.HorDistributionData;
import org.eclipse.linuxtools.lttng.ui.views.distribution.model.VerDistributionData;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.GraphScaledData;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.IGraphDataModel;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.IGraphModelListener;

public class LatencyGraphModel
implements IGraphDataModel {
    private final int fNbBuckets;
    private final int[][] fBuckets;
    private final DistributionData fHorDistributionData;
    private final DistributionData fVerDistributionData;
    private long fCurrentEventTime;
    private final ListenerList fModelListeners;
    private final ReentrantLock fLock;

    public LatencyGraphModel() {
        this(2000);
    }

    public LatencyGraphModel(int nbBuckets) {
        this.fNbBuckets = nbBuckets;
        this.fBuckets = new int[nbBuckets][nbBuckets];
        this.fHorDistributionData = new HorDistributionData(nbBuckets, this.fBuckets);
        this.fVerDistributionData = new VerDistributionData(nbBuckets, this.fBuckets);
        this.fCurrentEventTime = -1L;
        this.fModelListeners = new ListenerList();
        this.fLock = new ReentrantLock();
        this.clear();
    }

    public int getNbBuckets() {
        return this.fNbBuckets;
    }

    public long getHorBucketDuration() {
        this.fLock.lock();
        try {
            long l = this.fHorDistributionData.getBucketDuration();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getVerBucketDuration() {
        this.fLock.lock();
        try {
            long l = this.fVerDistributionData.getBucketDuration();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getHorFirstBucketTime() {
        this.fLock.lock();
        try {
            long l = this.fHorDistributionData.getFirstBucketTime();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getVerFirstBucketTime() {
        this.fLock.lock();
        try {
            long l = this.fVerDistributionData.getFirstBucketTime();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getHorFirstEventTime() {
        this.fLock.lock();
        try {
            long l = this.fHorDistributionData.getFirstEventTime();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getVerFirstEventTime() {
        this.fLock.lock();
        try {
            long l = this.fVerDistributionData.getFirstEventTime();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getHorLastEventTime() {
        this.fLock.lock();
        try {
            long l = this.fHorDistributionData.getLastEventTime();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getVerLastEventTime() {
        this.fLock.lock();
        try {
            long l = this.fVerDistributionData.getLastEventTime();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getHorTimeLimit() {
        this.fLock.lock();
        try {
            long l = this.fHorDistributionData.getTimeLimit();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getVerTimeLimit() {
        this.fLock.lock();
        try {
            long l = this.fVerDistributionData.getTimeLimit();
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public int getHorLastBucket() {
        this.fLock.lock();
        try {
            int n = this.fHorDistributionData.getLastBucket();
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public int getVerLastBucket() {
        this.fLock.lock();
        try {
            int n = this.fVerDistributionData.getLastBucket();
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public long getCurrentEventTime() {
        this.fLock.lock();
        try {
            long l = this.fCurrentEventTime;
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void addGraphModelListener(IGraphModelListener listener) {
        this.fModelListeners.add((Object)listener);
    }

    public void removeGraphModelListener(IGraphModelListener listener) {
        this.fModelListeners.remove((Object)listener);
    }

    public void clear() {
        this.fLock.lock();
        try {
            int[][] nArray = this.fBuckets;
            int n = this.fBuckets.length;
            int n2 = 0;
            while (n2 < n) {
                int[] row = nArray[n2];
                Arrays.fill(row, 0, this.fNbBuckets, 0);
                ++n2;
            }
            this.fHorDistributionData.clear();
            this.fVerDistributionData.clear();
        }
        finally {
            this.fLock.unlock();
        }
        this.fireModelUpdateNotification();
    }

    @Override
    public void countEvent(int eventCount, long timestamp, long time) {
        this.fLock.lock();
        try {
            int horIndex = this.fHorDistributionData.countEvent(timestamp);
            int verIndex = this.fVerDistributionData.countEvent(time);
            int[] nArray = this.fBuckets[horIndex];
            int n = verIndex;
            nArray[n] = nArray[n] + 1;
        }
        finally {
            this.fLock.unlock();
        }
        this.fireModelUpdateNotification(eventCount);
    }

    @Override
    public GraphScaledData scaleTo(int width, int height, int barWidth) {
        GraphScaledData scaledData = new GraphScaledData(width, height, barWidth);
        this.fLock.lock();
        try {
            if (!this.fHorDistributionData.isFirst() && !this.fVerDistributionData.isFirst()) {
                if (width <= 0 || height <= 0 || barWidth <= 0) {
                    throw new AssertionError((Object)("Invalid histogram dimensions (" + width + "x" + height + ", barWidth=" + barWidth + ")"));
                }
                int nbBars = width / barWidth;
                int bucketsPerBar = this.fHorDistributionData.getLastBucket() / nbBars + 1;
                int[][] horData = new int[nbBars][this.fNbBuckets];
                int y = 0;
                while (y < this.fNbBuckets) {
                    int i = 0;
                    while (i < nbBars) {
                        int count = 0;
                        int j = i * bucketsPerBar;
                        while (j < (i + 1) * bucketsPerBar) {
                            if (this.fNbBuckets <= j) break;
                            count += this.fBuckets[j][y];
                            ++j;
                        }
                        horData[i][y] = count;
                        ++i;
                    }
                    ++y;
                }
                int nbVerBars = height / barWidth;
                int bucketsPerVerBar = this.fVerDistributionData.getLastBucket() / nbVerBars + 1;
                int[][] verData = new int[nbBars][nbVerBars];
                int x = 0;
                while (x < nbBars) {
                    int i = 0;
                    while (i < nbVerBars) {
                        int count = 0;
                        int j = i * bucketsPerVerBar;
                        while (j < (i + 1) * bucketsPerVerBar) {
                            if (this.fNbBuckets <= j) break;
                            count += horData[x][j];
                            ++j;
                        }
                        verData[x][i] = count;
                        ++i;
                    }
                    ++x;
                }
                scaledData.setData(verData);
                scaledData.setHorFirstBucketTime(this.fHorDistributionData.getFirstBucketTime());
                scaledData.setVerFirstBucketTime(this.fVerDistributionData.getFirstBucketTime());
                scaledData.setHorFirstEventTime(this.fHorDistributionData.getFirstEventTime());
                scaledData.setVerFirstEventTime(this.fVerDistributionData.getFirstEventTime());
                scaledData.setHorLastEventTime(this.fHorDistributionData.getLastEventTime());
                scaledData.setVerLastEventTime(this.fVerDistributionData.getLastEventTime());
                scaledData.setHorBucketDuration((long)bucketsPerBar * this.fHorDistributionData.getBucketDuration());
                scaledData.setVerBucketDuration((long)bucketsPerVerBar * this.fVerDistributionData.getBucketDuration());
                scaledData.setHorLastBucket(this.fHorDistributionData.getLastBucket() / bucketsPerBar);
                scaledData.setVerLastBucket(this.fVerDistributionData.getLastBucket() / bucketsPerVerBar);
                scaledData.setCurrentEventTime(this.fCurrentEventTime);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return scaledData;
    }

    public void complete() {
        this.fireModelUpdateNotification();
    }

    public void setCurrentEvent(long timestamp) {
        this.fLock.lock();
        try {
            this.fCurrentEventTime = timestamp;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void setCurrentEventNotifyListeners(long timestamp) {
        this.fLock.lock();
        try {
            this.fCurrentEventTime = timestamp;
        }
        finally {
            this.fLock.unlock();
        }
        this.fireCurrentEventUpdateNotification();
    }

    private void fireModelUpdateNotification() {
        this.fireModelUpdateNotification(0);
    }

    private void fireModelUpdateNotification(int count) {
        if (count % 10000 == 0) {
            Object[] listeners = this.fModelListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IGraphModelListener listener = (IGraphModelListener)listeners[i];
                listener.graphModelUpdated();
                ++i;
            }
        }
    }

    private void fireCurrentEventUpdateNotification() {
        Object[] listeners = this.fModelListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IGraphModelListener listener = (IGraphModelListener)listeners[i];
            listener.currentEventUpdated(this.fCurrentEventTime);
            ++i;
        }
    }
}

