/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.editors;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.changelog.core.editors.ColorManager;
import org.eclipse.linuxtools.changelog.core.editors.GNUFileEntryRule;
import org.eclipse.linuxtools.changelog.core.editors.IChangeLogColorConstants;

public class GNUElementScanner
extends RuleBasedScanner {
    public static final String FILE_NAME = "_file_name";
    public static final String TEXT = "_text_content";
    public static final String EMAIL = "_author_email";
    public static final String DATE = "_entry_date";
    public static final String AUTHOR = "_author_name";
    public static final String FUNC_NAME = "_function_name";
    public static final String OTHER = "_other";

    public GNUElementScanner(ColorManager manager) {
        Token file = new Token((Object)new TextAttribute(manager.getColor(IChangeLogColorConstants.FILE_NAME)));
        Token func = new Token((Object)new TextAttribute(manager.getColor(IChangeLogColorConstants.FUNC_NAME)));
        Token email = new Token((Object)new TextAttribute(manager.getColor(IChangeLogColorConstants.EMAIL)));
        Token other = new Token((Object)new TextAttribute(manager.getColor(IChangeLogColorConstants.TEXT)));
        IRule[] rules = new IRule[]{new GNUFileEntryRule((IToken)file), new SingleLineRule("(", ")", (IToken)func), new SingleLineRule("<", ">\n", (IToken)email)};
        this.setDefaultReturnToken((IToken)other);
        this.setRules(rules);
    }

    public GNUElementScanner() {
        Token file = new Token((Object)new String(FILE_NAME));
        Token func = new Token((Object)new String(FUNC_NAME));
        Token email = new Token((Object)new String(EMAIL));
        Token other = new Token((Object)new String(OTHER));
        IRule[] rules = new IRule[]{new GNUFileEntryRule((IToken)file), new SingleLineRule("(", "):", (IToken)func), new SingleLineRule("<", ">", (IToken)email)};
        this.setDefaultReturnToken((IToken)other);
        this.setRules(rules);
    }

    public int getOffset() {
        return this.fOffset;
    }

    public IToken getDefaultToken() {
        return this.fDefaultReturnToken;
    }
}

