/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.symbolManager;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.gprof.symbolManager.CallGraphNode;

public class CallGraphArc {
    public final CallGraphNode parent;
    public final CallGraphNode child;
    private int count;
    public String parentPath;
    public int parentLine;

    public CallGraphArc(CallGraphNode parent, IAddress parentAddress, CallGraphNode child, int count, IBinaryParser.IBinaryObject program) {
        this.parent = parent;
        this.child = child;
        this.count = count;
        this.parentPath = STSymbolManager.sharedInstance.getFileName(program, parentAddress);
        this.parentLine = STSymbolManager.sharedInstance.getLineNumber(program, parentAddress);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void print() {
        System.out.print("    ");
        System.out.print(this.parent.getSymbol().getName());
        System.out.print(" -> ");
        System.out.print(this.child.getSymbol().getName());
        System.out.print(" :: ");
        System.out.println(this.count);
    }
}

