/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ImportTraceDialog
extends Dialog {
    public static final String LTTngProjectNatureID = "org.eclipse.linuxtools.lttng.ui.views.project.LTTngProjectNature";
    private TraceResource fTrace;
    private Table fTable;
    private Text fNameText;
    private Button fLinkOnlyButton;
    private IProject fProject;
    private String fTraceName;
    private boolean fLinkOnly = false;

    public ImportTraceDialog(Shell parentShell, TraceResource trace) {
        super(parentShell);
        this.fTrace = trace;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ImportTraceDialog_Title);
        this.getShell().setImage(LTTngUiPlugin.getDefault().getImage("ICON_ID_IMPORT_TRACE"));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        Label tableLabel = new Label(composite, 0);
        tableLabel.setText(Messages.ImportTraceDialog_TableLabel);
        this.fTable = new Table(composite, 67588);
        this.fTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.fTable, 0x1000000);
        column.setText(Messages.ImportTraceDialog_ProjectColumn);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.hasNature(LTTngProjectNatureID)) {
                    TableItem item = new TableItem(this.fTable, 16384);
                    item.setText(0, project.getName());
                    item.setData((Object)project);
                }
            }
            catch (CoreException e) {
                SystemBasePlugin.logError((String)"ImportTraceDialog", (Throwable)e);
            }
            ++n2;
        }
        int i = 0;
        while (i < this.fTable.getColumnCount()) {
            this.fTable.getColumn(i).pack();
            ++i;
        }
        Composite nameComposite = new Composite(composite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        nameComposite.setLayout((Layout)gl);
        Label nameLabel = new Label(nameComposite, 0);
        nameLabel.setText(Messages.ImportTraceDialog_NameLabel);
        this.fNameText = new Text(nameComposite, 2048);
        this.fNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fNameText.setText(this.fTrace.getName());
        if (this.fTrace.getTraceConfig().isNetworkTrace()) {
            this.fLinkOnlyButton = new Button(composite, 32);
            this.fLinkOnlyButton.setText(Messages.ImportTraceDialog_LinkOnly);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(Messages.ImportTraceDialog_ImportButton);
    }

    protected void okPressed() {
        TableItem[] selection = this.fTable.getSelection();
        if (selection.length > 0) {
            this.fProject = (IProject)selection[0].getData();
        }
        this.fTraceName = this.fNameText.getText();
        if (this.fLinkOnlyButton != null) {
            this.fLinkOnly = this.fLinkOnlyButton.getSelection();
        }
        super.okPressed();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getTraceName() {
        return this.fTraceName;
    }

    public boolean getLinkOnly() {
        return this.fLinkOnly;
    }
}

