/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.dialogs;

import java.io.File;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewTraceDialog
extends Dialog {
    private String fTraceName;
    private String fTraceTransport;
    private String fTracePath;
    private int fMode;
    private int fNumChannel;
    private Boolean fIsAppend;
    private Boolean fIsLocal;
    private Text fNameText;
    private Text fTransportText;
    private Text fPathText;
    private Text fNumChannelText;
    private Button fFinishButton;
    private Button fLocalButton;
    private Button fRemoteButton;
    private Button fIsAppendButton;
    private Button fNoneButton;
    private Button fFlightRecorderButton;
    private Button fNormalButton;
    private Boolean fFinishButtonClicked;
    private Display fDisplay;
    private String fTraceNameError;
    private String fTracePathError;
    private Label fErrorLabel;
    private Button fBrowseButton;
    private TraceSubSystem fSubSystem;
    private TargetResource fTargetResource;

    public NewTraceDialog(Shell parent, TraceSubSystem subSystem, TargetResource targetResource) {
        super(parent);
        this.fSubSystem = subSystem;
        this.fTargetResource = targetResource;
    }

    public TraceConfig open() {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67616);
        shell.setText(Messages.NewTraceDialog_Title);
        shell.setLayout((Layout)new GridLayout(3, false));
        shell.setSize(520, 400);
        shell.setMinimumSize(520, 400);
        shell.setImage(LTTngUiPlugin.getDefault().getImage("ICON_ID_NEW_TRACE"));
        GridData griddata = new GridData();
        this.fFinishButtonClicked = false;
        this.fTraceNameError = "";
        this.fTracePathError = "";
        griddata = new GridData();
        Composite composite1 = new Composite((Composite)shell, 0);
        GridLayout compositeLayout1 = new GridLayout(4, false);
        composite1.setSize(520, 300);
        composite1.setLayout((Layout)compositeLayout1);
        griddata.horizontalSpan = 3;
        griddata.widthHint = 520;
        griddata.minimumWidth = 520;
        composite1.setLayoutData((Object)griddata);
        Label nameLabel = new Label(composite1, 0);
        nameLabel.setText(String.valueOf(Messages.NewTraceDialog_TraceName) + ":");
        griddata = new GridData();
        griddata.verticalIndent = 20;
        nameLabel.setLayoutData((Object)griddata);
        this.fNameText = new Text(composite1, 2052);
        if (this.fTargetResource.isUst()) {
            this.fNameText.setText("auto");
            this.fNameText.setEnabled(false);
        }
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 20;
        griddata.horizontalSpan = 3;
        this.fNameText.setLayoutData((Object)griddata);
        this.fNameText.setSize(500, 50);
        Label transportLabel = new Label(composite1, 0);
        transportLabel.setText(String.valueOf(Messages.ConfigureTraceDialog_Trace_Transport) + ":");
        griddata = new GridData();
        transportLabel.setLayoutData((Object)griddata);
        this.fTransportText = new Text(composite1, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalSpan = 3;
        this.fTransportText.setLayoutData((Object)griddata);
        this.fTransportText.setSize(500, 50);
        this.fTransportText.setText("relay");
        this.fTransportText.setEnabled(false);
        griddata = new GridData();
        Group composite21 = new Group(composite1, 8);
        composite21.setSize(300, 300);
        composite21.setText(Messages.ConfigureTraceDialog_Trace_Location);
        griddata.horizontalAlignment = 4;
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 10;
        griddata.widthHint = 300;
        griddata.minimumWidth = 300;
        composite21.setLayoutData((Object)griddata);
        GridLayout compositeLayout21 = new GridLayout(4, false);
        composite21.setLayout((Layout)compositeLayout21);
        this.fRemoteButton = new Button((Composite)composite21, 16);
        this.fRemoteButton.setText(Messages.ConfigureTraceDialog_Remote);
        this.fRemoteButton.setSelection(true);
        this.fLocalButton = new Button((Composite)composite21, 16);
        this.fLocalButton.setText(Messages.ConfigureTraceDialog_Local);
        griddata = new GridData();
        griddata.horizontalSpan = 3;
        this.fLocalButton.setLayoutData((Object)griddata);
        this.fIsLocal = false;
        this.fLocalButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fLocalButton.getSelection()) {
                    NewTraceDialog.this.fIsLocal = true;
                    NewTraceDialog.this.fBrowseButton.setEnabled(true);
                } else {
                    NewTraceDialog.this.fIsLocal = false;
                    NewTraceDialog.this.fBrowseButton.setEnabled(false);
                }
                NewTraceDialog.this.validatePathName(NewTraceDialog.this.fPathText.getText());
                NewTraceDialog.this.validate();
            }
        });
        Label pathLabel = new Label((Composite)composite21, 0);
        pathLabel.setText(Messages.ConfigureTraceDialog_Trace_Path);
        griddata = new GridData();
        griddata.verticalIndent = 10;
        pathLabel.setLayoutData((Object)griddata);
        this.fPathText = new Text((Composite)composite21, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 10;
        this.fPathText.setLayoutData((Object)griddata);
        this.fPathText.setData((Object)"");
        this.fBrowseButton = new Button((Composite)composite21, 8);
        this.fBrowseButton.setText(String.valueOf(Messages.ConfigureTraceDialog_Browse) + "...");
        griddata = new GridData();
        griddata.grabExcessHorizontalSpace = false;
        griddata.widthHint = 100;
        griddata.verticalIndent = 10;
        this.fBrowseButton.setLayoutData((Object)griddata);
        this.fBrowseButton.setEnabled(false);
        this.fBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dialog = new DirectoryDialog(shell);
                String newPath = dialog.open();
                if (newPath != null) {
                    NewTraceDialog.this.fPathText.setText(newPath);
                }
            }
        });
        this.fNameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.validateTraceName(NewTraceDialog.this.fNameText.getText());
                NewTraceDialog.this.validate();
            }
        });
        this.fTransportText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.validate();
            }
        });
        this.fPathText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!NewTraceDialog.this.fPathText.isEnabled()) {
                    return;
                }
                NewTraceDialog.this.validatePathName(NewTraceDialog.this.fPathText.getText());
                NewTraceDialog.this.validate();
            }
        });
        griddata = new GridData();
        Composite composite2 = new Composite(composite1, 0);
        GridLayout compositeLayout2 = new GridLayout(2, false);
        composite2.setLayout((Layout)compositeLayout2);
        griddata.horizontalSpan = 4;
        griddata.widthHint = 500;
        griddata.minimumWidth = 500;
        composite2.setLayoutData((Object)griddata);
        Label numChannelLabel = new Label(composite2, 0);
        numChannelLabel.setText(String.valueOf(Messages.ConfigureTraceDialog_Num_Channels) + ":");
        griddata = new GridData();
        griddata.verticalIndent = 10;
        numChannelLabel.setLayoutData((Object)griddata);
        this.fNumChannelText = new Text(composite2, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 1;
        griddata.verticalIndent = 10;
        griddata.widthHint = 50;
        griddata.minimumWidth = 50;
        this.fNumChannelText.setLayoutData((Object)griddata);
        if (this.fTargetResource.isUst()) {
            this.fNumChannelText.setText("1");
            this.fNumChannelText.setEnabled(false);
        } else {
            this.fNumChannelText.setText("2");
        }
        this.fNumChannelText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.fNumChannelText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.validate();
            }
        });
        this.fIsAppendButton = new Button(composite1, 32);
        this.fIsAppendButton.setText(Messages.ConfigureTraceDialog_Append);
        griddata = new GridData();
        griddata.horizontalAlignment = 1;
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 10;
        this.fIsAppendButton.setLayoutData((Object)griddata);
        this.fIsAppend = false;
        this.fIsAppendButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fIsAppendButton.getSelection()) {
                    NewTraceDialog.this.fIsAppend = true;
                } else {
                    NewTraceDialog.this.fIsAppend = false;
                }
            }
        });
        if (this.fTargetResource.isUst()) {
            this.fIsAppendButton.setEnabled(false);
        }
        griddata = new GridData();
        Group composite22 = new Group(composite1, 8);
        composite22.setText(Messages.ConfigureTraceDialog_Trace_Mode);
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 10;
        composite22.setLayoutData((Object)griddata);
        GridLayout compositeLayout22 = new GridLayout(3, false);
        composite22.setLayout((Layout)compositeLayout22);
        this.fNoneButton = new Button((Composite)composite22, 16);
        this.fNoneButton.setText(Messages.ConfigureTraceDialog_Mode_None);
        this.fNoneButton.setSelection(true);
        this.fFlightRecorderButton = new Button((Composite)composite22, 16);
        this.fFlightRecorderButton.setText(Messages.ConfigureTraceDialog_Mode_Flight_Recorder);
        this.fNormalButton = new Button((Composite)composite22, 16);
        this.fNormalButton.setText(Messages.ConfigureTraceDialog_Mode_Normal);
        this.fMode = 0;
        this.fNoneButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fNoneButton.getSelection()) {
                    NewTraceDialog.this.fMode = 0;
                }
            }
        });
        this.fFlightRecorderButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fFlightRecorderButton.getSelection()) {
                    NewTraceDialog.this.fMode = 1;
                }
            }
        });
        this.fNormalButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fNormalButton.getSelection()) {
                    NewTraceDialog.this.fMode = 2;
                }
            }
        });
        if (this.fTargetResource.isUst()) {
            this.fNoneButton.setEnabled(false);
            this.fFlightRecorderButton.setEnabled(false);
            this.fNormalButton.setEnabled(false);
        }
        this.fErrorLabel = new Label((Composite)shell, 0);
        this.fDisplay = parent.getDisplay();
        this.fErrorLabel.setForeground(this.fDisplay.getSystemColor(3));
        griddata = new GridData();
        griddata.widthHint = 400;
        griddata.minimumWidth = 400;
        this.fErrorLabel.setLayoutData((Object)griddata);
        Label shadow_sep_h = new Label((Composite)shell, 266);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.horizontalSpan = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 20;
        shadow_sep_h.setLayoutData((Object)griddata);
        Button cancelButton = new Button((Composite)shell, 8);
        cancelButton.setText(Messages.ConfigureTraceDialog_Cancel);
        griddata = new GridData();
        griddata.grabExcessHorizontalSpace = false;
        griddata.widthHint = 100;
        griddata.horizontalIndent = 290;
        cancelButton.setLayoutData((Object)griddata);
        this.fFinishButton = new Button((Composite)shell, 8);
        this.fFinishButton.setText(Messages.ConfigureTraceDialog_Finish);
        griddata = new GridData();
        griddata.grabExcessHorizontalSpace = false;
        griddata.widthHint = 100;
        this.fFinishButton.setLayoutData((Object)griddata);
        this.fFinishButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.fFinishButtonClicked = true;
                shell.dispose();
            }
        });
        this.validate();
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.fTraceName = null;
                NewTraceDialog.this.fTraceTransport = null;
                NewTraceDialog.this.fTracePath = null;
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.fTraceName == null || this.fTraceTransport == null || this.fTracePath == null || !this.fFinishButtonClicked.booleanValue()) {
            return null;
        }
        TraceConfig result = new TraceConfig();
        result.setTraceName(this.fTraceName);
        result.setTraceTransport(this.fTraceTransport);
        result.setTracePath(this.fTracePath);
        result.setNetworkTrace(this.fIsLocal.booleanValue());
        result.setIsAppend(this.fIsAppend.booleanValue());
        result.setMode(this.fMode);
        result.setNumChannel(this.fNumChannel);
        return result;
    }

    private boolean validateTraceName(String name) {
        if (name.length() > 0) {
            TraceResource[] traces = new TraceResource[]{};
            try {
                traces = this.fSubSystem.getAllTraces();
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logError((String)"NewTraceDialog ", (Throwable)e);
            }
            int i = 0;
            while (i < traces.length) {
                if (traces[i].getName().compareTo(name) == 0) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Already_Exists;
                    this.fErrorLabel.setText(this.fTraceNameError);
                    return false;
                }
                ++i;
            }
            char[] chars = name.toCharArray();
            int x = 0;
            while (x < chars.length) {
                char c = chars[x];
                if (!(x != 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Invalid_First_Char;
                    this.fErrorLabel.setText(this.fTraceNameError);
                    return false;
                }
                if (!(x == 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Invalid_Name;
                    this.fErrorLabel.setText(this.fTraceNameError);
                    return false;
                }
                ++x;
            }
        }
        if (this.fTracePathError.length() > 0) {
            this.fErrorLabel.setText(this.fTracePathError);
        } else {
            this.fErrorLabel.setText("");
        }
        this.fTraceNameError = "";
        return true;
    }

    private boolean validatePathName(String path) {
        if (path.length() > 0) {
            char c0 = path.charAt(0);
            if (c0 != '/') {
                this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Path;
                this.fErrorLabel.setText(this.fTracePathError);
                return false;
            }
            String[] folders = path.split("/");
            int i = 0;
            while (i < folders.length) {
                char[] chars = folders[i].toCharArray();
                int x = 0;
                while (x < chars.length) {
                    char c = chars[x];
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Folder;
                        this.fErrorLabel.setText(this.fTracePathError);
                        return false;
                    }
                    ++x;
                }
                ++i;
            }
            if (path.length() > 1) {
                i = 0;
                while (i < path.length() - 1) {
                    if (path.charAt(i) == '/' && path.charAt(i + 1) == '/') {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Multiple_Seps;
                        this.fErrorLabel.setText(this.fTracePathError);
                        return false;
                    }
                    ++i;
                }
            }
            if (this.fIsLocal.booleanValue()) {
                File file = new File(path);
                if (file.isFile()) {
                    this.fTracePathError = Messages.ConfigureTraceDialog_Error_File_Exists;
                    this.fErrorLabel.setText(this.fTracePathError);
                    return false;
                }
                if (path.length() > 1 && !file.getParentFile().canWrite()) {
                    this.fTracePathError = Messages.ConfigureTraceDialog_Error_Can_Not_Write;
                    this.fErrorLabel.setText(this.fTracePathError);
                    return false;
                }
            }
        }
        if (this.fTraceNameError.length() > 0) {
            this.fErrorLabel.setText(this.fTraceNameError);
        } else {
            this.fErrorLabel.setText("");
        }
        this.fTracePathError = "";
        return true;
    }

    private void validate() {
        if (this.fNameText.getText() == null || this.fTransportText.getText() == null || this.fTransportText.getText().length() == 0 || this.fNameText.getText().length() == 0 || this.fNumChannelText.getText().length() == 0 || this.fNumChannelText.getText().length() == 0) {
            this.fFinishButton.setEnabled(false);
            return;
        }
        if (this.fPathText.getText().length() == 0) {
            this.fFinishButton.setEnabled(false);
            return;
        }
        if (this.fTracePathError.length() > 0 || this.fTraceNameError.length() > 0) {
            this.fFinishButton.setEnabled(false);
            return;
        }
        this.fTraceName = this.fNameText.getText();
        this.fTraceTransport = this.fTransportText.getText();
        this.fTracePath = this.fPathText.getText();
        this.fNumChannel = Integer.parseInt(this.fNumChannelText.getText());
        this.fFinishButton.setEnabled(true);
    }
}

