/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.AsyncCanvasRedrawer;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvasFocusListener;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramContent;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramView;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class HistogramCanvas
extends Canvas {
    private static HistogramView histogramView = null;
    protected AsyncCanvasRedrawer canvasRedrawer = null;
    protected HistogramContent histogramContent = null;
    protected HistogramCanvasFocusListener focusListener = null;

    public HistogramCanvas(HistogramView histogramView, Composite parent, int style) {
        super(parent, style | 0x20000000);
        HistogramCanvas.histogramView = histogramView;
        this.addNeededListeners();
    }

    protected void addNeededListeners() {
        this.createAndAddCanvasRedrawer();
        this.createAndAddFocusListener();
    }

    protected void createAndAddCanvasRedrawer() {
        this.canvasRedrawer = new AsyncCanvasRedrawer(this);
    }

    protected void createAndAddFocusListener() {
        this.focusListener = new HistogramCanvasFocusListener(this);
        this.addFocusListener(this.focusListener);
    }

    public void createNewHistogramContent(int canvasSize, int widthPerBar, int barsHeight, double maxBarsDifferenceToAverage) {
        this.histogramContent = new HistogramContent(canvasSize / widthPerBar, canvasSize, widthPerBar, barsHeight, maxBarsDifferenceToAverage);
    }

    public HistogramContent getHistogramContent() {
        return this.histogramContent;
    }

    public void redrawAsynchronously() {
        if (this.canvasRedrawer == null) {
            this.canvasRedrawer = new AsyncCanvasRedrawer(this);
        }
        this.canvasRedrawer.asynchronousRedraw();
    }

    public void notifyParentUpdatedInformationAsynchronously() {
        if (this.canvasRedrawer == null) {
            this.canvasRedrawer = new AsyncCanvasRedrawer(this);
        }
        this.canvasRedrawer.asynchronousNotifyParentUpdatedInformation();
    }

    public void notifyParentUpdatedInformation() {
    }

    public static HistogramView getHistogramView() {
        return histogramView;
    }

    public static void setHistogramView(HistogramView histogramView) {
        HistogramCanvas.histogramView = histogramView;
    }
}

