/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.ChildrenHistogramCanvas;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvas;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramContent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class HistogramCanvasPaintListener
implements PaintListener {
    private static ChildrenHistogramCanvas childrenCanvas = null;
    protected boolean isFinished = false;
    private final String DATA_KEY = "double-buffer-image";

    public HistogramCanvasPaintListener() {
    }

    public HistogramCanvasPaintListener(ChildrenHistogramCanvas newCanvas) {
        childrenCanvas = newCanvas;
    }

    public void paintControl(PaintEvent event) {
        if (HistogramCanvasPaintListener.childrenCanvas.getSize().x > 0 && HistogramCanvasPaintListener.childrenCanvas.getSize().y > 0) {
            Image image = (Image)childrenCanvas.getData("double-buffer-image");
            if (image == null || image.getBounds().width != HistogramCanvasPaintListener.childrenCanvas.getBounds().width || image.getBounds().height != HistogramCanvasPaintListener.childrenCanvas.getBounds().height) {
                image = new Image((Device)event.display, HistogramCanvasPaintListener.childrenCanvas.getBounds().width, HistogramCanvasPaintListener.childrenCanvas.getBounds().height);
                childrenCanvas.setData("double-buffer-image", image);
            }
            GC imageGC = new GC((Drawable)image);
            this.clearDrawingSection(imageGC, image, childrenCanvas);
            if (childrenCanvas.getHistogramContent() != null && childrenCanvas.getHistogramContent().getReadyUpToPosition() != 0) {
                this.drawHistogram(imageGC, image);
                if (childrenCanvas.getHistogramContent().getSelectedEventTimeInWindow() > 0L) {
                    this.drawSelectedEventInWindow(imageGC, image);
                }
                event.gc.drawImage(image, 0, 0);
            }
            imageGC.dispose();
        }
    }

    public void clearDrawingSection(GC imageGC, Image image, HistogramCanvas ourCanvas) {
        imageGC.setBackground(ourCanvas.getDisplay().getSystemColor(1));
        imageGC.fillRectangle(0, 0, image.getBounds().width + 1, image.getBounds().height + 1);
    }

    public synchronized void drawHistogram(GC imageGC, Image image) {
        imageGC.setBackground(new Color(imageGC.getDevice(), 74, 112, 139));
        int x = 0;
        while (x < childrenCanvas.getHistogramContent().getReadyUpToPosition()) {
            imageGC.fillRectangle(childrenCanvas.getHistogramContent().getBarsWidth() * x, image.getBounds().height - HistogramCanvasPaintListener.childrenCanvas.getHistogramContent().getElementByIndex((int)x).intervalHeight, childrenCanvas.getHistogramContent().getBarsWidth(), HistogramCanvasPaintListener.childrenCanvas.getHistogramContent().getElementByIndex((int)x).intervalHeight);
            ++x;
        }
    }

    public synchronized void drawSelectedEventInWindow(GC imageGC, Image image) {
        HistogramContent tmpContent = childrenCanvas.getHistogramContent();
        int tmpBarWidth = tmpContent.getBarsWidth();
        int position = tmpContent.getClosestXPositionFromTimestamp(tmpContent.getSelectedEventTimeInWindow());
        imageGC.setForeground(childrenCanvas.getDisplay().getSystemColor(3));
        imageGC.setLineWidth(1);
        imageGC.drawLine(tmpBarWidth * position, 0, tmpBarWidth * position, image.getBounds().height);
    }

    public void setIsFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }
}

