/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.AsyncTimeTextGroupRedrawer;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramConstant;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramView;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TimeTextGroup
implements FocusListener,
KeyListener {
    private static final String LONGEST_STRING_VALUE = ".9223372036854775807";
    private static final int MAX_CHAR_IN_TEXTBOX = ".9223372036854775807".length();
    private static final int VERY_SMALL_FONT_MODIFIER = 2;
    private static final int SMALL_FONT_MODIFIER = 1;
    private HistogramView parentView = null;
    private AsyncTimeTextGroupRedrawer asyncRedrawer = null;
    private Group grpName = null;
    private Text txtNanosec = null;
    private Label lblNanosec = null;
    private long timeValue = 0L;

    public TimeTextGroup(HistogramView newParentView, Composite parent, int textStyle, int groupStyle) {
        this(newParentView, parent, textStyle, groupStyle, "", HistogramConstant.formatNanoSecondsTime(0L), false);
    }

    public TimeTextGroup(HistogramView newParentView, Composite parent, int textStyle, int groupStyle, boolean isSpaceSaverNeeded) {
        this(newParentView, parent, textStyle, groupStyle, "", HistogramConstant.formatNanoSecondsTime(0L), isSpaceSaverNeeded);
    }

    public TimeTextGroup(HistogramView newParentView, Composite parent, int textStyle, int groupStyle, String groupValue, String textValue) {
        this(newParentView, parent, textStyle, groupStyle, groupValue, textValue, false);
    }

    public TimeTextGroup(HistogramView newParentView, Composite parent, int textStyle, int groupStyle, String groupValue, String textValue, boolean isSpaceSaverNeeded) {
        Font font = parent.getFont();
        FontData tmpFontData = font.getFontData()[0];
        Font smallFont = null;
        int textBoxSize = -1;
        if (isSpaceSaverNeeded) {
            smallFont = new Font(font.getDevice(), tmpFontData.getName(), tmpFontData.getHeight() - 2, tmpFontData.getStyle());
            textBoxSize = 0;
        } else {
            smallFont = new Font(font.getDevice(), tmpFontData.getName(), tmpFontData.getHeight() - 1, tmpFontData.getStyle());
            textBoxSize = HistogramConstant.getTextSizeInControl(parent, LONGEST_STRING_VALUE);
        }
        this.parentView = newParentView;
        GridLayout gridLayoutgroup = new GridLayout(1, false);
        gridLayoutgroup.horizontalSpacing = 0;
        gridLayoutgroup.verticalSpacing = 0;
        this.grpName = new Group(parent, groupStyle);
        this.grpName.setText(groupValue);
        this.grpName.setFont(smallFont);
        this.grpName.setLayout((Layout)gridLayoutgroup);
        this.txtNanosec = new Text((Composite)this.grpName, textStyle);
        this.txtNanosec.setTextLimit(MAX_CHAR_IN_TEXTBOX);
        this.txtNanosec.setText(textValue);
        this.txtNanosec.setFont(smallFont);
        GridData gridDataTextBox = new GridData(16384, 0x1000000, true, false);
        gridDataTextBox.horizontalIndent = 0;
        gridDataTextBox.verticalIndent = 0;
        gridDataTextBox.minimumWidth = textBoxSize;
        this.txtNanosec.setLayoutData((Object)gridDataTextBox);
        this.addNeededListeners();
    }

    protected void addNeededListeners() {
        this.asyncRedrawer = new AsyncTimeTextGroupRedrawer(this);
        this.txtNanosec.addFocusListener((FocusListener)this);
        this.txtNanosec.addKeyListener((KeyListener)this);
    }

    public Object getLayoutData() {
        return this.grpName.getLayoutData();
    }

    public void setLayoutData(Object layoutData) {
        this.grpName.setLayoutData(layoutData);
    }

    public Composite getParent() {
        return this.grpName.getParent();
    }

    public void setParent(Composite newParent) {
        this.grpName.setParent(newParent);
        this.txtNanosec.setParent(newParent);
        this.lblNanosec.setParent(newParent);
    }

    public boolean isDisposed() {
        return this.grpName.isDisposed();
    }

    public long getValue() {
        return this.timeValue;
    }

    public void setValue(String newTimeAsString) {
        long timeAsLong = HistogramConstant.convertStringToNanoseconds(newTimeAsString);
        this.setValue(timeAsLong);
    }

    public void setValue(long newTime) {
        this.timeValue = newTime;
        this.txtNanosec.setText(HistogramConstant.formatNanoSecondsTime(newTime));
    }

    public void setValueAsynchronously(String newTimeAsString) {
        long timeAsLong = HistogramConstant.convertStringToNanoseconds(newTimeAsString);
        this.setValueAsynchronously(timeAsLong);
    }

    public void setValueAsynchronously(long newTime) {
        this.timeValue = newTime;
        if (this.asyncRedrawer == null) {
            this.asyncRedrawer = new AsyncTimeTextGroupRedrawer(this);
        }
        this.asyncRedrawer.asynchronousSetValue(newTime);
    }

    public void setGroupName(String newName) {
        this.grpName.setText(newName);
    }

    public void setGroupNameAsynchronously(String newGroupName) {
        if (this.asyncRedrawer == null) {
            this.asyncRedrawer = new AsyncTimeTextGroupRedrawer(this);
        }
        this.asyncRedrawer.asynchronousSetGroupName(newGroupName);
    }

    public void redrawAsynchronously() {
        if (this.asyncRedrawer == null) {
            this.asyncRedrawer = new AsyncTimeTextGroupRedrawer(this);
        }
        this.asyncRedrawer.asynchronousRedraw();
    }

    public void redraw() {
        this.grpName.redraw();
        this.txtNanosec.redraw();
        this.lblNanosec.redraw();
    }

    protected void handleNewStringValue() {
        String valueInText = this.txtNanosec.getText();
        long valueAsLong = HistogramConstant.convertStringToNanoseconds(valueInText);
        if (this.getValue() != valueAsLong) {
            this.setValue(valueAsLong);
            this.notifyParentUpdatedTextGroupValue();
        }
    }

    public void notifyParentUpdatedTextGroupValue() {
        this.parentView.timeTextGroupChangeNotification();
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        this.handleNewStringValue();
    }

    public void keyPressed(KeyEvent event) {
        switch (event.keyCode) {
            case 13: {
                this.handleNewStringValue();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

