/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.lttng.ui.views.project.ProjectView;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.NewProjectWizard;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectRoot;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewProjectHandler
implements IHandler {
    private LTTngProjectRoot fProjectRoot = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPart part = window.getActivePage().getActivePart();
        if (!(part instanceof ProjectView)) {
            return false;
        }
        this.fProjectRoot = ((ProjectView)part).getRoot();
        return this.fProjectRoot != null;
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NewProjectWizard wizard = new NewProjectWizard();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (project = wizard.getProject()) != null && this.fProjectRoot != null) {
            this.fProjectRoot.refreshChildren();
            this.fProjectRoot.refresh();
        }
        return null;
    }

    public void dispose() {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

