/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.event;

import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.event.LttngEventContent;
import org.eclipse.linuxtools.lttng.event.LttngEventReference;
import org.eclipse.linuxtools.lttng.event.LttngEventType;
import org.eclipse.linuxtools.lttng.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.lttng.state.model.LttngTraceState;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.trace.TmfTrace;

public class LttngSyntheticEvent
extends LttngEvent {
    public static final LttngSyntheticEvent NullEvent = new LttngSyntheticEvent();
    private SequenceInd sequence = SequenceInd.BEFORE;
    private LttngEvent baseEvent = null;
    private LttngTraceState fTraceModel = null;

    public LttngSyntheticEvent(LttngEvent baseEvent) {
        super(baseEvent);
        this.baseEvent = baseEvent;
    }

    public LttngSyntheticEvent(TmfTrace<LttngEvent> parent, LttngTimestamp timestamp, TmfEventSource source, LttngEventType type, LttngEventContent content, LttngEventReference reference, JniEvent lttEvent) {
        super(parent, timestamp, source, type, content, reference, lttEvent);
    }

    private LttngSyntheticEvent() {
        this(null, null, null, null, null, null, null);
    }

    public SequenceInd getSynType() {
        return this.sequence;
    }

    public void setSequenceInd(SequenceInd sequence) {
        this.sequence = sequence;
    }

    public LttngEvent getBaseEvent() {
        return this.baseEvent;
    }

    public void setTraceModel(LttngTraceState traceModel) {
        this.fTraceModel = traceModel;
    }

    public LttngTraceState getTraceModel() {
        return this.fTraceModel;
    }

    @Override
    public TmfTrace<LttngEvent> getParentTrace() {
        if (this.baseEvent != null) {
            return this.baseEvent.getParentTrace();
        }
        return super.getParentTrace();
    }

    @Override
    public void setParentTrace(TmfTrace<LttngEvent> parentTrace) {
        if (this.baseEvent != null) {
            this.baseEvent.setParentTrace(parentTrace);
        } else {
            super.setParentTrace(parentTrace);
        }
    }

    @Override
    public String getChannelName() {
        if (this.baseEvent != null) {
            return this.baseEvent.getChannelName();
        }
        return super.getChannelName();
    }

    @Override
    public long getCpuId() {
        if (this.baseEvent != null) {
            return this.baseEvent.getCpuId();
        }
        return super.getCpuId();
    }

    @Override
    public String getMarkerName() {
        if (this.baseEvent != null) {
            return this.baseEvent.getMarkerName();
        }
        return super.getMarkerName();
    }

    @Override
    public LttngEventContent getContent() {
        if (this.baseEvent != null) {
            return this.baseEvent.getContent();
        }
        return super.getContent();
    }

    @Override
    public void setContent(LttngEventContent newContent) {
        if (this.baseEvent != null) {
            this.baseEvent.setContent(newContent);
        } else {
            super.setContent(newContent);
        }
    }

    @Override
    public LttngEventType getType() {
        if (this.baseEvent != null) {
            return this.baseEvent.getType();
        }
        return super.getType();
    }

    @Override
    public void setType(LttngEventType newType) {
        if (this.baseEvent != null) {
            this.baseEvent.setType(newType);
        } else {
            super.setType(newType);
        }
    }

    @Override
    public void updateJniEventReference(JniEvent newJniEventReference) {
        if (this.baseEvent != null) {
            this.baseEvent.updateJniEventReference(newJniEventReference);
        } else {
            super.updateJniEventReference(newJniEventReference);
        }
    }

    @Override
    public JniEvent convertEventTmfToJni() {
        if (this.baseEvent != null) {
            return this.baseEvent.convertEventTmfToJni();
        }
        return super.convertEventTmfToJni();
    }

    public boolean isNullRef() {
        return this == NullEvent;
    }

    @Override
    public String toString() {
        if (this.baseEvent != null) {
            return this.baseEvent.toString();
        }
        return super.toString();
    }

    public static enum SequenceInd {
        STARTREQ,
        BEFORE,
        UPDATE,
        AFTER,
        ENDREQ;

    }
}

