/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentFolderNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteTraceHandler
extends AbstractHandler {
    private TmfTraceNode fTrace = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof ProjectView)) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.tmf.ui.views.project");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            TmfTraceNode tmfTraceNode = this.fTrace = element instanceof TmfTraceNode ? (TmfTraceNode)element : null;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource resource = this.fTrace.getResource();
        ITmfProjectTreeNode parent = this.fTrace.getParent();
        try {
            if (!(parent instanceof TmfExperimentNode)) {
                TmfExperimentFolderNode experimentFolder = this.fTrace.getProject().getExperimentsFolder();
                for (ITmfProjectTreeNode experiment : experimentFolder.getChildren()) {
                    int i = 0;
                    while (i < experiment.getChildren().size()) {
                        TmfTraceNode trace = (TmfTraceNode)experiment.getChildren().get(i);
                        if (trace.getResource().getLocation().equals((Object)resource.getLocation())) {
                            experiment.removeChild(trace);
                            experiment.refresh();
                            trace.getResource().delete(true, null);
                        }
                        ++i;
                    }
                }
            }
            parent.removeChild(this.fTrace);
            parent.refresh();
            resource.delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

