/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectRoot;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RefreshHandler
extends AbstractHandler {
    private TmfProjectRoot fProjectRoot = null;

    public boolean isEnabled() {
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        ISelection selection = window.getActivePage().getSelection("org.eclipse.linuxtools.tmf.ui.views.project");
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfProjectTreeNode) {
            ITmfProjectTreeNode node = (ITmfProjectTreeNode)element;
            while (node != null && !(node instanceof TmfProjectRoot)) {
                node = node.getParent();
            }
            TmfProjectRoot tmfProjectRoot = this.fProjectRoot = node instanceof TmfProjectRoot ? (TmfProjectRoot)node : null;
        }
        return this.fProjectRoot != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            root.refreshLocal(2, null);
            this.fProjectRoot.refreshChildren();
        }
        catch (CoreException e) {
            throw new ExecutionException("CoreException", (Throwable)e);
        }
        return null;
    }
}

