/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.callgraph.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.callgraph.core.Messages;
import org.eclipse.linuxtools.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.TextConsole;

public class Helper {
    public static TextConsole getConsoleByName(String name) {
        int i = 0;
        while (i < ConsolePlugin.getDefault().getConsoleManager().getConsoles().length) {
            if (ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i].getName().contains(name)) {
                return (TextConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i];
            }
            ++i;
        }
        return null;
    }

    public static String getMainConsoleTextByName(String name) {
        TextConsole proc = Helper.getConsoleByName(name);
        return proc.getDocument().get();
    }

    public static IDocument getConsoleDocumentByName(String name) {
        return Helper.getConsoleByName(name).getDocument();
    }

    public static void writeToFile(String absoluteFilePath, String content) {
        try {
            FileWriter fstream = new FileWriter(absoluteFilePath);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(content);
            out.close();
        }
        catch (Exception e) {
            SystemTapUIErrorMessages err = new SystemTapUIErrorMessages(Messages.getString("SystemTapView.FileIOErr"), Messages.getString("SystemTapView.FileIOErr"), Messages.getString("SystemTapView.FileIOErrMsg"));
            err.schedule();
            e.printStackTrace();
        }
    }

    public static void appendToFile(String absoluteFilePath, String content) {
        try {
            FileWriter fstream = new FileWriter(absoluteFilePath, true);
            BufferedWriter out = new BufferedWriter(fstream);
            out.append(content);
            out.close();
        }
        catch (Exception e) {
            SystemTapUIErrorMessages err = new SystemTapUIErrorMessages(Messages.getString("SystemTapView.FileIOErr"), Messages.getString("SystemTapView.FileIOErr"), Messages.getString("SystemTapView.FileIOErrMsg"));
            err.schedule();
            e.printStackTrace();
        }
    }

    public static String readFile(String absoluteFilePath) {
        try {
            String output = "";
            String tmp = "";
            BufferedReader bw = new BufferedReader(new FileReader(new File(absoluteFilePath)));
            while ((tmp = bw.readLine()) != null) {
                output = String.valueOf(output) + tmp + "\n";
            }
            bw.close();
            return output;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static BufferedWriter setBufferedWriter(String absoluteFilePath) {
        try {
            File f = new File(absoluteFilePath);
            f.delete();
            f.createNewFile();
            FileWriter fstream = new FileWriter(absoluteFilePath, true);
            return new BufferedWriter(fstream);
        }
        catch (Exception e) {
            SystemTapUIErrorMessages err = new SystemTapUIErrorMessages(Messages.getString("SystemTapView.FileIOErr"), Messages.getString("SystemTapView.FileIOErr"), Messages.getString("SystemTapView.FileIOErrMsg"));
            err.schedule();
            e.printStackTrace();
            return null;
        }
    }
}

