/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.model;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.lttng.TraceDebug;
import org.eclipse.linuxtools.lttng.model.ILTTngTreeNode;
import org.eclipse.linuxtools.tmf.event.TmfData;

public abstract class LTTngTreeNodeGeneric<E extends LTTngTreeNodeGeneric<E>>
extends TmfData
implements ILTTngTreeNode<E> {
    private final Long fid;
    private final Object ftype;
    private final Object fvalue;
    protected final Map<Long, E> fchildren = new HashMap<Long, E>();
    protected final Map<String, E> fchildrenByName = new HashMap<String, E>();
    protected final Map<String, Object> fattributesByName = new HashMap<String, Object>();
    private E fparent = null;
    private final String fname;
    private Long idCount = 0L;

    public LTTngTreeNodeGeneric(Long id, E parent, String name, Object value) {
        this.fid = id;
        this.fparent = parent;
        this.fname = name;
        if (value != null) {
            this.fvalue = value;
            this.ftype = this.fvalue.getClass();
        } else {
            this.fvalue = this;
            this.ftype = this.getClass();
        }
    }

    public LTTngTreeNodeGeneric(Long id, E parent, String name) {
        this(id, parent, name, null);
    }

    public LTTngTreeNodeGeneric(Long id, String name, Object value) {
        this(id, null, name, value);
    }

    @Override
    public Long getId() {
        return this.fid;
    }

    @Override
    public Object getType() {
        return this.ftype;
    }

    @Override
    public E getChildByName(String name) {
        LTTngTreeNodeGeneric child = null;
        if (name != null) {
            child = (LTTngTreeNodeGeneric)this.fchildrenByName.get(name);
        }
        return (E)child;
    }

    public void addChild(E child) {
        Long id;
        if (child != null && (id = ((LTTngTreeNodeGeneric)child).getId()) != null) {
            if (this.fchildren.containsKey(id) && this.fchildren.get(id) != child) {
                TraceDebug.debug("Replaced child " + id + " for: " + child);
            }
            this.fchildren.put(id, child);
            this.fchildrenByName.put(((LTTngTreeNodeGeneric)child).getName(), child);
        }
    }

    public void removeChild(E child) {
        LTTngTreeNodeGeneric childToRemove;
        Long id;
        if (child != null && (id = ((LTTngTreeNodeGeneric)child).getId()) != null && (childToRemove = (LTTngTreeNodeGeneric)this.fchildren.remove(id)) != null) {
            this.fchildrenByName.remove(childToRemove.getName());
        }
    }

    @Override
    public abstract E[] getChildren();

    protected E[] childrenToArray(Collection<E> collection, Class<? extends E> k) {
        if (collection == null || k == null) {
            return null;
        }
        int size = collection.size();
        LTTngTreeNodeGeneric[] childrenArray = (LTTngTreeNodeGeneric[])Array.newInstance(k, size);
        int i = 0;
        for (LTTngTreeNodeGeneric item : collection) {
            childrenArray[i++] = item;
        }
        return childrenArray;
    }

    @Override
    public E getChildById(Long id) {
        if (id == null) {
            return null;
        }
        return (E)((LTTngTreeNodeGeneric)this.fchildren.get(id));
    }

    @Override
    public E getParent() {
        return this.fparent;
    }

    public void setParent(E parent) {
        this.fparent = parent;
    }

    @Override
    public boolean hasChildren() {
        return this.fchildren.size() > 0;
    }

    @Override
    public String getName() {
        return this.fname;
    }

    @Override
    public String getPath() {
        return this.getPath(this, "");
    }

    private String getPath(LTTngTreeNodeGeneric<E> child, String ipath) {
        String path = ipath;
        if (ipath != null) {
            if (child == null) {
                return ipath;
            }
            ILTTngTreeNode parent = child.getParent();
            path = this.getPath((LTTngTreeNodeGeneric<E>)parent, "/" + child.getName() + ipath);
        }
        return path;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == this.ftype) {
            return this.fvalue;
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.fvalue;
    }

    @Override
    public synchronized Long getNextUniqueId() {
        this.idCount = this.idCount + 1L;
        if (this.idCount > 0xFFFFFFFL) {
            this.idCount = 0L;
        }
        return this.idCount | 0x60000000L;
    }

    @Override
    public <T> T getAttribute(String key, Class<T> type) {
        Object value;
        if (key != null && (value = this.fattributesByName.get(key)).getClass().isAssignableFrom(type)) {
            return (T)value;
        }
        return null;
    }

    @Override
    public boolean addAttribute(String key, Object value) {
        if (key == null || value == null) {
            return false;
        }
        this.fattributesByName.put(key, value);
        return true;
    }

    public boolean isNullRef() {
        return false;
    }
}

