/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.editors;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceParserUpdatedSignal;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IGotoMarker;
import org.osgi.framework.Bundle;

public class TmfEventsEditor
extends TmfEditor
implements ITmfTraceEditor,
IReusableEditor,
IPropertyListener,
IResourceChangeListener {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.editors.events";
    private TmfEventsTable fEventsTable;
    private IResource fResource;
    private ITmfTrace<?> fTrace;
    private Composite fParent;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof TmfEditorInput) {
            this.fResource = ((TmfEditorInput)input).getResource();
            this.fTrace = ((TmfEditorInput)input).getTrace();
        } else if (input instanceof IFileEditorInput) {
            this.fResource = ((IFileEditorInput)input).getFile();
            this.fTrace = ParserProviderManager.getTrace(this.fResource);
            input = new TmfEditorInput(this.fResource, this.fTrace);
        } else if (input instanceof FileStoreEditorInput) {
            try {
                FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)input;
                this.fResource = TmfEventsEditor.createLink(fileStoreEditorInput.getURI());
                this.fTrace = ParserProviderManager.getTrace(this.fResource);
                input = new TmfEditorInput(this.fResource, this.fTrace);
            }
            catch (CoreException e) {
                throw new PartInitException(e.getMessage());
            }
        } else {
            throw new PartInitException("Invalid IEditorInput: " + input.getClass());
        }
        if (this.fTrace == null) {
            throw new PartInitException("Invalid IEditorInput: " + this.fResource.getName());
        }
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public static IFolder getActiveProjectTracesFolder() {
        IProject[] projects;
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.linuxtools.tmf.ui");
        String activeProjectName = node.get("ACTIVE_PROJECT", "");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && project.getName().equals(activeProjectName)) {
                return project.getFolder("Traces");
            }
            ++n2;
        }
        return null;
    }

    public static IFile createLink(URI uri) throws CoreException {
        IFolder folder = TmfEventsEditor.getActiveProjectTracesFolder();
        if (folder == null || !folder.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", "No active project set"));
        }
        String path = uri.getPath();
        IFile file = folder.getFile(path.substring(path.lastIndexOf(47)));
        if (!file.exists()) {
            file.createLink(uri, 0, null);
        }
        return file;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.firePropertyChange(258);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.broadcast(new TmfTraceClosedSignal(this, this.fTrace));
            this.fResource = ((TmfEditorInput)this.getEditorInput()).getResource();
            this.fTrace = ((TmfEditorInput)this.getEditorInput()).getTrace();
            this.fEventsTable.dispose();
            if (this.fTrace != null) {
                this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
                this.fEventsTable.setTrace(this.fTrace, true);
                this.fEventsTable.refreshBookmarks(this.fResource);
                this.broadcast(new TmfTraceOpenedSignal(this, this.fTrace, this.fResource, this.fEventsTable));
            } else {
                this.fEventsTable = new TmfEventsTable(this.fParent, 0);
            }
            this.fParent.layout();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.setPartName(this.getEditorInput().getName());
        if (this.fTrace != null) {
            this.fEventsTable = this.createEventsTable(parent, this.fTrace.getCacheSize());
            this.fEventsTable.setTrace(this.fTrace, true);
            this.fEventsTable.refreshBookmarks(this.fResource);
            this.broadcast(new TmfTraceOpenedSignal(this, this.fTrace, this.fResource, this.fEventsTable));
        } else {
            this.fEventsTable = new TmfEventsTable(parent, 0);
        }
        this.addPropertyListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.removePropertyListener(this);
        if (this.fTrace != null) {
            this.broadcast(new TmfTraceClosedSignal(this, this.fTrace));
        }
        if (this.fEventsTable != null) {
            this.fEventsTable.dispose();
        }
        super.dispose();
    }

    protected TmfEventsTable createEventsTable(Composite parent, int cacheSize) {
        TmfEventsTable eventsTable = this.getEventsTable(parent, cacheSize);
        if (eventsTable == null) {
            eventsTable = new TmfEventsTable(parent, cacheSize);
        }
        return eventsTable;
    }

    private TmfEventsTable getEventsTable(Composite parent, int cacheSize) {
        TmfEventsTable eventsTable = null;
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.tracetype");
        try {
            String traceType = this.fResource.getPersistentProperty(TmfTraceElement.TRACETYPE);
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (ce.getAttribute("id").equals(traceType)) {
                    String eventsTableType;
                    IConfigurationElement[] eventsTableTypeCE = ce.getChildren("eventsTableType");
                    if (eventsTableTypeCE.length == 1 && (eventsTableType = eventsTableTypeCE[0].getAttribute("class")) != null && eventsTableType.length() != 0) {
                        Bundle bundle = Platform.getBundle((String)ce.getContributor().getName());
                        Class c = bundle.loadClass(eventsTableType);
                        Class[] constructorArgs = new Class[]{Composite.class, Integer.TYPE};
                        Constructor constructor = c.getConstructor(constructorArgs);
                        Object[] args = new Object[]{parent, cacheSize};
                        eventsTable = (TmfEventsTable)constructor.newInstance(args);
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return eventsTable;
    }

    @Override
    public ITmfTrace<?> getTrace() {
        return this.fTrace;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    public void setFocus() {
        this.fEventsTable.setFocus();
        if (this.fTrace != null) {
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
        }
    }

    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            return this.fEventsTable;
        }
        return super.getAdapter(adapter);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fResource) && delta.getKind() == 2) {
                final IMarker bookmark = delta.getMarker();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TmfEventsEditor.this.fEventsTable.removeBookmark(bookmark);
                    }
                });
            }
            ++n2;
        }
    }

    public void addBookmark() {
        this.fEventsTable.addBookmark(this.fResource);
    }

    @TmfSignalHandler
    public void traceParserUpdated(TmfTraceParserUpdatedSignal signal) {
        if (signal.getTraceResource().equals((Object)this.fResource)) {
            this.broadcast(new TmfTraceClosedSignal(this, this.fTrace));
            this.fTrace = ParserProviderManager.getTrace(this.fResource);
            this.fEventsTable.dispose();
            if (this.fTrace != null) {
                this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
                this.fEventsTable.setTrace(this.fTrace, true);
                this.broadcast(new TmfTraceOpenedSignal(this, this.fTrace, this.fResource, this.fEventsTable));
            } else {
                this.fEventsTable = new TmfEventsTable(this.fParent, 0);
            }
            this.fParent.layout();
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getSource() != this && signal.getTrace().equals(this.fTrace)) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)this);
        }
    }
}

