/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers.custom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventReference;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.io.BufferedRandomAccessFile;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfContext;
import org.eclipse.linuxtools.tmf.trace.TmfLocation;
import org.eclipse.linuxtools.tmf.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomEventContent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtEvent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtEventType;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTraceContext;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTraceDefinition;

public class CustomTxtTrace
extends TmfTrace<CustomTxtEvent> {
    private static final TmfLocation<Long> NULL_LOCATION = new TmfLocation(null);
    private CustomTxtTraceDefinition fDefinition;
    private CustomTxtEventType fEventType;

    public CustomTxtTrace(String name, CustomTxtTraceDefinition definition, String path, int cacheSize) throws FileNotFoundException {
        super(name, CustomTxtEvent.class, path, cacheSize);
        this.fDefinition = definition;
        this.fEventType = new CustomTxtEventType(this.fDefinition);
    }

    public ITmfTrace copy() {
        return null;
    }

    public TmfContext seekLocation(ITmfLocation<?> location) {
        CustomTxtTraceContext context = new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals(location) || !new File(this.getPath()).isFile()) {
            return context;
        }
        try {
            String line;
            BufferedRandomAccessFile raFile = new BufferedRandomAccessFile(this.getPath(), "r");
            if (location != null && location.getLocation() instanceof Long) {
                raFile.seek(((Long)location.getLocation()).longValue());
            }
            long rawPos = raFile.getFilePointer();
            while ((line = raFile.getNextLine()) != null) {
                for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                    Matcher matcher = input.getPattern().matcher(line);
                    if (!matcher.find()) continue;
                    context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                    context.raFile = raFile;
                    context.firstLineMatcher = matcher;
                    context.firstLine = line;
                    context.nextLineLocation = raFile.getFilePointer();
                    context.inputLine = input;
                    return context;
                }
                rawPos = raFile.getFilePointer();
            }
            return context;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return context;
        }
        catch (IOException e) {
            e.printStackTrace();
            return context;
        }
    }

    public TmfContext seekLocation(double ratio) {
        try {
            BufferedRandomAccessFile raFile = new BufferedRandomAccessFile(this.getPath(), "r");
            long pos = (long)(ratio * (double)raFile.length());
            while (pos > 0L) {
                raFile.seek(pos - 1L);
                if (raFile.read() == 10) break;
                --pos;
            }
            TmfLocation location = new TmfLocation((Comparable)new Long(pos));
            TmfContext context = this.seekLocation((ITmfLocation<?>)location);
            context.setRank(-2L);
            return context;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        }
    }

    public double getLocationRatio(ITmfLocation<?> location) {
        try {
            if (location.getLocation() instanceof Long) {
                BufferedRandomAccessFile raFile = new BufferedRandomAccessFile(this.getPath(), "r");
                return (double)((Long)location.getLocation()).longValue() / (double)raFile.length();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    public synchronized TmfEvent getNextEvent(TmfContext context) {
        TmfContext savedContext = context.clone();
        TmfEvent event = this.parseEvent(context);
        if (event != null) {
            this.updateIndex((ITmfContext)savedContext, savedContext.getRank(), event.getTimestamp());
            context.updateRank(1);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfEvent parseEvent(TmfContext tmfContext) {
        if (!(tmfContext instanceof CustomTxtTraceContext)) {
            return null;
        }
        CustomTxtTraceContext context = (CustomTxtTraceContext)tmfContext;
        if (!(context.getLocation().getLocation() instanceof Long) || NULL_LOCATION.equals((Object)context.getLocation())) {
            return null;
        }
        CustomTxtEvent event = this.parseFirstLine(context);
        HashMap<CustomTxtTraceDefinition.InputLine, Integer> countMap = new HashMap<CustomTxtTraceDefinition.InputLine, Integer>();
        CustomTxtTraceDefinition.InputLine currentInput = null;
        if (context.inputLine.childrenInputs != null && context.inputLine.childrenInputs.size() > 0) {
            currentInput = context.inputLine.childrenInputs.get(0);
            countMap.put(currentInput, 0);
        }
        BufferedRandomAccessFile bufferedRandomAccessFile = context.raFile;
        synchronized (bufferedRandomAccessFile) {
            try {
                String line;
                if (context.raFile.getFilePointer() != context.nextLineLocation) {
                    context.raFile.seek(context.nextLineLocation);
                }
                long rawPos = context.raFile.getFilePointer();
                while ((line = context.raFile.getNextLine()) != null) {
                    boolean processed = false;
                    if (currentInput == null) {
                        for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                            Matcher matcher = input.getPattern().matcher(line);
                            if (!matcher.find()) continue;
                            context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                            context.firstLineMatcher = matcher;
                            context.firstLine = line;
                            context.nextLineLocation = context.raFile.getFilePointer();
                            context.inputLine = input;
                            return event;
                        }
                    } else {
                        if ((Integer)countMap.get(currentInput) >= currentInput.getMinCount()) {
                            Matcher matcher;
                            List<CustomTxtTraceDefinition.InputLine> nextInputs = currentInput.getNextInputs(countMap);
                            if (nextInputs.size() == 0 || nextInputs.get(nextInputs.size() - 1).getMinCount() == 0) {
                                for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                                    matcher = input.getPattern().matcher(line);
                                    if (!matcher.find()) continue;
                                    context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                                    context.firstLineMatcher = matcher;
                                    context.firstLine = line;
                                    context.nextLineLocation = context.raFile.getFilePointer();
                                    context.inputLine = input;
                                    return event;
                                }
                            }
                            for (CustomTxtTraceDefinition.InputLine input : nextInputs) {
                                CustomTxtTraceDefinition.InputLine inputLine;
                                matcher = input.getPattern().matcher(line);
                                if (!matcher.find()) continue;
                                event.processGroups(input, matcher);
                                currentInput = input;
                                if (countMap.get(currentInput) == null) {
                                    countMap.put(currentInput, 1);
                                } else {
                                    countMap.put(currentInput, countMap.get(currentInput) + 1);
                                }
                                Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                while (iter.hasNext()) {
                                    inputLine = iter.next();
                                    if (inputLine.level <= currentInput.level) continue;
                                    iter.remove();
                                }
                                if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                    currentInput = currentInput.childrenInputs.get(0);
                                    countMap.put(currentInput, 0);
                                } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                    if (currentInput.getNextInputs(countMap).size() > 0) {
                                        if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                            countMap.put(currentInput, 0);
                                        }
                                        iter = countMap.keySet().iterator();
                                        while (iter.hasNext()) {
                                            inputLine = iter.next();
                                            if (inputLine.level <= currentInput.level) continue;
                                            iter.remove();
                                        }
                                    } else {
                                        currentInput = null;
                                    }
                                }
                                processed = true;
                                break;
                            }
                        }
                        if (!processed) {
                            Matcher matcher = currentInput.getPattern().matcher(line);
                            if (matcher.find()) {
                                event.processGroups(currentInput, matcher);
                                countMap.put(currentInput, countMap.get(currentInput) + 1);
                                if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                    currentInput = currentInput.childrenInputs.get(0);
                                    countMap.put(currentInput, 0);
                                } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                    if (currentInput.getNextInputs(countMap).size() > 0) {
                                        if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                            countMap.put(currentInput, 0);
                                        }
                                        Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                        while (iter.hasNext()) {
                                            CustomTxtTraceDefinition.InputLine inputLine = iter.next();
                                            if (inputLine.level <= currentInput.level) continue;
                                            iter.remove();
                                        }
                                    } else {
                                        currentInput = null;
                                    }
                                }
                            }
                            ((StringBuffer)event.getContent().getContent()).append("\n").append(line);
                        }
                    }
                    rawPos = context.raFile.getFilePointer();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() >= ((CustomTxtTraceDefinition.InputLine)entry.getKey()).getMinCount()) continue;
            event = null;
        }
        context.setLocation((ITmfLocation)NULL_LOCATION);
        return event;
    }

    public List<CustomTxtTraceDefinition.InputLine> getFirstLines() {
        return this.fDefinition.inputs;
    }

    public CustomTxtEvent parseFirstLine(CustomTxtTraceContext context) {
        CustomTxtEvent event = new CustomTxtEvent(this.fDefinition, TmfTimestamp.Zero, new TmfEventSource((Object)""), (TmfEventType)this.fEventType, new TmfEventReference((Object)""));
        event.processGroups(context.inputLine, context.firstLineMatcher);
        event.setContent(new CustomEventContent(event, new StringBuffer(context.firstLine)));
        return event;
    }

    public CustomTraceDefinition getDefinition() {
        return this.fDefinition;
    }
}

