/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.filter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.tmf.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterAndNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterCompareNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterContainsNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterEqualsNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterEventTypeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterMatchesNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterOrNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterRootNode;
import org.eclipse.linuxtools.tmf.ui.internal.Messages;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.views.filter.FilterTreeContentProvider;
import org.eclipse.linuxtools.tmf.ui.views.filter.FilterTreeLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

class FilterViewer
extends Composite {
    private static final Map<String, Map.Entry<String, String>> EVENT_TYPES_MAP;
    private static final String[] FIELDS_LIST;
    private TreeViewer fViewer;
    private Composite fComposite;

    static {
        LinkedHashMap<String, Map.Entry<String, String>> eventTypesMap = new LinkedHashMap<String, Map.Entry<String, String>>();
        for (Map.Entry<String, Map<String, String>> categoryEntry : ParserProviderManager.getParserMap().entrySet()) {
            for (Map.Entry<String, String> parserEntry : categoryEntry.getValue().entrySet()) {
                String prefix = String.valueOf(categoryEntry.getKey()) + " - " + parserEntry.getKey() + " - ";
                for (Map.Entry<String, String> eventTypeEntry : ParserProviderManager.getEventTypeMapForParser(parserEntry.getValue()).entrySet()) {
                    eventTypesMap.put(String.valueOf(prefix) + eventTypeEntry.getKey(), eventTypeEntry);
                }
            }
        }
        EVENT_TYPES_MAP = eventTypesMap;
        ArrayList<String> fieldsList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> categoryEntry : ParserProviderManager.getParserMap().entrySet()) {
            for (Map.Entry<String, String> parserEntry : categoryEntry.getValue().entrySet()) {
                fieldsList.add("");
                fieldsList.add("[" + categoryEntry.getKey() + " - " + parserEntry.getKey() + "]");
                for (String eventType : ParserProviderManager.getEventTypeMapForParser(parserEntry.getValue()).values()) {
                    String[] stringArray = ParserProviderManager.getFieldLabelsForEventType(eventType);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String field = stringArray[n2];
                        fieldsList.add(field);
                        ++n2;
                    }
                }
            }
        }
        FIELDS_LIST = fieldsList.toArray(new String[0]);
    }

    public FilterViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
        SashForm sash = new SashForm((Composite)this, 256);
        this.fViewer = new TreeViewer((Composite)sash, 0);
        this.fViewer.setContentProvider((IContentProvider)new FilterTreeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new FilterTreeLabelProvider());
        this.fViewer.setInput((Object)new TmfFilterRootNode());
        this.fComposite = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fComposite.setLayout((Layout)gl);
        this.createContextMenu();
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ITmfFilterTreeNode node = (ITmfFilterTreeNode)selection.getFirstElement();
                    FilterViewer.this.updateFilterNodeComposite(node);
                    FilterViewer.this.highlightTreeItems(FilterViewer.this.fViewer.getTree().getSelection()[0].getItems());
                } else {
                    FilterViewer.this.updateFilterNodeComposite(null);
                }
            }
        });
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FilterViewer.this.fillContextMenu(manager);
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(contextMenu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITmfFilterTreeNode selectedNode;
        Object element;
        ISelection selection = this.fViewer.getSelection();
        ITmfFilterTreeNode filterTreeNode = null;
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfFilterTreeNode) {
            filterTreeNode = (ITmfFilterTreeNode)element;
        }
        if ((selectedNode = filterTreeNode) != null) {
            this.fillContextMenuForNode(selectedNode, manager);
            if (selectedNode.getValidChildren().size() > 0) {
                manager.add((IContributionItem)new Separator());
            }
            Action deleteAction = new Action(){

                public void run() {
                    selectedNode.remove();
                    FilterViewer.this.fViewer.refresh();
                }
            };
            deleteAction.setText(Messages.FilterViewer_DeleteActionText);
            manager.add((IAction)deleteAction);
            manager.add((IContributionItem)new Separator());
        }
        if (this.fViewer.getInput() instanceof TmfFilterRootNode || selectedNode == null) {
            ITmfFilterTreeNode root = (ITmfFilterTreeNode)this.fViewer.getInput();
            this.fillContextMenuForNode(root, manager);
        }
    }

    protected void fillContextMenuForNode(final ITmfFilterTreeNode node, IMenuManager manager) {
        for (final String child : node.getValidChildren()) {
            Action action = new Action(){

                public void run() {
                    TmfFilterNode newNode = null;
                    if ("FILTER".equals(child)) {
                        newNode = new TmfFilterNode(node, "");
                    } else if ("EVENTTYPE".equals(child)) {
                        newNode = new TmfFilterEventTypeNode(node);
                    } else if ("AND".equals(child)) {
                        newNode = new TmfFilterAndNode(node);
                    } else if ("OR".equals(child)) {
                        newNode = new TmfFilterOrNode(node);
                    } else if ("CONTAINS".equals(child)) {
                        newNode = new TmfFilterContainsNode(node);
                    } else if ("EQUALS".equals(child)) {
                        newNode = new TmfFilterEqualsNode(node);
                    } else if ("MATCHES".equals(child)) {
                        newNode = new TmfFilterMatchesNode(node);
                    } else if ("COMPARE".equals(child)) {
                        newNode = new TmfFilterCompareNode(node);
                    }
                    if (newNode != null) {
                        FilterViewer.this.fViewer.refresh();
                        FilterViewer.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newNode), true);
                    }
                }
            };
            if ("FILTER".equals(child)) {
                action.setText(String.valueOf(Messages.FilterViewer_NewPrefix) + " " + child);
            } else {
                action.setText(child);
            }
            manager.add((IAction)action);
        }
    }

    private void updateFilterNodeComposite(ITmfFilterTreeNode node) {
        Control[] controlArray = this.fComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (node instanceof TmfFilterNode) {
            new FilterNodeComposite(this.fComposite, (TmfFilterNode)node);
        } else if (node instanceof TmfFilterEventTypeNode) {
            new FilterEventTypeNodeComposite(this.fComposite, (TmfFilterEventTypeNode)node);
        } else if (node instanceof TmfFilterAndNode) {
            new FilterAndNodeComposite(this.fComposite, (TmfFilterAndNode)node);
        } else if (node instanceof TmfFilterOrNode) {
            new FilterOrNodeComposite(this.fComposite, (TmfFilterOrNode)node);
        } else if (node instanceof TmfFilterContainsNode) {
            new FilterContainsNodeComposite(this.fComposite, (TmfFilterContainsNode)node);
        } else if (node instanceof TmfFilterEqualsNode) {
            new FilterEqualsNodeComposite(this.fComposite, (TmfFilterEqualsNode)node);
        } else if (node instanceof TmfFilterMatchesNode) {
            new FilterMatchesNodeComposite(this.fComposite, (TmfFilterMatchesNode)node);
        } else if (node instanceof TmfFilterCompareNode) {
            new FilterCompareNodeComposite(this.fComposite, (TmfFilterCompareNode)node);
        } else {
            new FilterBaseNodeComposite(this.fComposite);
        }
        this.fComposite.layout();
    }

    private void highlightTreeItems(TreeItem[] items) {
        this.resetTreeItems(this.fViewer.getTree().getItems());
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setForeground(Display.getCurrent().getSystemColor(9));
            ++n2;
        }
    }

    private void resetTreeItems(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setForeground(Display.getCurrent().getSystemColor(2));
            this.resetTreeItems(item.getItems());
            ++n2;
        }
    }

    public void setInput(ITmfFilterTreeNode root) {
        this.fViewer.setInput((Object)root);
        this.fViewer.expandAll();
        this.updateFilterNodeComposite(null);
    }

    public ITmfFilterTreeNode getInput() {
        return (ITmfFilterTreeNode)this.fViewer.getInput();
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void setSelection(ITmfFilterTreeNode node, boolean reveal) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), reveal);
    }

    public void setSelection(ITmfFilterTreeNode node) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node));
    }

    public ITmfFilterTreeNode getSelection() {
        Object element;
        ISelection selection = this.fViewer.getSelection();
        ITmfFilterTreeNode filterTreeNode = null;
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfFilterTreeNode) {
            filterTreeNode = (ITmfFilterTreeNode)element;
        }
        ITmfFilterTreeNode selectedNode = filterTreeNode;
        return selectedNode;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.removeSelectionChangedListener(listener);
    }

    private class FilterAndNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterAndNode fNode;
        Button fNotButton;

        FilterAndNodeComposite(Composite parent, TmfFilterAndNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterAndNodeComposite.this.fNode.setNot(FilterAndNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterAndNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterBaseNodeComposite
    extends Composite {
        FilterBaseNodeComposite(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            this.setLayoutData(new GridData(4, 4, true, true));
            this.setBackground(Display.getCurrent().getSystemColor(1));
        }

        protected String[] getFieldsList(ITmfFilterTreeNode node) {
            while (node != null) {
                if (node instanceof TmfFilterEventTypeNode) {
                    TmfFilterEventTypeNode eventTypeNode = (TmfFilterEventTypeNode)node;
                    return ParserProviderManager.getFieldLabelsForEventType(eventTypeNode.getEventType());
                }
                node = node.getParent();
            }
            return FIELDS_LIST;
        }
    }

    private class FilterCompareNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterCompareNode fNode;
        Button fNotButton;
        Combo fFieldCombo;
        Text fValueText;
        Button fLTButton;
        Button fEQButton;
        Button fGTButton;
        Button fNumButton;
        Button fAlphaButton;
        Button fTimestampButton;

        FilterCompareNodeComposite(Composite parent, TmfFilterCompareNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterCompareNodeComposite.this.fNode.setNot(FilterCompareNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_FieldLabel);
            this.fFieldCombo = new Combo((Composite)this, 4);
            this.fFieldCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFieldCombo.setItems(this.getFieldsList((ITmfFilterTreeNode)this.fNode));
            if (this.fNode.getField() != null) {
                this.fFieldCombo.setText(this.fNode.getField());
            }
            this.fFieldCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FilterCompareNodeComposite.this.fNode.setField(FilterCompareNodeComposite.this.fFieldCombo.getText());
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ResultLabel);
            Composite resultGroup = new Composite((Composite)this, 0);
            GridLayout rggl = new GridLayout(3, true);
            rggl.marginHeight = 0;
            rggl.marginWidth = 0;
            resultGroup.setLayout((Layout)rggl);
            resultGroup.setBackground(Display.getCurrent().getSystemColor(1));
            this.fLTButton = new Button(resultGroup, 16);
            this.fLTButton.setSelection(this.fNode.getResult() < 0);
            this.fLTButton.setText("<");
            this.fLTButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fLTButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fLTButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(-1);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fEQButton = new Button(resultGroup, 16);
            this.fEQButton.setSelection(this.fNode.getResult() == 0);
            this.fEQButton.setText("=");
            this.fEQButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fEQButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fEQButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(0);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fGTButton = new Button(resultGroup, 16);
            this.fGTButton.setSelection(this.fNode.getResult() > 0);
            this.fGTButton.setText(">");
            this.fGTButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fGTButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fGTButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(1);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_TypeLabel);
            Composite typeGroup = new Composite((Composite)this, 0);
            GridLayout tggl = new GridLayout(3, false);
            tggl.marginHeight = 0;
            tggl.marginWidth = 0;
            typeGroup.setLayout((Layout)tggl);
            typeGroup.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNumButton = new Button(typeGroup, 16);
            this.fNumButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.NUM);
            this.fNumButton.setText(Messages.FilterViewer_NumButtonText);
            this.fNumButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNumButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fNumButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.NUM);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fAlphaButton = new Button(typeGroup, 16);
            this.fAlphaButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.ALPHA);
            this.fAlphaButton.setText(Messages.FilterViewer_AlphaButtonText);
            this.fAlphaButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fAlphaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fAlphaButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.ALPHA);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fTimestampButton = new Button(typeGroup, 16);
            this.fTimestampButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.TIMESTAMP);
            this.fTimestampButton.setText(Messages.FilterViewer_TimestampButtonText);
            this.fTimestampButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fTimestampButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fTimestampButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.TIMESTAMP);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ValueLabel);
            this.fValueText = new Text((Composite)this, 2048);
            this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getValue() != null && node.getValue().length() > 0) {
                this.fValueText.setText(node.getValue());
            } else {
                this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fValueText.setText(Messages.FilterViewer_ValueHint);
            }
            this.fValueText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterCompareNodeComposite.this.fNode.getValue() == null || FilterCompareNodeComposite.this.fNode.getValue().length() == 0) {
                        FilterCompareNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterCompareNodeComposite.this.fValueText.setText(Messages.FilterViewer_ValueHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterCompareNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterCompareNodeComposite.this.fValueText.setText("");
                    }
                    FilterCompareNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterCompareNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterCompareNodeComposite.this.fNode.setValue(FilterCompareNodeComposite.this.fValueText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                    }
                }
            });
        }
    }

    private class FilterContainsNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterContainsNode fNode;
        Button fNotButton;
        Combo fFieldCombo;
        Text fValueText;
        Button fIgnoreCaseButton;

        FilterContainsNodeComposite(Composite parent, TmfFilterContainsNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterContainsNodeComposite.this.fNode.setNot(FilterContainsNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_FieldLabel);
            this.fFieldCombo = new Combo((Composite)this, 4);
            this.fFieldCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFieldCombo.setItems(this.getFieldsList((ITmfFilterTreeNode)this.fNode));
            if (this.fNode.getField() != null) {
                this.fFieldCombo.setText(this.fNode.getField());
            }
            this.fFieldCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FilterContainsNodeComposite.this.fNode.setField(FilterContainsNodeComposite.this.fFieldCombo.getText());
                    FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ValueLabel);
            this.fValueText = new Text((Composite)this, 2048);
            this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getValue() != null && node.getValue().length() > 0) {
                this.fValueText.setText(node.getValue());
            } else {
                this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fValueText.setText(Messages.FilterViewer_ValueHint);
            }
            this.fValueText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterContainsNodeComposite.this.fNode.getValue() == null || FilterContainsNodeComposite.this.fNode.getValue().length() == 0) {
                        FilterContainsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterContainsNodeComposite.this.fValueText.setText(Messages.FilterViewer_ValueHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterContainsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterContainsNodeComposite.this.fValueText.setText("");
                    }
                    FilterContainsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterContainsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterContainsNodeComposite.this.fNode.setValue(FilterContainsNodeComposite.this.fValueText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                    }
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton = new Button((Composite)this, 32);
            this.fIgnoreCaseButton.setSelection(this.fNode.isIgnoreCase());
            this.fIgnoreCaseButton.setText(Messages.FilterViewer_IgnoreCaseButtonText);
            this.fIgnoreCaseButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterContainsNodeComposite.this.fNode.setIgnoreCase(FilterContainsNodeComposite.this.fIgnoreCaseButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterEqualsNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterEqualsNode fNode;
        Button fNotButton;
        Combo fFieldCombo;
        Text fValueText;
        Button fIgnoreCaseButton;

        FilterEqualsNodeComposite(Composite parent, TmfFilterEqualsNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterEqualsNodeComposite.this.fNode.setNot(FilterEqualsNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_FieldLabel);
            this.fFieldCombo = new Combo((Composite)this, 4);
            this.fFieldCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFieldCombo.setItems(this.getFieldsList((ITmfFilterTreeNode)this.fNode));
            if (this.fNode.getField() != null) {
                this.fFieldCombo.setText(this.fNode.getField());
            }
            this.fFieldCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FilterEqualsNodeComposite.this.fNode.setField(FilterEqualsNodeComposite.this.fFieldCombo.getText());
                    FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ValueLabel);
            this.fValueText = new Text((Composite)this, 2048);
            this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getValue() != null && node.getValue().length() > 0) {
                this.fValueText.setText(node.getValue());
            } else {
                this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fValueText.setText(Messages.FilterViewer_ValueHint);
            }
            this.fValueText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterEqualsNodeComposite.this.fNode.getValue() == null || FilterEqualsNodeComposite.this.fNode.getValue().length() == 0) {
                        FilterEqualsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterEqualsNodeComposite.this.fValueText.setText(Messages.FilterViewer_ValueHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterEqualsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterEqualsNodeComposite.this.fValueText.setText("");
                    }
                    FilterEqualsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterEqualsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterEqualsNodeComposite.this.fNode.setValue(FilterEqualsNodeComposite.this.fValueText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                    }
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton = new Button((Composite)this, 32);
            this.fIgnoreCaseButton.setSelection(this.fNode.isIgnoreCase());
            this.fIgnoreCaseButton.setText(Messages.FilterViewer_IgnoreCaseButtonText);
            this.fIgnoreCaseButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterEqualsNodeComposite.this.fNode.setIgnoreCase(FilterEqualsNodeComposite.this.fIgnoreCaseButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterEventTypeNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterEventTypeNode fNode;
        Combo fTypeCombo;

        FilterEventTypeNodeComposite(Composite parent, TmfFilterEventTypeNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_TypeLabel);
            this.fTypeCombo = new Combo((Composite)this, 12);
            this.fTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fTypeCombo.setItems(EVENT_TYPES_MAP.keySet().toArray(new String[0]));
            if (this.fNode.getEventType() != null) {
                for (Map.Entry eventTypeEntry : EVENT_TYPES_MAP.entrySet()) {
                    if (!((String)((Map.Entry)eventTypeEntry.getValue()).getValue()).equals(this.fNode.getEventType())) continue;
                    this.fTypeCombo.setText((String)eventTypeEntry.getKey());
                }
            }
            this.fTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    for (Map.Entry eventTypeEntry : EVENT_TYPES_MAP.entrySet()) {
                        if (!((String)eventTypeEntry.getKey()).equals(FilterEventTypeNodeComposite.this.fTypeCombo.getText())) continue;
                        FilterEventTypeNodeComposite.this.fNode.setEventType((String)((Map.Entry)eventTypeEntry.getValue()).getValue());
                        FilterEventTypeNodeComposite.this.fNode.setName((String)((Map.Entry)eventTypeEntry.getValue()).getKey());
                        FilterViewer.this.fViewer.refresh((Object)FilterEventTypeNodeComposite.this.fNode);
                        break;
                    }
                }
            });
        }
    }

    private class FilterMatchesNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterMatchesNode fNode;
        Button fNotButton;
        Combo fFieldCombo;
        Text fRegexText;

        FilterMatchesNodeComposite(Composite parent, TmfFilterMatchesNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterMatchesNodeComposite.this.fNode.setNot(FilterMatchesNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterMatchesNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_FieldLabel);
            this.fFieldCombo = new Combo((Composite)this, 4);
            this.fFieldCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFieldCombo.setItems(this.getFieldsList((ITmfFilterTreeNode)this.fNode));
            if (this.fNode.getField() != null) {
                this.fFieldCombo.setText(this.fNode.getField());
            }
            this.fFieldCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FilterMatchesNodeComposite.this.fNode.setField(FilterMatchesNodeComposite.this.fFieldCombo.getText());
                    FilterViewer.this.fViewer.refresh((Object)FilterMatchesNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_RegexLabel);
            this.fRegexText = new Text((Composite)this, 2048);
            this.fRegexText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getRegex() != null && node.getRegex().length() > 0) {
                this.fRegexText.setText(node.getRegex());
            } else {
                this.fRegexText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fRegexText.setText(Messages.FilterViewer_RegexHint);
            }
            this.fRegexText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterMatchesNodeComposite.this.fNode.getRegex() == null || FilterMatchesNodeComposite.this.fNode.getRegex().length() == 0) {
                        FilterMatchesNodeComposite.this.fRegexText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterMatchesNodeComposite.this.fRegexText.setText(Messages.FilterViewer_RegexHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterMatchesNodeComposite.this.fRegexText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterMatchesNodeComposite.this.fRegexText.setText("");
                    }
                    FilterMatchesNodeComposite.this.fRegexText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fRegexText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterMatchesNodeComposite.this.fRegexText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterMatchesNodeComposite.this.fNode.setRegex(FilterMatchesNodeComposite.this.fRegexText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterMatchesNodeComposite.this.fNode);
                    }
                }
            });
        }
    }

    private class FilterNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterNode fNode;
        Text fNameText;

        FilterNodeComposite(Composite parent, TmfFilterNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NameLabel);
            this.fNameText = new Text((Composite)this, 2048);
            this.fNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getFilterName() != null && node.getFilterName().length() > 0) {
                this.fNameText.setText(node.getFilterName());
            } else {
                this.fNameText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fNameText.setText(Messages.FilterViewer_FilterNameHint);
            }
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterNodeComposite.this.fNode.getFilterName() == null || FilterNodeComposite.this.fNode.getFilterName().length() == 0) {
                        FilterNodeComposite.this.fNameText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterNodeComposite.this.fNameText.setText(Messages.FilterViewer_FilterNameHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterNodeComposite.this.fNameText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterNodeComposite.this.fNameText.setText("");
                    }
                    FilterNodeComposite.this.fNameText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterNodeComposite.this.fNameText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterNodeComposite.this.fNode.setFilterName(FilterNodeComposite.this.fNameText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterNodeComposite.this.fNode);
                    }
                }
            });
        }
    }

    private class FilterOrNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterOrNode fNode;
        Button fNotButton;

        FilterOrNodeComposite(Composite parent, TmfFilterOrNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterOrNodeComposite.this.fNode.setNot(FilterOrNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterOrNodeComposite.this.fNode);
                }
            });
        }
    }
}

