/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.StringDeclaration;

public class StringDefinition
extends Definition {
    private StringDeclaration declaration;
    private StringBuilder string;

    public StringDefinition(StringDeclaration declaration, IDefinitionScope definitionScope, String fieldName) {
        super(definitionScope, fieldName);
        this.declaration = declaration;
        this.string = new StringBuilder();
    }

    public StringDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(StringDeclaration declaration) {
        this.declaration = declaration;
    }

    public StringBuilder getString() {
        return this.string;
    }

    public void setString(StringBuilder string) {
        this.string = string;
    }

    public String getValue() {
        return this.string.toString();
    }

    @Override
    public void read(BitBuffer input) {
        this.string.setLength(0);
        char c = (char)input.getInt(8, false);
        while (c != '\u0000') {
            this.string.append(c);
            c = (char)input.getInt(8, false);
        }
    }

    @Override
    public String toString() {
        return String.valueOf('\"') + this.getValue() + '\"';
    }
}

