/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.linuxtools.ctf.core.CtfCorePlugin;
import org.eclipse.linuxtools.ctf.core.event.CTFClock;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.metadata.exceptions.ParseException;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.Metadata;
import org.eclipse.linuxtools.ctf.core.trace.Stream;
import org.eclipse.linuxtools.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.ctf.core.trace.Utils;

public class CTFTrace
implements IDefinitionScope {
    private final File path;
    private final Metadata metadata;
    private Long major;
    private Long minor;
    private UUID uuid;
    private ByteOrder byteOrder;
    private StructDeclaration packetHeaderDecl;
    private StructDefinition packetHeaderDef;
    private final HashMap<Long, Stream> streams = new HashMap();
    private final HashMap<String, String> environment = new HashMap();
    private final HashMap<String, CTFClock> clocks = new HashMap();

    public String toString() {
        return "CTFTrace [path=" + this.path + ", major=" + this.major + ", minor=" + this.minor + ", uuid=" + this.uuid + "]";
    }

    public CTFTrace(String path) throws CTFReaderException {
        this(new File(path));
    }

    public CTFTrace(File path) throws CTFReaderException {
        this.path = path;
        this.metadata = new Metadata(this);
        if (!this.path.isDirectory()) {
            throw new CTFReaderException("Path must be a valid directory");
        }
        this.open();
    }

    public Stream getStream(Long id) {
        return this.streams.get(id);
    }

    public int nbStreams() {
        return this.streams.size();
    }

    public void setMajor(long major) {
        this.major = major;
    }

    public void setMinor(long minor) {
        this.minor = minor;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setPacketHeader(StructDeclaration packetHeader) {
        this.packetHeaderDecl = packetHeader;
    }

    public boolean majortIsSet() {
        return this.major != null;
    }

    public boolean minorIsSet() {
        return this.minor != null;
    }

    public boolean UUIDIsSet() {
        return this.uuid != null;
    }

    public boolean byteOrderIsSet() {
        return this.byteOrder != null;
    }

    public boolean packetHeaderIsSet() {
        return this.packetHeaderDecl != null;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public StructDeclaration getPacketHeader() {
        return this.packetHeaderDecl;
    }

    public File getTraceDirectory() {
        return this.path;
    }

    public Map<Long, Stream> getStreams() {
        return this.streams;
    }

    @Override
    public String getPath() {
        return this.path.getPath();
    }

    private void open() throws CTFReaderException {
        this.openTraceMetadata();
        if (CtfCorePlugin.getDefault() != null) {
            CtfCorePlugin.getDefault().log(this.metadata.toString());
        }
        this.openStreamInputs();
        this.createStreamInputIndexes();
    }

    private void openTraceMetadata() throws CTFReaderException {
        this.metadata.parse();
    }

    private void createDefinitions() {
        if (this.packetHeaderDecl != null) {
            this.packetHeaderDef = this.packetHeaderDecl.createDefinition(this, "packet.header");
        }
    }

    private void createStreamInputIndexes() throws CTFReaderException {
        for (Map.Entry<Long, Stream> stream : this.streams.entrySet()) {
            Set<StreamInput> inputs = stream.getValue().getStreamInputs();
            for (StreamInput s : inputs) {
                s.createIndex();
            }
        }
    }

    private void openStreamInputs() throws CTFReaderException {
        this.createDefinitions();
        File[] files = this.path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return false;
                }
                if (pathname.isHidden()) {
                    return false;
                }
                return !pathname.getName().equals("metadata");
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File s = fileArray[n2];
            this.openStreamInput(s);
            ++n2;
        }
    }

    private void openStreamInput(File streamFile) throws CTFReaderException {
        MappedByteBuffer byteBuffer;
        FileChannel streamFileChannel;
        if (!streamFile.canRead()) {
            throw new CTFReaderException("Unreadable file : " + streamFile.getPath());
        }
        try {
            streamFileChannel = new FileInputStream(streamFile).getChannel();
            byteBuffer = streamFileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 4096L);
        }
        catch (IOException iOException) {
            throw new CTFReaderException();
        }
        BitBuffer streamBitBuffer = new BitBuffer(byteBuffer, this.getByteOrder());
        if (this.packetHeaderDef != null) {
            this.packetHeaderDef.read(streamBitBuffer);
            IntegerDefinition magicDef = (IntegerDefinition)this.packetHeaderDef.lookupDefinition("magic");
            int magic = (int)magicDef.getValue();
            if (magic != -1040441407) {
                throw new CTFReaderException("CTF magic mismatch");
            }
            ArrayDefinition uuidDef = (ArrayDefinition)this.packetHeaderDef.lookupDefinition("uuid");
            assert (uuidDef != null && uuidDef.getDeclaration().getLength() == 16);
            if (uuidDef != null) {
                byte[] uuidArray = new byte[16];
                int i = 0;
                while (i < 16) {
                    IntegerDefinition uuidByteDef = (IntegerDefinition)uuidDef.getElem(i);
                    uuidArray[i] = (byte)uuidByteDef.getValue();
                    ++i;
                }
                UUID otheruuid = Utils.makeUUID(uuidArray);
                if (!this.uuid.equals(otheruuid)) {
                    throw new CTFReaderException("UUID mismatch");
                }
            }
            IntegerDefinition streamIDDef = (IntegerDefinition)this.packetHeaderDef.lookupDefinition("stream_id");
            assert (streamIDDef != null);
            long streamID = streamIDDef.getValue();
            Stream stream = this.streams.get(streamID);
            StreamInput streamInput = new StreamInput(stream, streamFileChannel, streamFile);
            stream.addInput(streamInput);
        } else {
            Stream stream = this.streams.get(null);
            StreamInput streamInput = new StreamInput(stream, streamFileChannel, streamFile);
            stream.addInput(streamInput);
        }
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals("trace.packet.header")) {
            return this.packetHeaderDef;
        }
        return null;
    }

    public void addStream(Stream stream) throws ParseException {
        if (this.streams.get(null) != null) {
            throw new ParseException("Stream without id with multiple streams");
        }
        if (stream.getId() == null && this.streams.size() != 0) {
            throw new ParseException("Stream without id with multiple streams");
        }
        if (this.streams.get(stream.getId()) != null) {
            throw new ParseException("Stream id already exists");
        }
        this.streams.put(stream.getId(), stream);
    }

    public HashMap<String, String> getEnvironment() {
        return this.environment;
    }

    public String lookupEnvironment(String key) {
        return this.environment.get(key);
    }

    public void addEnvironmentVar(String varName, String varValue) {
        this.environment.put(varName, varValue);
    }

    public void addClock(String nameValue, CTFClock ctfClock) {
        this.clocks.put(nameValue, ctfClock);
    }

    public CTFClock getClock(String name) {
        return this.clocks.get(name);
    }

    public CTFClock getClock() {
        if (this.clocks.size() == 1) {
            String key = (String)this.clocks.keySet().toArray()[0];
            return this.clocks.get(key);
        }
        return null;
    }
}

