/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.Stream;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketIndex;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketIndexEntry;
import org.eclipse.linuxtools.ctf.core.trace.Utils;

public class StreamInput
implements IDefinitionScope {
    private final Stream stream;
    private final FileChannel fileChannel;
    public final File file;
    private final StreamInputPacketIndex index = new StreamInputPacketIndex();
    private long timestampEnd;

    public StreamInput(Stream stream, FileChannel fileChannel, File file) {
        this.stream = stream;
        this.fileChannel = fileChannel;
        this.file = file;
    }

    public Stream getStream() {
        return this.stream;
    }

    public StreamInputPacketIndex getIndex() {
        return this.index;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public long getTimestampEnd() {
        return this.timestampEnd;
    }

    public void setTimestampEnd(long timestampEnd) {
        this.timestampEnd = timestampEnd;
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        return null;
    }

    public void createIndex() throws CTFReaderException {
        long fileSizeBytes = 0L;
        try {
            fileSizeBytes = this.fileChannel.size();
        }
        catch (IOException e) {
            throw new CTFReaderException(e);
        }
        long packetOffsetBytes = 0L;
        long mapSize = 4096L;
        StructDefinition tracePacketHeaderDef = null;
        StructDefinition streamPacketContextDef = null;
        BitBuffer bitBuffer = new BitBuffer();
        bitBuffer.order(this.getStream().getTrace().getByteOrder());
        if (this.getStream().getTrace().getPacketHeader() != null) {
            tracePacketHeaderDef = this.getStream().getTrace().getPacketHeader().createDefinition(this, "trace.packet.header");
        }
        if (this.getStream().getPacketContextDecl() != null) {
            streamPacketContextDef = this.getStream().getPacketContextDecl().createDefinition(this, "stream.packet.context");
        }
        while (packetOffsetBytes < fileSizeBytes) {
            MappedByteBuffer bb;
            if (fileSizeBytes - packetOffsetBytes < mapSize) {
                mapSize = fileSizeBytes - packetOffsetBytes;
            }
            try {
                bb = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, packetOffsetBytes, mapSize);
            }
            catch (IOException e) {
                throw new CTFReaderException(e);
            }
            bitBuffer.setByteBuffer(bb);
            StreamInputPacketIndexEntry packetIndex = new StreamInputPacketIndexEntry(packetOffsetBytes);
            if (tracePacketHeaderDef != null) {
                long streamID;
                IntegerDefinition streamIDDef;
                int magic;
                tracePacketHeaderDef.read(bitBuffer);
                IntegerDefinition magicDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("magic");
                if (magicDef != null && (magic = (int)magicDef.getValue()) != -1040441407) {
                    throw new CTFReaderException("CTF magic mismatch " + Integer.toHexString(magic) + " vs " + Integer.toHexString(-1040441407));
                }
                ArrayDefinition uuidDef = (ArrayDefinition)tracePacketHeaderDef.lookupDefinition("uuid");
                if (uuidDef != null) {
                    byte[] uuidArray = new byte[16];
                    int i = 0;
                    while (i < 16) {
                        IntegerDefinition uuidByteDef = (IntegerDefinition)uuidDef.getElem(i);
                        uuidArray[i] = (byte)uuidByteDef.getValue();
                        ++i;
                    }
                    UUID uuid = Utils.makeUUID(uuidArray);
                    if (!this.getStream().getTrace().getUUID().equals(uuid)) {
                        throw new CTFReaderException("UUID mismatch");
                    }
                }
                if ((streamIDDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("stream_id")) != null && (streamID = streamIDDef.getValue()) != this.getStream().getId()) {
                    throw new CTFReaderException("Stream ID changing within a StreamInput");
                }
            }
            if (streamPacketContextDef != null) {
                IntegerDefinition timestampEndDef;
                streamPacketContextDef.read(bitBuffer);
                IntegerDefinition contentSizeDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("content_size");
                packetIndex.contentSizeBits = contentSizeDef != null ? (int)contentSizeDef.getValue() : (int)(fileSizeBytes * 8L);
                IntegerDefinition packetSizeDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("packet_size");
                packetIndex.packetSizeBits = packetSizeDef != null ? (int)packetSizeDef.getValue() : (packetIndex.contentSizeBits != 0 ? packetIndex.contentSizeBits : (int)(fileSizeBytes * 8L));
                IntegerDefinition timestampBeginDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("timestamp_begin");
                if (timestampBeginDef != null) {
                    packetIndex.timestampBegin = timestampBeginDef.getValue();
                }
                if ((timestampEndDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("timestamp_end")) != null) {
                    packetIndex.timestampEnd = timestampEndDef.getValue();
                    this.setTimestampEnd(packetIndex.timestampEnd);
                }
            } else {
                packetIndex.contentSizeBits = (int)(fileSizeBytes * 8L);
                packetIndex.packetSizeBits = (int)(fileSizeBytes * 8L);
            }
            if (packetIndex.contentSizeBits > packetIndex.packetSizeBits) {
                throw new CTFReaderException("Content size > packet size");
            }
            if ((long)packetIndex.packetSizeBits > (fileSizeBytes - packetIndex.offsetBytes) * 8L) {
                throw new CTFReaderException("Not enough data remaining in the file for the size of this packet");
            }
            packetIndex.dataOffsetBits = bitBuffer.position();
            this.index.addEntry(packetIndex);
            packetOffsetBytes += (long)((packetIndex.packetSizeBits + 7) / 8);
        }
    }
}

