/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter;

import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.RangeFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.FilterWizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class RangeFilterWizardPage
extends FilterWizardPage {
    private final KeyListener numberKeyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.character >= ' ' && e.character <= '~' && (e.character > '9' || e.character < '0')) {
                e.doit = false;
            }
            if (e.character == '.' && !((Text)e.widget).getText().contains(".")) {
                e.doit = true;
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private Combo cboColumn;
    private Text txtLow;
    private Text txtHigh;
    private Button chkInclusive;
    private Button radInside;
    private Button radOutside;

    public RangeFilterWizardPage() {
        super("selectFilterOptions");
        this.setTitle(Localization.getString("RangeFilterWizardPage.CreateRangeFilter"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpFilterOpts = new Composite(comp, 0);
        cmpFilterOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpFilterOpts.setLayout((Layout)colLayout);
        Label lblColumn = new Label(cmpFilterOpts, 0);
        lblColumn.setText(Localization.getString("RangeFilterWizardPage.Column"));
        this.cboColumn = new Combo(cmpFilterOpts, 4);
        this.cboColumn.addSelectionListener(this.selectionListener);
        int i = 0;
        while (i < this.wizard.series.length) {
            this.cboColumn.add(this.wizard.series[i]);
            ++i;
        }
        new Label(cmpFilterOpts, 0);
        Label lblLow = new Label(cmpFilterOpts, 0);
        lblLow.setText(Localization.getString("RangeFilterWizardPage.LowerBound"));
        this.txtLow = new Text(cmpFilterOpts, 2048);
        this.txtLow.addModifyListener(this.modifyListener);
        this.txtLow.addKeyListener(this.numberKeyListener);
        new Label(cmpFilterOpts, 0);
        Label lblHigh = new Label(cmpFilterOpts, 0);
        lblHigh.setText(Localization.getString("RangeFilterWizardPage.UpperBound"));
        this.txtHigh = new Text(cmpFilterOpts, 2048);
        this.txtHigh.addModifyListener(this.modifyListener);
        this.txtHigh.addKeyListener(this.numberKeyListener);
        new Label(cmpFilterOpts, 0);
        this.radInside = new Button(cmpFilterOpts, 16);
        this.radInside.setText(Localization.getString("RangeFilterWizardPage.InsideBounds"));
        this.radInside.addSelectionListener(this.selectionListener);
        this.radInside.setSelection(true);
        this.radOutside = new Button(cmpFilterOpts, 16);
        this.radOutside.setText(Localization.getString("RangeFilterWizardPage.OutsideBounds"));
        this.radOutside.addSelectionListener(this.selectionListener);
        this.chkInclusive = new Button(cmpFilterOpts, 32);
        this.chkInclusive.setText(Localization.getString("RangeFilterWizardPage.Inclusive"));
        this.setControl((Control)comp);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    protected void createFilter() {
        int selected = this.cboColumn.getSelectionIndex();
        try {
            int style;
            double high = Double.parseDouble(this.txtHigh.getText().trim());
            double low = Double.parseDouble(this.txtLow.getText().trim());
            int n = style = this.radInside.getSelection() ? 0 : 1;
            if (this.chkInclusive.getSelection()) {
                style |= 2;
            }
            if (selected >= 0 && selected < this.cboColumn.getItemCount() && low <= high) {
                this.wizard.filter = new RangeFilter(selected, (Number)new Double(low), (Number)new Double(high), style);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void dispose() {
        super.dispose();
        if (this.cboColumn != null) {
            this.cboColumn.removeSelectionListener(this.selectionListener);
            this.cboColumn.dispose();
            this.cboColumn = null;
        }
        if (this.txtLow != null) {
            this.txtLow.removeModifyListener(this.modifyListener);
            this.txtLow.removeKeyListener(this.numberKeyListener);
            this.txtLow.dispose();
            this.txtLow = null;
        }
        if (this.txtHigh != null) {
            this.txtHigh.removeModifyListener(this.modifyListener);
            this.txtHigh.removeKeyListener(this.numberKeyListener);
            this.txtHigh.dispose();
            this.txtHigh = null;
        }
        if (this.chkInclusive != null) {
            this.chkInclusive.removeSelectionListener(this.selectionListener);
            this.chkInclusive.dispose();
            this.chkInclusive = null;
        }
        if (this.radInside != null) {
            this.radInside.removeSelectionListener(this.selectionListener);
            this.radInside.dispose();
            this.radInside = null;
        }
        if (this.radOutside != null) {
            this.radOutside.removeSelectionListener(this.selectionListener);
            this.radOutside.dispose();
            this.radOutside = null;
        }
    }
}

