/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.linuxtools.ctf.core.trace.CTFTraceReader;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class CtfIterator
extends CTFTraceReader
implements ITmfContext,
Comparable<CtfIterator> {
    private final CtfTmfTrace ctfTmfTrace;
    private CtfLocation curLocation;
    private long curRank;

    public CtfIterator(CtfTmfTrace trace) {
        super(trace.getCTFTrace());
        this.ctfTmfTrace = trace;
        this.curLocation = new CtfLocation(trace.getStartTime());
        this.curRank = 0L;
    }

    public CtfIterator(CtfTmfTrace trace, long timestampValue, long rank) {
        super(trace.getCTFTrace());
        this.ctfTmfTrace = trace;
        this.curLocation = new CtfLocation(this.getCurrentEvent().getTimestampValue());
        if (this.getCurrentEvent().getTimestampValue() != timestampValue) {
            this.seek(timestampValue);
        }
        this.curRank = rank;
    }

    public CtfTmfTrace getCtfTmfTrace() {
        return this.ctfTmfTrace;
    }

    public CtfTmfEvent getCurrentEvent() {
        StreamInputReader top = (StreamInputReader)this.prio.peek();
        if (top != null) {
            return new CtfTmfEvent(top.getCurrentEvent(), top, this.ctfTmfTrace);
        }
        return null;
    }

    public boolean seek(long timestamp) {
        boolean ret = false;
        ret = super.seek(timestamp);
        if (ret) {
            this.curLocation.setLocation(this.getCurrentEvent().getTimestampValue());
        }
        return ret;
    }

    @Override
    public long getRank() {
        CtfTmfEvent current = this.getCurrentEvent();
        if (current != null) {
            return this.getCurrentEvent().getRank();
        }
        return 0L;
    }

    @Override
    public void setRank(long rank) {
    }

    @Override
    public CtfIterator clone() {
        CtfIterator clone = null;
        clone = new CtfIterator(this.ctfTmfTrace, this.getCurrentEvent().getTimestampValue(), this.curRank);
        return clone;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setLocation(ITmfLocation<?> location) {
        this.curLocation = (CtfLocation)location;
    }

    public CtfLocation getLocation() {
        return this.curLocation;
    }

    @Override
    public void updateRank(int rank) {
        this.curRank = rank;
    }

    @Override
    public boolean isValidRank() {
        return true;
    }

    public boolean advance() {
        return super.advance();
    }

    @Override
    public int compareTo(CtfIterator o) {
        if (this.getRank() < o.getRank()) {
            return -1;
        }
        if (this.getRank() > o.getRank()) {
            return 1;
        }
        return 0;
    }
}

