/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.events;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;

public class TmfEventsCache {
    private final CachedEvent[] fCache;
    private int fCacheStartIndex = 0;
    private int fCacheEndIndex = 0;
    private ITmfTrace<?> fTrace;
    private final TmfEventsTable fTable;
    private ITmfFilter fFilter;
    private final ArrayList<Integer> fFilterIndex = new ArrayList();
    private Job job;

    public TmfEventsCache(int cacheSize, TmfEventsTable table) {
        this.fCache = new CachedEvent[cacheSize];
        this.fTable = table;
    }

    public void setTrace(ITmfTrace<?> trace) {
        this.fTrace = trace;
        this.clear();
    }

    public synchronized void clear() {
        this.fCacheStartIndex = 0;
        this.fCacheEndIndex = 0;
        this.fFilterIndex.clear();
    }

    public void applyFilter(ITmfFilter filter) {
        this.fFilter = filter;
        this.clear();
    }

    public void clearFilter() {
        this.fFilter = null;
        this.clear();
    }

    public synchronized CachedEvent getEvent(int index) {
        if (index >= this.fCacheStartIndex && index < this.fCacheEndIndex) {
            int i = index - this.fCacheStartIndex;
            return this.fCache[i];
        }
        this.populateCache(index);
        return null;
    }

    public synchronized CachedEvent peekEvent(int index) {
        if (index >= this.fCacheStartIndex && index < this.fCacheEndIndex) {
            int i = index - this.fCacheStartIndex;
            return this.fCache[i];
        }
        return null;
    }

    public synchronized void storeEvent(ITmfEvent event, long rank, int index) {
        int i;
        if (this.fCacheStartIndex == this.fCacheEndIndex) {
            this.fCacheStartIndex = index;
            this.fCacheEndIndex = index;
        }
        if (index == this.fCacheEndIndex && (i = index - this.fCacheStartIndex) < this.fCache.length) {
            this.fCache[i] = new CachedEvent(event.clone(), rank);
            ++this.fCacheEndIndex;
        }
        if (this.fFilter != null && index % this.fCache.length == 0) {
            i = index / this.fCache.length;
            this.fFilterIndex.add(i, (int)rank);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getFilteredEventIndex(final long rank) {
        int startRank;
        int current;
        TmfEventsCache tmfEventsCache = this;
        synchronized (tmfEventsCache) {
            int start = 0;
            int end = this.fFilterIndex.size();
            if (this.fCacheEndIndex - this.fCacheStartIndex > 1) {
                if (rank < this.fCache[0].rank) {
                    end = this.fCacheStartIndex / this.fCache.length + 1;
                } else if (rank > this.fCache[this.fCacheEndIndex - this.fCacheStartIndex - 1].rank) {
                    start = this.fCacheEndIndex / this.fCache.length;
                } else {
                    int i = 0;
                    while (i < this.fCacheEndIndex - this.fCacheStartIndex) {
                        if (this.fCache[i].rank >= rank) {
                            return this.fCacheStartIndex + i;
                        }
                        ++i;
                    }
                    return this.fCacheEndIndex;
                }
            }
            current = (start + end) / 2;
            while (current != start) {
                if (rank < (long)this.fFilterIndex.get(current).intValue()) {
                    end = current;
                    current = (start + end) / 2;
                    continue;
                }
                start = current;
                current = (start + end) / 2;
            }
            startRank = this.fFilterIndex.get(current);
        }
        int index = current * this.fCache.length;
        class DataRequest<T extends ITmfEvent>
        extends TmfDataRequest<T> {
            int fRank;
            int fIndex;

            DataRequest(Class<T> dataType, int start, int nbRequested) {
                super(dataType, start, nbRequested);
                this.fRank = start;
                this.fIndex = n;
            }

            public void handleData(T event) {
                super.handleData(event);
                if (this.isCancelled()) {
                    return;
                }
                if ((long)this.fRank >= rank) {
                    this.cancel();
                    return;
                }
                ++this.fRank;
                if (fFilter.matches(event)) {
                    ++this.fIndex;
                }
            }

            public int getFilteredIndex() {
                return this.fIndex;
            }
        }
        DataRequest request = new DataRequest(ITmfEvent.class, startRank, Integer.MAX_VALUE, index);
        this.fTrace.sendRequest((ITmfDataRequest)request);
        try {
            request.waitForCompletion();
            return request.getFilteredIndex();
        }
        catch (InterruptedException interruptedException) {
            return 0;
        }
    }

    private synchronized void populateCache(final int index) {
        if (this.job != null && this.job.getState() != 0) {
            if (index >= this.fCacheStartIndex && index < this.fCacheStartIndex + this.fCache.length) {
                return;
            }
            this.job.cancel();
        }
        this.fCacheStartIndex = index;
        this.fCacheEndIndex = index;
        this.job = new Job("Fetching Events"){
            private int startIndex;
            private int skipCount;
            {
                super($anonymous0);
                this.startIndex = n;
                this.skipCount = 0;
            }

            protected IStatus run(final IProgressMonitor monitor) {
                int nbRequested;
                if (TmfEventsCache.this.fFilter == null) {
                    nbRequested = TmfEventsCache.this.fCache.length;
                } else {
                    nbRequested = Integer.MAX_VALUE;
                    int i = index / TmfEventsCache.this.fCache.length;
                    if (i < TmfEventsCache.this.fFilterIndex.size()) {
                        this.startIndex = (Integer)TmfEventsCache.this.fFilterIndex.get(i);
                        this.skipCount = index - i * TmfEventsCache.this.fCache.length;
                    }
                }
                TmfDataRequest<ITmfEvent> request = new TmfDataRequest<ITmfEvent>(ITmfEvent.class, this.startIndex, nbRequested){
                    private int count;
                    private long rank;
                    {
                        super($anonymous0, $anonymous1, $anonymous2);
                        this.count = 0;
                        this.rank = startIndex;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleData(ITmfEvent event) {
                        if (monitor.isCanceled()) {
                            this.cancel();
                            return;
                        }
                        super.handleData(event);
                        if (event != null && (TmfEventsCache.this.fFilter == null || TmfEventsCache.this.fFilter.matches(event))) {
                            1 v0 = this;
                            int n = v0.skipCount;
                            v0.skipCount = n - 1;
                            if (n <= 0) {
                                TmfEventsCache tmfEventsCache = TmfEventsCache.this;
                                synchronized (tmfEventsCache) {
                                    ((TmfEventsCache)(this).TmfEventsCache.this).fCache[this.count] = new CachedEvent(event.clone(), this.rank);
                                    ++this.count;
                                    TmfEventsCache tmfEventsCache2 = TmfEventsCache.this;
                                    tmfEventsCache2.fCacheEndIndex = tmfEventsCache2.fCacheEndIndex + 1;
                                }
                                if (TmfEventsCache.this.fFilter != null) {
                                    TmfEventsCache.this.fTable.cacheUpdated(false);
                                }
                            }
                        }
                        if (this.count >= TmfEventsCache.this.fCache.length) {
                            this.cancel();
                        } else if (TmfEventsCache.this.fFilter != null && this.count >= TmfEventsCache.this.fTable.getTable().getItemCount() - 3) {
                            this.cancel();
                        }
                        ++this.rank;
                    }
                };
                TmfEventsCache.this.fTrace.sendRequest((ITmfDataRequest)request);
                try {
                    request.waitForCompletion();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TmfEventsCache.this.fTable.cacheUpdated(true);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(20);
        this.job.schedule();
    }

    public static class CachedEvent {
        ITmfEvent event;
        long rank;

        public CachedEvent(ITmfEvent iTmfEvent, long rank) {
            this.event = iTmfEvent;
            this.rank = rank;
        }
    }
}

