/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewFactory {
    private static ArrayList<IViewPart> views;
    private static SystemTapView newView;

    public static SystemTapView createView(final String viewID) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID);
                    if (!(view instanceof SystemTapView)) {
                        throw new Exception("Miscast type: " + view.getClass().toString());
                    }
                    newView = (SystemTapView)view;
                    newView.setViewID();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ViewFactory.addView(newView);
        return newView;
    }

    public static SystemTapView createView(final String viewID, final String secondaryID) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID, secondaryID, 2);
                    if (!(view instanceof SystemTapView)) {
                        throw new Exception("Miscast type: " + view.getClass().toString());
                    }
                    newView = (SystemTapView)view;
                    newView.setViewID();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ViewFactory.addView(newView);
        return newView;
    }

    public static void addView(SystemTapView view) {
        if (views == null) {
            views = new ArrayList();
        }
        views.add((IViewPart)view);
    }

    public static IViewPart getView() {
        for (IViewPart view : views) {
            if (!(view instanceof SystemTapView)) continue;
            return view;
        }
        return null;
    }

    public static SystemTapView[] getViews() {
        return views.toArray(new SystemTapView[views.size()]);
    }
}

