/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.colors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.linuxtools.internal.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.xml.TmfFilterContentHandler;
import org.eclipse.linuxtools.tmf.core.filter.xml.TmfFilterXMLWriter;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSetting;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ColorSettingsXML {
    private static final String COLOR_SETTINGS_TAG = "COLOR_SETTINGS";
    private static final String COLOR_SETTING_TAG = "COLOR_SETTING";
    private static final String FG_TAG = "FG";
    private static final String BG_TAG = "BG";
    private static final String R_ATTR = "R";
    private static final String G_ATTR = "G";
    private static final String B_ATTR = "B";
    private static final String TICK_COLOR_TAG = "TICK_COLOR";
    private static final String INDEX_ATTR = "INDEX";
    private static final String FILTER_TAG = "FILTER";

    public static void save(String pathName, ColorSetting[] colorSettings) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement(COLOR_SETTINGS_TAG);
            document.appendChild(rootElement);
            ColorSetting[] colorSettingArray = colorSettings;
            int n = colorSettings.length;
            int n2 = 0;
            while (n2 < n) {
                ColorSetting colorSetting = colorSettingArray[n2];
                Element colorSettingElement = document.createElement(COLOR_SETTING_TAG);
                rootElement.appendChild(colorSettingElement);
                Element fgElement = document.createElement(FG_TAG);
                colorSettingElement.appendChild(fgElement);
                RGB foreground = colorSetting.getForegroundRGB();
                fgElement.setAttribute(R_ATTR, Integer.toString(foreground.red));
                fgElement.setAttribute(G_ATTR, Integer.toString(foreground.green));
                fgElement.setAttribute(B_ATTR, Integer.toString(foreground.blue));
                Element bgElement = document.createElement(BG_TAG);
                colorSettingElement.appendChild(bgElement);
                RGB background = colorSetting.getBackgroundRGB();
                bgElement.setAttribute(R_ATTR, Integer.toString(background.red));
                bgElement.setAttribute(G_ATTR, Integer.toString(background.green));
                bgElement.setAttribute(B_ATTR, Integer.toString(background.blue));
                Element tickColorElement = document.createElement(TICK_COLOR_TAG);
                colorSettingElement.appendChild(tickColorElement);
                int index = colorSetting.getTickColorIndex();
                tickColorElement.setAttribute(INDEX_ATTR, Integer.toString(index));
                if (colorSetting.getFilter() != null) {
                    Element filterElement = document.createElement(FILTER_TAG);
                    colorSettingElement.appendChild(filterElement);
                    TmfFilterXMLWriter.buildXMLTree((Document)document, (ITmfFilterTreeNode)colorSetting.getFilter(), (Element)filterElement);
                }
                ++n2;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(pathName));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            TmfUiPlugin.getDefault().logError("Error saving color xml file: " + pathName, e);
        }
        catch (TransformerConfigurationException e) {
            TmfUiPlugin.getDefault().logError("Error saving color xml file: " + pathName, e);
        }
        catch (TransformerException e) {
            TmfUiPlugin.getDefault().logError("Error saving color xml file: " + pathName, e);
        }
    }

    public static ColorSetting[] load(String pathName) {
        if (!new File(pathName).canRead()) {
            return new ColorSetting[0];
        }
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        ColorSettingsContentHandler handler = new ColorSettingsContentHandler();
        try {
            XMLReader saxReader = parserFactory.newSAXParser().getXMLReader();
            saxReader.setContentHandler(handler);
            saxReader.parse(pathName);
            return handler.colorSettings.toArray(new ColorSetting[0]);
        }
        catch (ParserConfigurationException e) {
            TmfUiPlugin.getDefault().logError("Error loading color xml file: " + pathName, e);
        }
        catch (SAXException e) {
            TmfUiPlugin.getDefault().logError("Error loading color xml file: " + pathName, e);
        }
        catch (IOException e) {
            TmfUiPlugin.getDefault().logError("Error loading color xml file: " + pathName, e);
        }
        for (ColorSetting colorSetting : handler.colorSettings) {
            colorSetting.dispose();
        }
        return new ColorSetting[0];
    }

    private static class ColorSettingsContentHandler
    extends DefaultHandler {
        private List<ColorSetting> colorSettings = new ArrayList<ColorSetting>(0);
        private RGB fg;
        private RGB bg;
        private int tickColorIndex;
        private ITmfFilterTreeNode filter;
        private TmfFilterContentHandler filterContentHandler;

        private ColorSettingsContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals(ColorSettingsXML.COLOR_SETTINGS_TAG)) {
                this.colorSettings = new ArrayList<ColorSetting>();
            } else if (localName.equals(ColorSettingsXML.COLOR_SETTING_TAG)) {
                this.fg = null;
                this.bg = null;
                this.filter = null;
            } else if (localName.equals(ColorSettingsXML.FG_TAG)) {
                int r = Integer.valueOf(attributes.getValue(ColorSettingsXML.R_ATTR));
                int g = Integer.valueOf(attributes.getValue(ColorSettingsXML.G_ATTR));
                int b = Integer.valueOf(attributes.getValue(ColorSettingsXML.B_ATTR));
                this.fg = new RGB(r, g, b);
            } else if (localName.equals(ColorSettingsXML.BG_TAG)) {
                int r = Integer.valueOf(attributes.getValue(ColorSettingsXML.R_ATTR));
                int g = Integer.valueOf(attributes.getValue(ColorSettingsXML.G_ATTR));
                int b = Integer.valueOf(attributes.getValue(ColorSettingsXML.B_ATTR));
                this.bg = new RGB(r, g, b);
            } else if (localName.equals(ColorSettingsXML.TICK_COLOR_TAG)) {
                int index;
                this.tickColorIndex = index = Integer.valueOf(attributes.getValue(ColorSettingsXML.INDEX_ATTR)).intValue();
            } else if (localName.equals(ColorSettingsXML.FILTER_TAG)) {
                this.filterContentHandler = new TmfFilterContentHandler();
            } else if (this.filterContentHandler != null) {
                this.filterContentHandler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!localName.equals(ColorSettingsXML.COLOR_SETTINGS_TAG)) {
                if (localName.equals(ColorSettingsXML.COLOR_SETTING_TAG)) {
                    ColorSetting colorSetting = new ColorSetting(this.fg, this.bg, this.tickColorIndex, this.filter);
                    this.colorSettings.add(colorSetting);
                } else if (localName.equals(ColorSettingsXML.FILTER_TAG)) {
                    this.filter = this.filterContentHandler.getTree();
                    this.filterContentHandler = null;
                } else if (this.filterContentHandler != null) {
                    this.filterContentHandler.endElement(uri, localName, qName);
                }
            }
        }
    }
}

