/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view.annotatedsource;

import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.AbstractSTAnnotatedSourceEditorInput;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.ISTAnnotationColumn;
import org.eclipse.linuxtools.internal.gcov.parser.Line;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.CoverageAnnotationColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class STAnnotatedSourceEditorInput
extends AbstractSTAnnotatedSourceEditorInput {
    private final SourceFile sourceFile;
    private final int lineCount;
    private final ArrayList<ISTAnnotationColumn> columns = new ArrayList();
    public static final Color GREEN = new Color((Device)PlatformUI.getWorkbench().getDisplay(), 0, 128, 0);
    private static final Color[] greenColors = new Color[129];

    public STAnnotatedSourceEditorInput(IFileStore fileStore, SourceFile sourceFile) {
        super(fileStore);
        this.sourceFile = sourceFile;
        this.lineCount = sourceFile.getLines().size();
        this.columns.add(new CoverageAnnotationColumn(sourceFile));
    }

    public Color getColor(int ln) {
        ArrayList<Line> lines;
        Line line;
        int index = ln + 1;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (index < this.lineCount && (line = (lines = this.sourceFile.getLines()).get(index)).isExists()) {
            long count = line.getCount();
            if (count == 0L) {
                return display.getSystemColor(3);
            }
            if (count == this.sourceFile.getmaxLineCount()) {
                return GREEN;
            }
            int colorIndex = 128 - (int)(128L * count / this.sourceFile.getmaxLineCount());
            if (greenColors[colorIndex] == null) {
                STAnnotatedSourceEditorInput.greenColors[colorIndex] = new Color((Device)display, colorIndex, 127 + colorIndex, colorIndex);
            }
            return greenColors[colorIndex];
        }
        return display.getSystemColor(1);
    }

    public ArrayList<ISTAnnotationColumn> getColumns() {
        return this.columns;
    }
}

