/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenExperimentHandler
extends AbstractHandler {
    private static final String BOOKMARKS_HIDDEN_FILE = ".bookmarks";
    private TmfExperimentElement fExperiment = null;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fExperiment = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfExperimentElement) {
            this.fExperiment = (TmfExperimentElement)element;
        }
        return this.fExperiment != null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        try {
            IFile bookmarksFile = this.fExperiment.getProject().getExperimentsFolder().getResource().getFile(BOOKMARKS_HIDDEN_FILE);
            if (!bookmarksFile.exists()) {
                ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                bookmarksFile.create((InputStream)source, true, null);
            }
            bookmarksFile.setHidden(true);
            IFile file = this.fExperiment.getResource().getFile(String.valueOf(this.fExperiment.getName()) + '_');
            if (!file.exists()) {
                file.createLink(bookmarksFile.getLocation(), 256, null);
            }
            file.setHidden(true);
            file.setPersistentProperty(TmfCommonConstants.TRACETYPE, TmfExperiment.class.getCanonicalName());
            List<TmfTraceElement> traceEntries = this.fExperiment.getTraces();
            int nbTraces = traceEntries.size();
            int cacheSize = Integer.MAX_VALUE;
            boolean useEditor = true;
            String experimentEditorId = null;
            ITmfTrace[] traces = new ITmfTrace[nbTraces];
            int i = 0;
            while (i < nbTraces) {
                TmfTraceElement element = traceEntries.get(i);
                element = element.getElementUnderTraceFolder();
                ITmfTrace<?> trace = element.instantiateTrace();
                ITmfEvent traceEvent = element.instantiateEvent();
                if (trace == null || traceEvent == null) {
                    this.displayErrorMsg(Messages.OpenExperimentHandler_NoTraceType);
                    int j = 0;
                    while (j < i) {
                        traces[j].dispose();
                        ++j;
                    }
                    return null;
                }
                try {
                    trace.initTrace(element.getResource(), element.getLocation().getPath(), traceEvent.getClass());
                }
                catch (TmfTraceException tmfTraceException) {
                    this.displayErrorMsg("");
                }
                cacheSize = Math.min(cacheSize, trace.getCacheSize());
                String editorId = element.getEditorId();
                if (editorId == null) {
                    useEditor = false;
                    experimentEditorId = null;
                } else if (useEditor) {
                    if (experimentEditorId == null) {
                        experimentEditorId = editorId;
                    } else if (!editorId.equals(experimentEditorId)) {
                        useEditor = false;
                    }
                }
                traces[i] = trace;
                ++i;
            }
            TmfExperiment experiment = useEditor ? new TmfExperiment(ITmfEvent.class, this.fExperiment.getName(), traces, cacheSize){

                public void initTrace(IResource resource, String path, Class type) {
                    super.initTrace(resource, path, type);
                    this.getIndexer().buildIndex(this.getNbEvents(), TmfTimeRange.ETERNITY, false);
                }
            } : new TmfExperiment(ITmfEvent.class, this.fExperiment.getName(), traces, cacheSize);
            experiment.setBookmarksFile(file);
            if (useEditor) {
                TmfEditorInput editorInput = new TmfEditorInput(file, (ITmfTrace<?>)experiment);
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = activePage.findEditor((IEditorInput)new FileEditorInput(file));
                if (editor != null && editor instanceof IReusableEditor) {
                    activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                    activePage.activate((IWorkbenchPart)editor);
                } else {
                    activePage.openEditor((IEditorInput)editorInput, "org.eclipse.linuxtools.tmf.ui.editors.events");
                }
                experiment.initTrace(null, null, null);
                IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.linuxtools.tmf.ui.editors.events");
            } else {
                TmfExperiment.setCurrentExperiment((TmfExperiment)experiment);
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfExperimentSelectedSignal((Object)this, experiment));
                IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.linuxtools.tmf.ui.editors.eventsView");
            }
        }
        catch (CoreException e) {
            this.displayErrorMsg(e.getMessage());
        }
        return null;
    }

    private void displayErrorMsg(String errorMsg) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(Messages.OpenExperimentHandler_Title);
        mb.setMessage(errorMsg);
        mb.open();
    }
}

