/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.gprof.Activator;
import org.eclipse.linuxtools.internal.gprof.dialog.OpenGmonDialog;
import org.eclipse.linuxtools.internal.gprof.view.GmonView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenGmonAction
implements IEditorLauncher {
    private static int instanceNum = 0;

    public void open(IPath file) {
        String s = this.getDefaultBinary(file);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        OpenGmonDialog d = new OpenGmonDialog(shell, s, file);
        if (d.open() != 0) {
            return;
        }
        String binaryPath = d.getBinaryFile();
        IProject project = null;
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        if (f != null) {
            project = f.getProject();
        }
        GmonView.displayGprofView(binaryPath, file.toOSString(), project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDefaultBinary(IPath file) {
        File gmonFile = file.toFile();
        File parent = gmonFile.getParentFile();
        File info = new File(parent, "AnalysisInfo.txt");
        IProject project = null;
        IFile ifile = null;
        try {
            if (info.exists()) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(info.toString()));
                    while (true) {
                        String line;
                        if ((line = br.readLine()) == null) {
                            return "";
                        }
                        String[] tab = line.split("=");
                        String name = "";
                        String value = "";
                        if (tab.length <= 1) continue;
                        name = tab[0];
                        value = tab[1].trim();
                        if (name.equals("Project Name ")) {
                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(value);
                            continue;
                        }
                        if (name.equals("Program Name ") && project != null && (ifile = project.getFile(value)).exists()) break;
                    }
                    String string = ifile.getLocation().toString();
                    return string;
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
            IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
            if (c == null) return "";
            project = c.getProject();
            if (project == null) return "";
            if (!project.exists()) return "";
            ICProject cproject = CoreModel.getDefault().create(project);
            if (cproject == null) return "";
            try {
                IBinary[] b = cproject.getBinaryContainer().getBinaries();
                if (b == null) return "";
                if (b.length <= 0) return "";
                if (b[0] == null) return "";
                IResource r = b[0].getResource();
                return r.getLocation().toOSString();
            }
            catch (CModelException cModelException) {
                return "";
            }
        }
        catch (FileNotFoundException e) {
            Status status = new Status(2, "org.eclipse.linuxtools.gprof", 2, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return "";
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.gprof", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return "";
    }
}

