/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.state;

import org.eclipse.linuxtools.internal.lttng.core.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventField;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngProcessState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;

public abstract class AbsStateProcessing {
    protected Long getAFieldLong(LttngEvent trcEvent, LttngTraceState traceSt, StateStrings.Fields expectedField) {
        Long fieldVal = 0L;
        String fieldname = expectedField.getInName();
        LttngEventField field = trcEvent.getContent().getField(fieldname);
        if (field == null) {
            TraceDebug.debug("***************** CONTENT : " + trcEvent.getContent().toString());
        } else {
            Object fieldObj = field.getValue();
            if (fieldObj instanceof Long || fieldObj instanceof Integer) {
                fieldVal = (Long)field.getValue();
            } else if (TraceDebug.isDEBUG()) {
                TraceDebug.debug("Unexpected field Type. Expected: Long, Received: " + fieldObj.getClass().getSimpleName());
            }
        }
        return fieldVal;
    }

    protected String getAFieldString(LttngEvent trcEvent, LttngTraceState traceSt, StateStrings.Fields expectedField) {
        String fieldVal = "";
        String fieldname = expectedField.getInName();
        LttngEventField field = trcEvent.getContent().getField(fieldname);
        if (field == null) {
            TraceDebug.debug("***************** CONTENT : " + trcEvent.getContent().toString());
        } else {
            Object fieldObj = field.getValue();
            if (fieldObj instanceof String) {
                fieldVal = (String)field.getValue();
            } else if (TraceDebug.isDEBUG()) {
                TraceDebug.debug("Unexpected field Type. Expected: String, Received: " + fieldObj.getClass().getSimpleName());
            }
        }
        return fieldVal;
    }

    protected LttngProcessState lttv_state_find_process(LttngTraceState traceState, Long cpu, Long pid) {
        return traceState.findProcessState(pid, cpu, traceState.getTraceId());
    }

    protected void sendNoFieldFoundMsg(TmfEventField[] fields, String expectedFieldName) {
        StringBuilder sb = new StringBuilder("Field not found, requested: " + expectedFieldName);
        sb.append(" number of fields: " + fields.length + "Fields: ");
        int i = 0;
        while (i < fields.length) {
            LttngEventField field = (LttngEventField)fields[i];
            sb.append(String.valueOf(field.getName()) + " ");
            ++i;
        }
        TraceDebug.debug(sb.toString(), 5);
    }
}

