/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.preferences;

import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.logging.ControlCommandLogger;

public class ControlPreferences {
    public static final String TRACE_CONTROL_LOG_FILENAME = "lttng_tracer_control.log";
    public static final String TRACE_CONTROL_TRACING_GROUP_PREF = "trace.control.tracing.group";
    public static final String TRACE_CONTROL_LOG_COMMANDS_PREF = "trace.control.log.commands";
    public static final String TRACE_CONTROL_LOG_APPEND_PREF = "trace.control.log.append";
    public static final String TRACE_CONTROL_LOG_FILE_PATH_PREF = "trace.control.log.path";
    public static final String TRACE_CONTROL_VERBOSE_LEVEL_PREF = "trace.control.verbose.level";
    public static final String TRACE_CONTROL_VERBOSE_LEVEL_NONE = "trace.control.verbose.level.none";
    public static final String TRACE_CONTROL_VERBOSE_LEVEL_VERBOSE = "trace.control.verbose.level.v";
    public static final String TRACE_CONTROL_VERBOSE_LEVEL_V_VERBOSE = "trace.control.verbose.level.vv";
    public static final String TRACE_CONTROL_VERBOSE_LEVEL_V_V_VERBOSE = "trace.control.verbose.level.vvv";
    public static final String TRACE_CONTROL_DEFAULT_TRACING_GROUP = "tracing";
    public static final String TRACE_CONTROL_DEFAULT_LOG_PATH = String.valueOf(System.getProperty("user.home")) + File.separator + "lttng_tracer_control.log";
    private static ControlPreferences fInstance = null;
    private IPreferenceStore fPreferenceStore = null;

    private ControlPreferences() {
    }

    public static synchronized ControlPreferences getInstance() {
        if (fInstance == null) {
            fInstance = new ControlPreferences();
        }
        return fInstance;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public boolean isDefaultTracingGroup() {
        return this.fPreferenceStore.getString(TRACE_CONTROL_TRACING_GROUP_PREF).equals(this.fPreferenceStore.getDefaultString(TRACE_CONTROL_TRACING_GROUP_PREF));
    }

    public String getTracingGroup() {
        return this.fPreferenceStore.getString(TRACE_CONTROL_TRACING_GROUP_PREF);
    }

    public boolean isLoggingEnabled() {
        return this.fPreferenceStore.getBoolean(TRACE_CONTROL_LOG_COMMANDS_PREF);
    }

    public boolean isAppend() {
        return this.fPreferenceStore.getBoolean(TRACE_CONTROL_LOG_APPEND_PREF);
    }

    public String getVerboseLevel() {
        return this.fPreferenceStore.getString(TRACE_CONTROL_VERBOSE_LEVEL_PREF);
    }

    public String getLogfilePath() {
        return this.fPreferenceStore.getString(TRACE_CONTROL_LOG_FILE_PATH_PREF);
    }

    public void init(IPreferenceStore preferenceStore) {
        this.fPreferenceStore = preferenceStore;
        if (this.fPreferenceStore.getBoolean(TRACE_CONTROL_LOG_COMMANDS_PREF)) {
            ControlCommandLogger.init(this.getLogfilePath(), this.isAppend());
        }
    }

    public void dispose() {
        ControlCommandLogger.close();
    }
}

