/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.editors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;

public class EventsViewEditor
extends TmfEditor {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.editors.eventsView";
    private IFile fFile;
    private ITmfTrace fTrace;
    private IMarker fGotoMarker;
    private boolean fEditorAreaVisible;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.fEditorAreaVisible = site.getPage().isEditorAreaVisible();
        if (input instanceof TmfEditorInput) {
            this.fFile = ((TmfEditorInput)input).getFile();
            this.fTrace = ((TmfEditorInput)input).getTrace();
        } else if (input instanceof IFileEditorInput) {
            block28: {
                this.fFile = ((IFileEditorInput)input).getFile();
                if (this.fFile == null) {
                    throw new PartInitException("Invalid IFileEditorInput: " + input);
                }
                TmfExperiment currentExperiment = TmfExperiment.getCurrentExperiment();
                if (currentExperiment != null && this.fFile.equals((Object)currentExperiment.getBookmarksFile())) {
                    this.fTrace = currentExperiment;
                    super.setSite((IWorkbenchPartSite)site);
                    super.setInput(input);
                    return;
                }
                try {
                    String traceTypeId = this.fFile.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                    if (traceTypeId == null) {
                        throw new PartInitException(Messages.OpenTraceHandler_NoTraceType);
                    }
                    if (traceTypeId.equals(TmfExperiment.class.getCanonicalName())) {
                        TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
                        ncp.getChildren(this.fFile.getProject());
                        TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject());
                        if (project == null) {
                            throw new PartInitException(Messages.OpenExperimentHandler_NoTraceType);
                        }
                        for (ITmfProjectModelElement projectElement : project.getExperimentsFolder().getChildren()) {
                            String traceName = this.fFile.getParent().getName();
                            if (!projectElement.getName().equals(traceName)) continue;
                            TmfExperimentElement experimentElement = (TmfExperimentElement)projectElement;
                            List<TmfTraceElement> traceEntries = experimentElement.getTraces();
                            int nbTraces = traceEntries.size();
                            int cacheSize = Integer.MAX_VALUE;
                            ITmfTrace[] traces = new ITmfTrace[nbTraces];
                            int i = 0;
                            while (i < nbTraces) {
                                TmfTraceElement traceElement = traceEntries.get(i);
                                ITmfTrace<?> trace = traceElement.instantiateTrace();
                                ITmfEvent traceEvent = traceElement.instantiateEvent();
                                if (trace == null || traceEvent == null) {
                                    int j = 0;
                                    while (j < i) {
                                        traces[j].dispose();
                                        ++j;
                                    }
                                    throw new PartInitException(Messages.OpenExperimentHandler_NoTraceType);
                                }
                                try {
                                    trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                                }
                                catch (TmfTraceException tmfTraceException) {}
                                cacheSize = Math.min(cacheSize, trace.getCacheSize());
                                traces[i] = trace;
                                ++i;
                            }
                            TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, experimentElement.getName(), traces, cacheSize);
                            experiment.setBookmarksFile(this.fFile);
                            this.fTrace = experiment;
                            TmfExperiment.setCurrentExperiment((TmfExperiment)experiment);
                            TmfSignalManager.dispatchSignal((TmfSignal)new TmfExperimentSelectedSignal((Object)this, experiment));
                            break block28;
                        }
                        break block28;
                    }
                    if (traceTypeId.equals(TmfTrace.class.getCanonicalName())) {
                        TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
                        ncp.getChildren(this.fFile.getProject());
                        TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject());
                        for (ITmfProjectModelElement projectElement : project.getTracesFolder().getChildren()) {
                            String traceName = this.fFile.getParent().getName();
                            if (!projectElement.getName().equals(traceName)) continue;
                            TmfTraceElement traceElement = (TmfTraceElement)projectElement;
                            ITmfTrace<?> trace = traceElement.instantiateTrace();
                            ITmfEvent traceEvent = traceElement.instantiateEvent();
                            if (trace == null || traceEvent == null) {
                                throw new PartInitException(Messages.OpenTraceHandler_NoTraceType);
                            }
                            try {
                                trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                            }
                            catch (TmfTraceException tmfTraceException) {}
                            ITmfTrace[] traces = new ITmfTrace[]{trace};
                            TmfExperiment experiment = new TmfExperiment(traceEvent.getClass(), traceElement.getName(), traces, trace.getCacheSize());
                            experiment.setBookmarksFile(this.fFile);
                            this.fTrace = experiment;
                            TmfExperiment.setCurrentExperiment((TmfExperiment)experiment);
                            TmfSignalManager.dispatchSignal((TmfSignal)new TmfExperimentSelectedSignal((Object)this, experiment));
                            break block28;
                        }
                        break block28;
                    }
                    TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
                    ncp.getChildren(this.fFile.getProject());
                    TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject());
                    for (ITmfProjectModelElement projectElement : project.getTracesFolder().getChildren()) {
                        if (!projectElement.getResource().equals((Object)this.fFile)) continue;
                        TmfTraceElement traceElement = (TmfTraceElement)projectElement;
                        ITmfTrace<?> trace = traceElement.instantiateTrace();
                        ITmfEvent traceEvent = traceElement.instantiateEvent();
                        if (trace == null || traceEvent == null) {
                            throw new PartInitException(Messages.OpenTraceHandler_NoTraceType);
                        }
                        try {
                            trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                        }
                        catch (TmfTraceException tmfTraceException) {}
                        ITmfTrace[] traces = new ITmfTrace[]{trace};
                        TmfExperiment experiment = new TmfExperiment(traceEvent.getClass(), traceElement.getName(), traces, trace.getCacheSize());
                        experiment.setBookmarksFile(this.fFile);
                        this.fTrace = experiment;
                        TmfExperiment.setCurrentExperiment((TmfExperiment)experiment);
                        TmfSignalManager.dispatchSignal((TmfSignal)new TmfExperimentSelectedSignal((Object)this, experiment));
                        break;
                    }
                }
                catch (InvalidRegistryObjectException e) {
                    Activator.getDefault().logError("Error initializing EventsViewEditor", e);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error initializing EventsViewEditor", e);
                }
            }
            input = new TmfEditorInput(this.fFile, this.fTrace);
        } else {
            throw new PartInitException("Invalid IEditorInput: " + input.getClass());
        }
        if (this.fTrace == null) {
            throw new PartInitException("Invalid IEditorInput: " + this.fFile.getName());
        }
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.setPartName(this.getEditorInput().getName());
    }

    public void setFocus() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EventsViewEditor editorPart = EventsViewEditor.this;
                IWorkbenchPage page = editorPart.getEditorSite().getPage();
                page.closeEditor((IEditorPart)editorPart, false);
                if (page.getEditorReferences().length == 0) {
                    page.setEditorAreaVisible(EventsViewEditor.this.fEditorAreaVisible);
                }
                try {
                    IGotoMarker adapter;
                    IViewPart viewPart = page.showView("org.eclipse.linuxtools.tmf.ui.views.events");
                    if (EventsViewEditor.this.fGotoMarker != null && (adapter = (IGotoMarker)viewPart.getAdapter(IGotoMarker.class)) != null) {
                        adapter.gotoMarker(EventsViewEditor.this.fGotoMarker);
                    }
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError("Error setting focus", e);
                }
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            return new IGotoMarker(){

                public void gotoMarker(IMarker marker) {
                    EventsViewEditor.this.fGotoMarker = marker;
                }
            };
        }
        return super.getAdapter(adapter);
    }
}

