/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model;

import java.util.Collection;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.FixedArray;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.Statistics;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.StatisticsData;

public class StatisticsTreeNode
implements Comparable<StatisticsTreeNode> {
    private Statistics fValue;
    private FixedArray fPath;
    private StatisticsData fNodes;
    private String fName = "";

    public StatisticsTreeNode(FixedArray path, StatisticsData nodes) {
        this(path, nodes, "");
    }

    public StatisticsTreeNode(FixedArray path, StatisticsData nodes, String name) {
        this.fPath = path;
        this.fNodes = nodes;
        this.fName = name;
        this.fValue = new Statistics();
    }

    public boolean containsChild(Integer key) {
        if (StatisticsData.ROOT == this.fPath) {
            return this.fNodes.get(new FixedArray(key)) != null;
        }
        return this.fNodes.get(this.fPath.append((int)key)) != null;
    }

    public Collection<StatisticsTreeNode> getChildren() {
        return this.fNodes.getChildren(this.fPath);
    }

    public Integer getKey() {
        return this.fPath.get(this.fPath.size() - 1);
    }

    public int getNbChildren() {
        return this.fNodes.getChildren(this.fPath).size();
    }

    public StatisticsTreeNode getParent() {
        return this.fNodes.getParent(this.fPath);
    }

    public FixedArray getPath() {
        return this.fPath;
    }

    public Statistics getValue() {
        return this.fValue;
    }

    public boolean hasChildren() {
        return !this.fNodes.getChildren(this.fPath).isEmpty();
    }

    public void reset() {
        this.fValue = new Statistics();
        this.fNodes.reset(this.fPath);
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public String getContent() {
        return String.valueOf(this.fName) + ": [nbEvents=" + this.fValue.nbEvents + ", cpuTime=" + this.fValue.cpuTime + ", cumulativeCpuTime=" + this.fValue.cumulativeCpuTime + ", elapsedTime=" + this.fValue.elapsedTime + "]";
    }

    @Override
    public int compareTo(StatisticsTreeNode o) {
        return this.fName.compareTo(o.fName);
    }
}

