/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.structures;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModule;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class DashboardMetaData {
    private static File metaFile;
    private DashboardModule module = null;
    public static final File tempScriptFolder;
    public static final File tempModuleFolder;
    public static final String XMLDashboardItem = "DashboardItem";
    public static final String XMLdDisplay = "display";
    public static final String XMLdCategory = "category";
    public static final String XMLdDescription = "description";
    public static final String XMLdDataset = "dataset";
    public static final String XMLdScript = "script";
    public static final String XMLdScriptFileName = "scriptFileName";
    public static final String XMLdLocation = "location";
    public static final String XMLParsingExpressions = "ParsingExpressions";
    public static final String XMLpColumn = "Column";
    public static final String XMLpName = "name";
    public static final String XMLpParser = "Parser";
    public static final String XMLGraphDisplays = "GraphDisplays";
    public static final String XMLgGraph = "Graph";
    public static final String XMLgId = "id";
    public static final String XMLgTitle = "title";
    public static final String XMLgColumn = "column";
    public static final String XMLgAxis = "axis";
    public static final String XMLgAxisX = "x";
    public static final String XMLgAxisY = "y";
    public static final String XMLgSeries = "Series";
    public static final String XMLgFilter = "Filter";
    public static final String XMLKernelModule = "KernelModule";
    public static final String XMLkVersion = "version";
    public static final String XMLkModule = "module";

    static {
        tempScriptFolder = new File("/tmp/systemtapgui/scripts/");
        tempModuleFolder = new File("/tmp/systemtapgui/modules/");
    }

    public DashboardMetaData(String file) {
        this(new File(file));
    }

    public DashboardMetaData(File file) {
        metaFile = file;
        if (file.exists()) {
            this.readData();
        }
    }

    public DashboardModule getModule() {
        return this.module;
    }

    public boolean isModuleAvailable(String kernelVersion) {
        int i = 0;
        while (i < this.module.kernelVersions.length) {
            if (this.module.kernelVersions[i].equals(kernelVersion)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public File getKernelModule(String kernelVersion) {
        int i = 0;
        while (i < this.module.kernelVersions.length) {
            if (this.module.kernelVersions[i].equals(kernelVersion)) {
                return this.module.kernelModules[i];
            }
            ++i;
        }
        return null;
    }

    private boolean readData() {
        FileReader reader;
        block18: {
            if (metaFile == null) {
                return false;
            }
            this.module = new DashboardModule();
            reader = new FileReader(metaFile);
            if (reader.ready()) break block18;
            reader.close();
            return false;
        }
        try {
            XMLMemento data = XMLMemento.createReadRoot((Reader)reader, (String)XMLDashboardItem);
            this.module.display = data.getString(XMLdDisplay);
            this.module.category = data.getString(XMLdCategory);
            this.module.description = data.getString(XMLdDescription);
            this.module.dataSetID = data.getString(XMLdDataset);
            this.module.location = data.getString(XMLdLocation);
            this.module.scriptFileName = data.getString(XMLdScriptFileName);
            File temp = null;
            if (this.module.location == null || this.module.location.equalsIgnoreCase("local")) {
                if (!tempScriptFolder.exists()) {
                    tempScriptFolder.mkdirs();
                }
                temp = new File(metaFile.getParentFile() + data.getString(XMLdScript));
                this.module.script = new File(String.valueOf(tempScriptFolder.getAbsolutePath()) + "/" + this.module.hashCode() + ".stp");
                temp.renameTo(this.module.script);
            } else {
                this.module.script = new File(String.valueOf(this.module.location) + "/" + this.module.scriptFileName);
            }
            IMemento[] children = data.getChild(XMLParsingExpressions).getChildren(XMLpColumn);
            this.module.labels = new String[children.length];
            int i = 0;
            while (i < children.length) {
                this.module.labels[i] = children[i].getString(XMLpName);
                ++i;
            }
            this.module.parser = DataSetFactory.createParserXML((String)this.module.dataSetID, (IMemento)data.getChild(XMLParsingExpressions).getChild(XMLpParser));
            children = data.getChild(XMLGraphDisplays).getChildren(XMLgGraph);
            this.module.graphs = new GraphData[children.length];
            this.module.filters = new ArrayList[children.length];
            i = 0;
            while (i < children.length) {
                this.module.graphs[i] = new GraphData();
                this.module.graphs[i].graphID = children[i].getString(XMLgId);
                this.module.graphs[i].title = children[i].getString(XMLgTitle);
                IMemento[] children2 = children[i].getChildren(XMLgFilter);
                this.module.filters[i] = new ArrayList();
                int j = 0;
                while (j < children2.length) {
                    this.module.filters[i].add(AvailableFilterTypes.getDataSetFilter((IMemento)children2[j]));
                    ++j;
                }
                children2 = children[i].getChildren(XMLgSeries);
                this.module.graphs[i].ySeries = new int[children2.length - 1];
                j = 0;
                int ys = 0;
                while (j < children2.length) {
                    if (XMLgAxisX.equals(children2[j].getString(XMLgAxis))) {
                        this.module.graphs[i].xSeries = children2[j].getInteger(XMLgColumn);
                    } else if (XMLgAxisY.equals(children2[j].getString(XMLgAxis))) {
                        this.module.graphs[i].ySeries[ys] = children2[j].getInteger(XMLgColumn);
                        ++ys;
                    }
                    ++j;
                }
                ++i;
            }
            children = data.getChildren(XMLKernelModule);
            this.module.kernelVersions = new String[children.length];
            this.module.kernelModules = new File[children.length];
            if (!tempModuleFolder.exists()) {
                tempModuleFolder.mkdirs();
            }
            i = 0;
            while (i < children.length) {
                this.module.kernelVersions[i] = children[i].getString(XMLkVersion);
                temp = new File(metaFile.getParentFile() + children[i].getString(XMLkModule));
                this.module.kernelModules[i] = new File(String.valueOf(tempModuleFolder.getAbsolutePath()) + this.module.hashCode() + temp.getName());
                temp.renameTo(this.module.kernelModules[i]);
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (WorkbenchException workbenchException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

