/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;

public class TmfCheckpointIndexer<T extends ITmfTrace<ITmfEvent>>
implements ITmfTraceIndexer<T> {
    private final ITmfTrace<ITmfEvent> fTrace;
    private final int fCheckpointInterval;
    private boolean fIsIndexing;
    private final List<ITmfCheckpoint> fTraceIndex;
    private ITmfEventRequest<ITmfEvent> fIndexingRequest = null;

    public TmfCheckpointIndexer(ITmfTrace<ITmfEvent> trace) {
        this(trace, 50000);
    }

    public TmfCheckpointIndexer(ITmfTrace<ITmfEvent> trace, int interval) {
        this.fTrace = trace;
        this.fCheckpointInterval = interval;
        this.fTraceIndex = new ArrayList<ITmfCheckpoint>();
        this.fIsIndexing = false;
    }

    @Override
    public void dispose() {
        if (this.fIndexingRequest != null && !this.fIndexingRequest.isCompleted()) {
            this.fIndexingRequest.cancel();
            this.fTraceIndex.clear();
        }
    }

    @Override
    public boolean isIndexing() {
        return this.fIsIndexing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndex(long offset, TmfTimeRange range, boolean waitForCompletion) {
        List<ITmfCheckpoint> list = this.fTraceIndex;
        synchronized (list) {
            if (this.fIsIndexing) {
                return;
            }
            this.fIsIndexing = true;
        }
        final Job job = new Job("Indexing " + this.fTrace.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.fIndexingRequest = new TmfEventRequest<ITmfEvent>(ITmfEvent.class, range, offset, Integer.MAX_VALUE, this.fCheckpointInterval, ITmfDataRequest.ExecutionType.BACKGROUND){
            private ITmfTimestamp startTime;
            private ITmfTimestamp lastTime;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.startTime = null;
                this.lastTime = null;
            }

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (event != null) {
                    ITmfTimestamp timestamp = event.getTimestamp();
                    if (this.startTime == null) {
                        this.startTime = timestamp.clone();
                    }
                    this.lastTime = timestamp.clone();
                    if (this.getNbRead() % TmfCheckpointIndexer.this.fCheckpointInterval == 0) {
                        this.updateTraceStatus();
                    }
                }
            }

            @Override
            public void handleSuccess() {
                this.updateTraceStatus();
            }

            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
                TmfCheckpointIndexer.this.fIsIndexing = false;
            }

            private void updateTraceStatus() {
                if (this.getNbRead() != 0) {
                    TmfCheckpointIndexer.this.signalNewTimeRange(this.startTime, this.lastTime);
                }
            }
        };
        this.fTrace.sendRequest(this.fIndexingRequest);
        if (waitForCompletion) {
            try {
                this.fIndexingRequest.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void signalNewTimeRange(ITmfTimestamp startTime, ITmfTimestamp endTime) {
        this.fTrace.broadcast(new TmfTraceUpdatedSignal(this.fTrace, this.fTrace, new TmfTimeRange(startTime, endTime)));
    }

    @Override
    public synchronized void updateIndex(ITmfContext context, ITmfTimestamp timestamp) {
        long rank = context.getRank();
        if (rank % (long)this.fCheckpointInterval == 0L) {
            long position = rank / (long)this.fCheckpointInterval;
            if ((long)this.fTraceIndex.size() == position) {
                this.fTraceIndex.add(new TmfCheckpoint(timestamp.clone(), context.clone()));
            }
        }
    }

    @Override
    public synchronized ITmfContext seekIndex(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            return this.fTrace.seekEvent(0L);
        }
        int index = Collections.binarySearch(this.fTraceIndex, new TmfCheckpoint(timestamp, null));
        if (index < 0) {
            index = Math.max(0, -(index + 2));
        }
        return this.restoreCheckpoint(index);
    }

    @Override
    public ITmfContext seekIndex(long rank) {
        if (rank < 0L) {
            return this.fTrace.seekEvent(0L);
        }
        int index = (int)rank / this.fCheckpointInterval;
        return this.restoreCheckpoint(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITmfContext restoreCheckpoint(int checkpoint) {
        ITmfLocation<?> location = null;
        int index = 0;
        List<ITmfCheckpoint> list = this.fTraceIndex;
        synchronized (list) {
            if (!this.fTraceIndex.isEmpty()) {
                index = checkpoint;
                if (index >= this.fTraceIndex.size()) {
                    index = this.fTraceIndex.size() - 1;
                }
                return this.fTraceIndex.get(index).getContext().clone();
            }
        }
        ITmfContext context = this.fTrace.seekEvent(location);
        context.setRank((long)index * (long)this.fCheckpointInterval);
        return context;
    }

    protected List<ITmfCheckpoint> getTraceIndex() {
        return this.fTraceIndex;
    }
}

