/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.ParsingWizardPage;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.SelectDataSetWizardPage;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class DataSetWizard
extends Wizard
implements INewWizard {
    private IPageChangedListener pageListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent e) {
            if (e.getSelectedPage() instanceof ParsingWizardPage) {
                ((ParsingWizardPage)((Object)e.getSelectedPage())).checkComplete();
                DataSetWizard.this.getContainer().updateButtons();
            }
        }
    };
    private SelectDataSetWizardPage dataSetPage;
    private ParsingWizardPage[] parsingPages;
    public String scriptFile;
    public File metaFile;
    public IDataSet dataSet;
    public IDataSetParser parser;

    public DataSetWizard(File metaFile, String scriptFile) {
        this.metaFile = metaFile;
        this.scriptFile = scriptFile;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Localization.getString("DataSetWizard.CreateDataSet"));
        this.dataSetPage = new SelectDataSetWizardPage();
        this.addPage((IWizardPage)this.dataSetPage);
        String[] ids = DataSetFactory.getIDs();
        this.parsingPages = new ParsingWizardPage[ids.length];
        int i = 0;
        while (i < ids.length) {
            this.parsingPages[i] = DataSetFactory.getParsingWizardPage(ids[i]);
            this.addPage((IWizardPage)this.parsingPages[i]);
            ++i;
        }
        ((WizardDialog)this.getContainer()).addPageChangedListener(this.pageListener);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return this.dataSet != null && this.parser != null && page instanceof ParsingWizardPage;
    }

    public boolean performCancel() {
        this.parser = null;
        this.dataSet = null;
        return true;
    }

    public boolean performFinish() {
        this.writeParsingExpression();
        return true;
    }

    public IDataSetParser getParser() {
        return this.parser;
    }

    public IDataSet getDataSet() {
        return this.dataSet;
    }

    private boolean writeParsingExpression() {
        XMLMemento data = this.copyExisting();
        if (data == null) {
            data = XMLMemento.createWriteRoot((String)"DataSetSettings");
        }
        try {
            IMemento child = data.createChild("File", this.scriptFile);
            this.saveColumns(child, this.dataSet.getTitles());
            this.parser.saveXML(child);
            FileWriter writer = new FileWriter(this.metaFile);
            data.save((Writer)writer);
            writer.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected XMLMemento copyExisting() {
        FileReader reader;
        XMLMemento data;
        block7: {
            data = null;
            reader = new FileReader(this.metaFile);
            if (reader.ready()) break block7;
            return null;
        }
        try {
            data = XMLMemento.createReadRoot((Reader)reader, (String)"DataSetSettings");
            IMemento[] children = data.getChildren("File");
            data = XMLMemento.createWriteRoot((String)"DataSetSettings");
            int i = 0;
            while (i < children.length) {
                if (!this.scriptFile.equals(children[i].getID())) {
                    IMemento child = data.createChild("File", children[i].getID());
                    String dataSetID = children[i].getString("dataset");
                    child.putString("dataset", dataSetID);
                    DataSetFactory.getParsingWizardPage(dataSetID).copyExisting(children[i], child);
                }
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (WorkbenchException workbenchException) {}
        return data;
    }

    protected boolean saveColumns(IMemento target, String[] columns) {
        int i = 0;
        while (i < columns.length) {
            IMemento child = target.createChild("Column");
            child.putString("name", columns[i]);
            ++i;
        }
        return true;
    }

    protected boolean openFile() {
        try {
            if (!this.metaFile.exists()) {
                this.metaFile.createNewFile();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.getContainer() != null) {
            ((WizardDialog)this.getContainer()).removePageChangedListener(this.pageListener);
        }
        if (this.dataSetPage != null) {
            this.dataSetPage.dispose();
        }
        if (this.parsingPages != null) {
            int i = 0;
            while (i < this.parsingPages.length) {
                if (this.parsingPages[i] != null) {
                    this.parsingPages[i].dispose();
                    this.parsingPages[i] = null;
                }
                ++i;
            }
            this.parsingPages = null;
        }
    }
}

