/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_yrl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Miridiyanu yara Hurariyu",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Hurariyu Retewa Acre yara",
               "ACT",
               "Hurariyu Kuras\u00ed Ara Acre yara",
               "ACST",
               "Hurariyu Acre yara",
               "ACT",
            };
        final String[] Apia = new String[] {
               "Apiya Uraruiyu Retewa",
               "",
               "Apiya Kuras\u00ed Ara Hurariyu",
               "",
               "Apiya Hurariyu",
               "",
            };
        final String[] Cook = new String[] {
               "Kapu\u00e3-ita Kooki Hurariyu Retewa",
               "",
               "Kapu\u00e3-ita Kooki Kuras\u00ed Ara Pitera Hurariyu",
               "",
               "Kapu\u00e3-ita Kooki Hurariyu",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba Hurariyu Retewa",
               "CST",
               "Kuba Kuras\u00ed Ara Hurariyu",
               "CDT",
               "Kuba Hurariyu",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiyi Hurariyu Retewa",
               "",
               "Fiyi Kuras\u00ed Ara Hurariyu",
               "",
               "Fiyi Hurariyu",
               "",
            };
        final String[] Gulf = new String[] {
               "Golfo Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Howidi Hurariyu Retewa",
               "",
               "Howidi Kuras\u00ed Ara Hurariyu",
               "",
               "Howidi Hurariyu",
               "",
            };
        final String[] Iran = new String[] {
               "Ir\u00e3 Hurariyu Retewa",
               "",
               "Ir\u00e3 Kuras\u00ed Ara Hurariyu",
               "",
               "Ir\u00e3 Hurariyu",
               "",
            };
        final String[] Niue = new String[] {
               "Niwe Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omisiki Hurariyu Retewa",
               "",
               "Omisiki Kuras\u00ed Ara Hurariyu",
               "",
               "Omisiki Hurariyu",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Hurariyu Retewa",
               "",
               "Peru Kuras\u00ed Ara Hurariyu",
               "",
               "Peru Hurariyu",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Kapu\u00e3-ita Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Xiri Hurariyu Retewa",
               "",
               "Xiri Kuras\u00ed Ara Hurariyu",
               "",
               "Xiri Hurariyu",
               "",
            };
        final String[] China = new String[] {
               "Xina Hurariyu Retewa",
               "CST",
               "Xina Kuras\u00ed Ara Hurariyu",
               "CDT",
               "Xina Hurariyu",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kapu\u00e3-ita Kuku-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Dawi Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u0128dia Hurariyu Retewa",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Nip\u00f5 Hurariyu Retewa",
               "JST",
               "Nip\u00f5 Kuras\u00ed Ara Hurariyu",
               "JDT",
               "Nip\u00f5 Hurariyu",
               "JT",
            };
        final String[] Korea = new String[] {
               "Kureya Hurariyu Retewa",
               "KST",
               "Kureya Kuras\u00ed Ara Hurariyu",
               "KST",
               "Kureya Hurariyu",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepau Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Parau Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samowa Hurariyu Retewa",
               "SST",
               "Samowa Kuras\u00ed Ara Hurariyu",
               "SST",
               "Samowa Hurariyu",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Siyowa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "T\u00f5ga Hurariyu Retewa",
               "",
               "T\u00f5ga Kuras\u00ed Ara Hurariyu",
               "",
               "T\u00f5ga Hurariyu",
               "",
            };
        final String[] Alaska = new String[] {
               "Alasika Hurariyu Et\u00e9",
               "AKST",
               "Alasika Kuras\u00ed Ara Hurariyu",
               "AKDT",
               "Alasika Hurariyu",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amasuna Hurariyu Et\u00e9",
               "AMT",
               "Amasuna Kuras\u00ed Ara Hurariyu",
               "AMST",
               "Amasuna Hurariyu",
               "AMT",
            };
        final String[] Anadyr = new String[] {
               "Anad\u00ed Hurariyu Retewa",
               "",
               "Anad\u00ed Kuras\u00ed Ara Hurariyu",
               "",
               "Anad\u00ed Hurariyu",
               "",
            };
        final String[] Azores = new String[] {
               "Asori-ita Hurariyu Retewa",
               "",
               "Asori-ita Kuras\u00ed Ara Hurariyu",
               "",
               "Asori-ita Hurariyu",
               "",
            };
        final String[] Bhutan = new String[] {
               "But\u00e3u Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Burunei Darusaram Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Pasikuwa Kapu\u00e3ma Hurariyu Retewa",
               "",
               "Pasikuwa Kapu\u00e3ma Kuras\u00ed Ara Hurariyu",
               "",
               "Pasikuwa Kapu\u00e3ma Hurariyu",
               "",
            };
        final String[] Guyana = new String[] {
               "Giyana Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Isirayeu Hurariyu Retewa",
               "IST",
               "Isirayeu Kuras\u00ed Ara Hurariyu",
               "IDT",
               "Isirayeu Hurariyu",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kusirai Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Maus\u0169 Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskou Hurariyu Retewa",
               "MSK",
               "Moskou Kuras\u00ed Ara Hurariyu",
               "MSK",
               "Moskou Hurariyu",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara Hurariyu Retewa",
               "",
               "Samara Kuras\u00ed Ara Hurariyu",
               "",
               "Samara Hurariyu",
               "",
            };
        final String[] Tahiti = new String[] {
               "Taiti Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei Hurariyu Retewa",
               "CST",
               "Taipei Kuras\u00ed Ara Hurariyu",
               "CDT",
               "Taipei Hurariyu",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaru Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wosituki Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wari asu\u00ed Futuna Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ar\u00e1biya Hurariyu Retewa",
               "",
               "Arabiya Kuras\u00ed Ara Hurariyu",
               "",
               "Ar\u00e1biya Hurariyu",
               "",
            };
        final String[] Armenia = new String[] {
               "Arim\u1ebdniya Hurariyu Retewa",
               "",
               "Arim\u1ebdniya Kuras\u00ed Ara Hurariyu",
               "",
               "Arim\u1ebdniya Hurariyu",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bur\u00edwia Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Xatham Hurariyu Retewa",
               "",
               "Xatham Kuras\u00ed Ara Hurariyu",
               "",
               "Xatham Hurariyu",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hurariyu M\u0169di turususawa Kurdenadu",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekuad\u00fa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "G\u00e3biere Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Geugiya Hurariyu Retewa",
               "",
               "Geugiya Kuras\u00ed Ara Hurariyu",
               "",
               "Geugiya Hurariyu",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutisiki Hurariyu Retewa",
               "",
               "Irkutisiki Kuras\u00ed Ara Hurariyu",
               "",
               "Irkutisiki Hurariyu",
               "",
            };
        final String[] Magadan = new String[] {
               "Magad\u00e3 Hurariyu Retewa",
               "",
               "Magad\u00e3 Kuras\u00ed Ara Hurariyu",
               "",
               "Magad\u00e3 Hurariyu",
               "",
            };
        final String[] Myanmar = new String[] {
               "Miyam\u00e1 Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Kapu\u00e3ma Norfolk Hurariyu Retewa",
               "",
               "Kapu\u00e3ma Norfolk Kuras\u00ed Ara Hurariyu",
               "",
               "Kapu\u00e3ma Norfolk Hurariyu",
               "",
            };
        final String[] Noronha = new String[] {
               "Fen\u00e3du Nuruy\u00e3 Hurariyu Retewa",
               "",
               "Fen\u00e3du Nuruy\u00e3 Kuras\u00ed Ara Hurariyu",
               "",
               "Fen\u00e3du Nuruy\u00e3 Hurariyu",
               "",
            };
        final String[] Reunion = new String[] {
               "Yumuatirisawa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Kapu\u00e3ma-ita Sarum\u0169 Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokerau Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguwai Hurariyu Retewa",
               "",
               "Uruguwai Kuras\u00ed Ara Hurariyu",
               "",
               "Uruguwai Hurariyu",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Wanuatu Hurariyu Retewa",
               "",
               "Wanuatu Kuras\u00ed Ara Hurariyu",
               "",
               "Wanuatu Hurariyu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutisiki Hurariyu Retewa",
               "",
               "Yakutisiki Kuras\u00ed Ara Hurariyu",
               "",
               "Yakutisiki Hurariyu",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atal\u00e3tiku Hurariyu Retewa",
               "AST",
               "Atal\u00e3tku Kuras\u00ed Ara Hurariyu",
               "AST",
               "Atal\u00e3tiku Hurariyu",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "\u00d3ra P\u00e3 Bras\u00edlia t\u00e1",
               "BRT",
               "R\u1ef9 K\u00e3 \u00d3ra Bras\u00edlia t\u00e1",
               "BRST",
               "\u00d3ra Bras\u00edlia t\u00e1",
               "BRT",
            };
        final String[] Chamorro = new String[] {
               "Xamoro Hurariyu",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kur\u0169bia Hurariyu Retewa",
               "",
               "Kur\u0169bia Kuras\u00ed Ara Hurariyu",
               "",
               "Kur\u0169bia Hurariyu",
               "",
            };
        final String[] Falkland = new String[] {
               "Kapu\u00e3-ita Mawina Hurariyu Retewa",
               "",
               "Kapu\u00e3-ita Mawina Kuras\u00ed Ara Hurariyu",
               "",
               "Kapu\u00e3-ita Mawina Hurariyu",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malasiya Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Kapu\u00e3-ita Maudiwa-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ur\u00e3 Baturu Hurariyu Retewa",
               "",
               "Ur\u00e3 Baturu Kuras\u00ed Ara Hurariyu",
               "",
               "Ur\u00e3 Baturu Hurariyu",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakiret\u00e3ma Hurariyu Retewa",
               "PKT",
               "Pakiret\u00e3ma Kuras\u00ed Ara Hurariyu",
               "PKST",
               "Pakiret\u00e3ma Hurariyu",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguwai Hurariyu Retewa",
               "",
               "ParaguwaiKuras\u00ed Ara Hurariyu",
               "",
               "Paraguwai Hurariyu",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakarina Hurariyu Retewa",
               "",
               "Sakarina Kuras\u00ed Ara Hurariyu",
               "",
               "Sakarina Hurariyu",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Arg\u1ebdtina Hurariyu Retewa",
               "",
               "Arg\u1ebdtina Kuras\u00ed Ara Hurariyu",
               "",
               "Arg\u1ebdtina Hurariyu",
               "",
            };
        final String[] Christmas = new String[] {
               "Kapu\u00e3maKiritima Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Garapagu-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "H\u0169g K\u0169g Hurariyu Retewa",
               "HKT",
               "H\u0169g K\u0169g Kuras\u00ed Ara Hurariyu",
               "HKST",
               "H\u0169g K\u0169g Hurariyu",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "\u0128doxina Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatski Hurariyu Retewa",
               "",
               "Petropavlovsk-Kamchatski Kuras\u00ed Ara Hurariyu",
               "",
               "Petropavlovsk-Kamchatski Hurariyu",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirigiret\u00e3ma Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lurudi Howe Hurariyu Retewa",
               "",
               "Lurudi Howe Kuras\u00ed Ara Hurariyu",
               "",
               "Lurudi Howe Hurariyu",
               "",
            };
        final String[] Marquesas = new String[] {
               "Makesa-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Maurisiyu Hurariyu Retewa",
               "",
               "Maurisiyu Kuras\u00ed Ara Hurariyu",
               "",
               "Maurisiyu Hurariyu",
               "",
            };
        final String[] Singapore = new String[] {
               "S\u0129gapura Hurariyu Retewa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Wen\u1ebdsuera Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Worwogaradu Hurariyu Retewa",
               "MSK",
               "Worwogaradu Kuras\u00ed Ara Hurariyu",
               "MSK",
               "Worwogaradu Hurariyu",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aseriret\u00e3ma Hurariyu Retewa",
               "",
               "Aseriret\u00e3ma Kuras\u00ed Ara Hurariyu",
               "",
               "Aseriret\u00e3ma Hurariyu",
               "",
            };
        final String[] Bangladesh = new String[] {
               "B\u00e3karadexi Horariyu Retewa",
               "",
               "B\u00e3karadexi Kuras\u00ed Ara Horariyu",
               "",
               "B\u00e3karadexi Horariyu",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kabu Suikiri Hurariyu Retewa",
               "",
               "Kabu Suikiri Kuras\u00ed Ara Hurariyu",
               "",
               "Kabu Suikiri Hurariyu",
               "",
            };
        final String[] East_Timor = new String[] {
               "Timu-Semusawa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seixeri Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tayikiret\u00e3ma Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Y\u0169buesara-ret\u00e3ma Hurariyu Retewa",
               "",
               "Y\u0169buesara-ret\u00e3ma Kuras\u00ed Ara Hurariyu",
               "",
               "Y\u0169buesara-ret\u00e3ma Hurariyu",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afeg\u00e3niret\u00e3ma Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Karasinoyarisiki Hurariyu Retewa",
               "",
               "Karasinoyarisiki Kuras\u00ed Ara Hurariyu",
               "",
               "Karasinoyarisiki Hurariyu",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ser\u00e3diya Pisas\u00fa Hurariyu Retewa",
               "NZST",
               "Ser\u00e3diya Pisas\u00fa Kuras\u00ed Ara Hurariyu",
               "NZDT",
               "Ser\u00e3diya Pisas\u00fa Hurariyu",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Sibirisiki Pisas\u00fa Hurariyu Retewa",
               "",
               "Sibirisiki Pisas\u00fa Kuras\u00ed Ara Hurariyu",
               "",
               "Sibirisiki Pisas\u00fa Hurariyu",
               "",
            };
        final String[] Philippines = new String[] {
               "Firipina Hurariyu Retewa",
               "PST",
               "Firipina Kuras\u00ed Ara Hurariyu",
               "PDT",
               "Firipina Hurariyu",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Waradiwosituki Hurariyu Retewa",
               "",
               "Waradiwosituki Kuras\u00ed Ara Hurariyu",
               "",
               "Waradiwosituki Hurariyu",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Useyanu \u0128diku Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Kapu\u00e3-ita In\u0129bu Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Iw\u00ed Pisas\u00fa Hurariyu Retewa",
               "NST",
               "Iw\u00ed Pisas\u00fa Kuras\u00ed Ara Hurariyu",
               "NDT",
               "Iw\u00ed Pisas\u00fa Hurariyu",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkuranaret\u00e3ma Hurariyu Retewa",
               "",
               "Turkuranaret\u00e3ma Kuras\u00ed Ara Hurariyu",
               "",
               "Turkuranaret\u00e3ma Hurariyu",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Giyana Fr\u00e3sa yara Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Kared\u0169niya Pisas\u00fa Hurariyu Retewa",
               "",
               "Kared\u0169niya Pisas\u00fa Kuras\u00ed Ara Hurariyu",
               "",
               "Kared\u0169niya Pisas\u00fa Hurariyu",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Geugiya Su su\u00ed Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ekater\u0129bugu Hurariyu Retewa",
               "",
               "Ekater\u0129bugu Kuras\u00ed Ara Hurariyu",
               "",
               "Ekater\u0129bugu Hurariyu",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Afirika Piterawara Hurariyu",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Afirika Uri\u1ebdtawara Hurariyu",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Afirika Usid\u1ebdtawara Hurariyu Retewa",
               "WAT",
               "Afirika Usid\u1ebdtawara Kuras\u00ed Ara Hurariyu",
               "WAT",
               "Afirikia Usid\u1ebdtawara Hurariyu",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Eurupa Piterawara Hurariyu Retewa",
               "CET",
               "Eurupa Piterawara Kuras\u00ed Ara Hurariyu",
               "CEST",
               "Eurupa Piterawara Hurariyu",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Eurupa Uri\u1ebdtawara Hurariyu Retewa",
               "EET",
               "Eurupa Uri\u1ebdtawara Kuras\u00ed Ara Hurariyu",
               "EEST",
               "Eurupa Uri\u1ebdtawara Hurariyu",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Eurupa Usid\u1ebdtawara Hurariyu Retewa",
               "WET",
               "Eurupa Usid\u1ebdtawara Kuras\u00ed Ara Hurariyu",
               "WEST",
               "Eurupa Usid\u1ebdtawara Hurariyu",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Pasifiku Mexikanu Hurariyu Retewa",
               "MST",
               "Pasifiku Mexikanu Kuras\u00ed Ara Hurariyu",
               "MDT",
               "Pasifiku Mexikanu Hurariyu",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Afirika Su su\u00ed Hurariyu",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Hurariyu Retewa Piterawara",
               "CST",
               "Hurariyu Kuras\u00ed Ara Piterawara",
               "CDT",
               "\u00d3ra Kuju",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hurariyu Retewa Lesiti yara",
               "EST",
               "Hurariyu Kuras\u00ed Ara Lesiti",
               "EST",
               "Hurariyu Lesiti",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "\u00d3ra P\u00e3 Pasifiku t\u00e1",
               "PST",
               "R\u1ef9 K\u00e3 \u00d3ra Pasifiku t\u00e1",
               "PDT",
               "\u00d3ra Pasifiku t\u00e1",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Tet\u00e3ma Su su\u00ed Fr\u00e3sa yara asu\u00ed \u00c3tartida Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Kapu\u00e3-ita Yubetu Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawa\u00ed asu\u00ed Kapu\u00e3-ita Areuta-ita Hurariyu Retewa",
               "HST",
               "Hawa\u00ed asu\u00ed Kapu\u00e3-ita Areuta-ita Kuras\u00ed Ara Hurariyu",
               "HST",
               "Hawa\u00ed asu\u00ed Kapu\u00e3-ita Areuta-ita Hurariyu",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Kapu\u00e3-ita F\u1ebdnix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "S\u00e3 Peduru asu\u00ed Mikir\u00e3u Hurariyu Retewa",
               "",
               "S\u00e3 Peduru asu\u00ed Mikir\u00e3u Kuras\u00ed Ara Hurariyu",
               "",
               "S\u00e3 Peduru asu\u00ed Mikir\u00e3u Hurariyu",
               "",
            };
        final String[] America_Mountain = new String[] {
               "\u00d3ra P\u00e3 Kr\u0129-ag t\u00e1",
               "MST",
               "R\u1ef9 k\u00e3 \u00d3ra Kr\u0129-ag t\u00e1",
               "MST",
               "\u00d3ra Kr\u0129-ag t\u00e1",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Kapu\u00e3-ita Marshall Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papuwa-Gin\u00e9 Pisas\u00fa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ausitaraliya Piterawara Hurariyu Retewa",
               "ACST",
               "Ausitaraliya Piterawara Kuras\u00ed Ara Hurariyu",
               "ACDT",
               "Ausitaraliya Piterawara Hurariyu",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ausitaraliya Uri\u1ebdtawara Hurariyu Retewa",
               "AEST",
               "Ausitaraliya Uri\u1ebdtawara Kuras\u00ed Ara Hurariyu",
               "AEDT",
               "Ausitaraliya Uri\u1ebdtawara Hurariyu",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ausitaraliya Usid\u1ebdtawara Hurariyu Retewa",
               "AWST",
               "Ausitaraliya Usid\u1ebdtawara Kuras\u00ed Ara Hurariyu",
               "AWDT",
               "Ausitaraliya Usid\u1ebdtawara Hurariyu",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0128donesiya Piterawara Hurariyu",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0128donesiya Uri\u1ebdtawara Hurariyu",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0128donesiya Usid\u1ebdtawara Hurariyu",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Kasakiret\u00e3ma Usid\u1ebdtawara Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ausitaraliya Piterawara-Usid\u1ebdtawara Hurariyu Retewa",
               "",
               "Ausitaraliya Piterawara-Usid\u1ebdtawara Kuras\u00ed Ara Hurariyu",
               "",
               "Ausitaraliya Piterawara-Usid\u1ebdtawara Hurariyu",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kuras\u00ed Ara Birit\u00e3niku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hurariyu M\u0169di turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Retewa Ir\u00e3dei",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hurariyu M\u0169di turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hurariyu M\u0169di turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kuras\u00ed Ara Birit\u00e3niku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hurariyu M\u0169di turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Hurariyu M\u0169di turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hurariyu M\u0169di turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Retewa Ir\u00e3dei",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kuras\u00ed Ara Birit\u00e3niku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kuras\u00ed Ara Birit\u00e3niku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kuras\u00ed Ara Birit\u00e3niku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kuras\u00ed Ara Birit\u00e3niku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kuras\u00ed Ara Birit\u00e3niku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Ad\u1ebd" },
            { "timezone.excity.Asia/Dili", "Diri" },
            { "timezone.excity.Asia/Gaza", "Gasa" },
            { "timezone.excity.Asia/Hovd", "Howidi" },
            { "timezone.excity.Asia/Omsk", "Omisiki" },
            { "timezone.excity.Asia/Oral", "Raure" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Am\u00e3" },
            { "timezone.excity.Asia/Aqtau", "Akitau" },
            { "timezone.excity.Asia/Chita", "Xita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Kabul", "Kab\u00fa" },
            { "timezone.excity.Asia/Macau", "Makau" },
            { "timezone.excity.Asia/Qatar", "Katari" },
            { "timezone.excity.Asia/Seoul", "Se\u00fa" },
            { "timezone.excity.Asia/Tokyo", "Tokiyu" },
            { "timezone.excity.Asia/Tomsk", "Tomisiki" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Yuba" },
            { "timezone.excity.Africa/Lome", "Rum\u00e9" },
            { "timezone.excity.Asia/Almaty", "Aumati" },
            { "timezone.excity.Asia/Anadyr", "Anadi" },
            { "timezone.excity.Asia/Aqtobe", "Akitubi" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Beirute" },
            { "timezone.excity.Asia/Brunei", "Burunei" },
            { "timezone.excity.Asia/Hebron", "Hebur\u0169" },
            { "timezone.excity.Asia/Kuwait", "Kuwaiti" },
            { "timezone.excity.Asia/Manila", "Manira" },
            { "timezone.excity.Asia/Muscat", "Masikati" },
            { "timezone.excity.Asia/Riyadh", "Riade" },
            { "timezone.excity.Asia/Tehran", "Teyer\u00e3" },
            { "timezone.excity.Asia/Urumqi", "Ur\u0169ki" },
            { "timezone.excity.Etc/Unknown", "Tawa-was\u00fa \u0168bawaukuamam\u1ebd" },
            { "timezone.excity.Europe/Kiev", "Kiyewe" },
            { "timezone.excity.Europe/Oslo", "Usiru" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Ma\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akara" },
            { "timezone.excity.Africa/Cairo", "Kairu" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.Africa/Lagos", "Ipawaita" },
            { "timezone.excity.Africa/Tunis", "Tuni-ita" },
            { "timezone.excity.America/Adak", "Adaki" },
            { "timezone.excity.America/Lima", "Rima" },
            { "timezone.excity.America/Nome", "R\u00e9ra" },
            { "timezone.excity.Asia/Baghdad", "Magna" },
            { "timezone.excity.Asia/Bahrain", "Bar\u1ebdi" },
            { "timezone.excity.Asia/Bangkok", "M\u00e1g-k\u00f3ki" },
            { "timezone.excity.Asia/Barnaul", "Barnau" },
            { "timezone.excity.Asia/Bishkek", "Bisikeki" },
            { "timezone.excity.Asia/Colombo", "Kur\u0169bu" },
            { "timezone.excity.Asia/Irkutsk", "Irkutisiki" },
            { "timezone.excity.Asia/Jakarta", "Jakata" },
            { "timezone.excity.Asia/Karachi", "Karaxi" },
            { "timezone.excity.Asia/Kuching", "Kux\u0129gi" },
            { "timezone.excity.Asia/Magadan", "Magad\u00e3" },
            { "timezone.excity.Asia/Nicosia", "Nikosiya" },
            { "timezone.excity.Asia/Rangoon", "R\u00e3g\u0169" },
            { "timezone.excity.Asia/Tbilisi", "Tibilisi" },
            { "timezone.excity.Asia/Thimphu", "T\u0129pu" },
            { "timezone.excity.Asia/Yakutsk", "Yakutisiki" },
            { "timezone.excity.Asia/Yerevan", "Yerew\u00e3" },
            { "timezone.excity.Europe/Kirov", "Kirowi" },
            { "timezone.excity.Europe/Malta", "Mauta" },
            { "timezone.excity.Europe/Minsk", "M\u0129siki" },
            { "timezone.excity.Europe/Sofia", "Sufiya" },
            { "timezone.excity.Europe/Vaduz", "Vadusi" },
            { "timezone.excity.Indian/Cocos", "Kuku-ita" },
            { "timezone.excity.Pacific/Apia", "Apiya" },
            { "timezone.excity.Pacific/Fiji", "Fiyi" },
            { "timezone.excity.Pacific/Guam", "Guw\u00e3" },
            { "timezone.excity.Pacific/Niue", "Niwe" },
            { "timezone.excity.Africa/Asmera", "Asimara" },
            { "timezone.excity.Africa/Bamako", "Bamaku" },
            { "timezone.excity.Africa/Bangui", "B\u00e3ki" },
            { "timezone.excity.Africa/Banjul", "B\u00e3j\u00fa" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "timezone.excity.Africa/Douala", "Duwala" },
            { "timezone.excity.Africa/Kigali", "Kigari" },
            { "timezone.excity.Africa/Luanda", "Ru\u00e3da" },
            { "timezone.excity.Africa/Malabo", "Malabu" },
            { "timezone.excity.Africa/Maputo", "Maputu" },
            { "timezone.excity.Africa/Niamey", "Niamei" },
            { "timezone.excity.America/Bahia", "Ba\u00edya" },
            { "timezone.excity.America/Belem", "Bel\u1ebd" },
            { "timezone.excity.America/Boise", "Buwis\u00e9" },
            { "timezone.excity.America/Jujuy", "Yuyui" },
            { "timezone.excity.America/Sitka", "Sitika" },
            { "timezone.excity.America/Thule", "Tixuri" },
            { "timezone.excity.Asia/Ashgabat", "Asigabati" },
            { "timezone.excity.Asia/Calcutta", "Kaukut\u00e1" },
            { "timezone.excity.Asia/Damascus", "Damasiku" },
            { "timezone.excity.Asia/Dushanbe", "Dux\u00e3bi" },
            { "timezone.excity.Asia/Jayapura", "Yayapura" },
            { "timezone.excity.Asia/Katmandu", "Katim\u00e3du" },
            { "timezone.excity.Asia/Khandyga", "K\u00e3diga" },
            { "timezone.excity.Asia/Qostanay", "Kositanai" },
            { "timezone.excity.Asia/Sakhalin", "Sakarina" },
            { "timezone.excity.Asia/Shanghai", "X\u00e3gai" },
            { "timezone.excity.Asia/Tashkent", "Tasik\u1ebdti" },
            { "timezone.excity.Asia/Ust-Nera", "Usiti-Nera" },
            { "timezone.excity.Europe/Athens", "Atena-ita" },
            { "timezone.excity.Europe/Berlin", "Berlim" },
            { "timezone.excity.Europe/Dublin", "Dubir\u0129" },
            { "timezone.excity.Europe/Jersey", "Jersei" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madri" },
            { "timezone.excity.Europe/Monaco", "Munaku" },
            { "timezone.excity.Europe/Moscow", "Moskou" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Skopje", "Isikupiye" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wiyena" },
            { "timezone.excity.Europe/Warsaw", "Waris\u00f3wiya" },
            { "timezone.excity.Europe/Zagreb", "Sagarebi" },
            { "timezone.excity.Europe/Zurich", "Zuriki" },
            { "timezone.excity.Indian/Chagos", "Xagu-ita" },
            { "timezone.excity.Indian/Comoro", "Kumure-ita" },
            { "timezone.excity.Pacific/Efate", "Efat\u00e9" },
            { "timezone.excity.Pacific/Palau", "Parau" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidiy\u00e3" },
            { "timezone.excity.Africa/Algiers", "Ageu" },
            { "timezone.excity.Africa/Conakry", "Kunakiri" },
            { "timezone.excity.Africa/Kampala", "K\u00e3para" },
            { "timezone.excity.Africa/Mbabane", "\u0168babani" },
            { "timezone.excity.Africa/Nairobi", "Nairubi" },
            { "timezone.excity.Africa/Tripoli", "Tiripuri" },
            { "timezone.excity.America/Belize", "Berise" },
            { "timezone.excity.America/Bogota", "Bugut\u00e1" },
            { "timezone.excity.America/Cancun", "K\u00e3k\u0169" },
            { "timezone.excity.America/Cayman", "Kaim\u00e3" },
            { "timezone.excity.America/Cuiaba", "Kuyaba" },
            { "timezone.excity.America/Dawson", "Daus\u0169" },
            { "timezone.excity.America/Denver", "D\u1ebdwer" },
            { "timezone.excity.America/Guyana", "Giyana" },
            { "timezone.excity.America/Havana", "Hawana" },
            { "timezone.excity.America/Inuvik", "Inuwiki" },
            { "timezone.excity.America/Juneau", "Yuneau" },
            { "timezone.excity.America/Maceio", "Masey\u00f3" },
            { "timezone.excity.America/Manaus", "Manau" },
            { "timezone.excity.America/Nassau", "Nasau" },
            { "timezone.excity.America/Panama", "Panam\u00e3" },
            { "timezone.excity.America/Recife", "Resifi" },
            { "timezone.excity.America/Regina", "Rej\u0129n\u1ef9" },
            { "timezone.excity.Asia/Famagusta", "Famaguita" },
            { "timezone.excity.Asia/Hong_Kong", "H\u0169g K\u0169g" },
            { "timezone.excity.Asia/Jerusalem", "Yerusar\u1ebdi" },
            { "timezone.excity.Asia/Kamchatka", "K\u00e3xatika" },
            { "timezone.excity.Asia/Pontianak", "P\u0169tianaka" },
            { "timezone.excity.Asia/Pyongyang", "Pi\u0169gi\u00e3gi" },
            { "timezone.excity.Asia/Qyzylorda", "Kisiroda" },
            { "timezone.excity.Asia/Samarkand", "Samak\u00e3da" },
            { "timezone.excity.Asia/Singapore", "S\u0129gapura" },
            { "timezone.excity.Asia/Vientiane", "Vi\u1ebdtiane" },
            { "timezone.excity.Europe/Andorra", "\u00c3dura" },
            { "timezone.excity.Europe/Saratov", "Saratuwo" },
            { "timezone.excity.Europe/Tallinn", "Tar\u0129" },
            { "timezone.excity.Europe/Vatican", "Watikanu" },
            { "timezone.excity.Europe/Vilnius", "Viwiu-ita" },
            { "timezone.excity.Indian/Mayotte", "Mayuti" },
            { "timezone.excity.Indian/Reunion", "Yumuatirisawa" },
            { "timezone.excity.Pacific/Easter", "Pasikuwa Kapu\u00e3ma" },
            { "timezone.excity.Pacific/Kosrae", "Kusirai" },
            { "timezone.excity.Pacific/Majuro", "Mayuru" },
            { "timezone.excity.Pacific/Midway", "Midiwei" },
            { "timezone.excity.Pacific/Noumea", "Numeya" },
            { "timezone.excity.Pacific/Saipan", "Saip\u00e3" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Wallis", "Wari-ita" },
            { "timezone.excity.Africa/Blantyre", "Bar\u00e3tire" },
            { "timezone.excity.Africa/Djibouti", "Dijibuti" },
            { "timezone.excity.Africa/El_Aaiun", "Eu Ay\u0169" },
            { "timezone.excity.Africa/Freetown", "Firet\u0169" },
            { "timezone.excity.Africa/Gaborone", "Gaburuni" },
            { "timezone.excity.Africa/Khartoum", "Kat\u0169" },
            { "timezone.excity.Africa/Kinshasa", "K\u0129xasa" },
            { "timezone.excity.Africa/Monrovia", "M\u0169ruwiya" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019 Diyamena" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3 Tum\u00e9" },
            { "timezone.excity.Africa/Windhoek", "W\u0129dueki" },
            { "timezone.excity.America/Antigua", "\u00c3tiguwa" },
            { "timezone.excity.America/Caracas", "Karaka" },
            { "timezone.excity.America/Cayenne", "Kayena" },
            { "timezone.excity.America/Chicago", "Xikagu" },
            { "timezone.excity.America/Cordoba", "K\u00f3duba" },
            { "timezone.excity.America/Creston", "Kerest\u0169" },
            { "timezone.excity.America/Curacao", "Kurasau" },
            { "timezone.excity.America/Godthab", "Nuki" },
            { "timezone.excity.America/Grenada", "Garanada" },
            { "timezone.excity.America/Iqaluit", "Ikaruiti" },
            { "timezone.excity.America/Jamaica", "Yamaika" },
            { "timezone.excity.America/Managua", "Man\u00e1guwa" },
            { "timezone.excity.America/Marigot", "Mariguti" },
            { "timezone.excity.America/Mendoza", "M\u1ebddusa" },
            { "timezone.excity.America/Moncton", "M\u0169kit\u0169" },
            { "timezone.excity.America/Noronha", "Fen\u00e3du Nuruy\u00e3" },
            { "timezone.excity.America/Ojinaga", "Oyinaga" },
            { "timezone.excity.America/Phoenix", "Puwenikisi" },
            { "timezone.excity.America/Tijuana", "Tijuv\u1ef9n\u1ef9" },
            { "timezone.excity.America/Toronto", "Tur\u0169tu" },
            { "timezone.excity.America/Tortola", "Tutura" },
            { "timezone.excity.America/Yakutat", "Yakutati" },
            { "timezone.excity.Asia/Choibalsan", "Xuibaus\u00e3" },
            { "timezone.excity.Asia/Phnom_Penh", "Pin\u00f5 P\u1ebdi" },
            { "timezone.excity.Atlantic/Azores", "Asori-ita" },
            { "timezone.excity.Atlantic/Canary", "Kanariya-ita" },
            { "timezone.excity.Atlantic/Faeroe", "Kapu\u00e3ma-ita Faruwe" },
            { "timezone.excity.Australia/Eucla", "Eukara" },
            { "timezone.excity.Australia/Perth", "Periti" },
            { "timezone.excity.Europe/Belgrade", "Beugaradu" },
            { "timezone.excity.Europe/Brussels", "Buruxera" },
            { "timezone.excity.Europe/Budapest", "Budapeti" },
            { "timezone.excity.Europe/Busingen", "Bus\u0129geni" },
            { "timezone.excity.Europe/Chisinau", "Xisinau" },
            { "timezone.excity.Europe/Guernsey", "Guw\u1ebdnisei" },
            { "timezone.excity.Europe/Helsinki", "Heus\u0129ke" },
            { "timezone.excity.Europe/Istanbul", "Istambul" },
            { "timezone.excity.Europe/Sarajevo", "Sarayewo" },
            { "timezone.excity.Indian/Maldives", "Maudiwa-ita" },
            { "timezone.excity.Pacific/Chatham", "Xatin\u00e3" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaufu" },
            { "timezone.excity.Pacific/Gambier", "G\u00e3biere" },
            { "timezone.excity.Pacific/Norfolk", "Nurufuki" },
            { "timezone.excity.Africa/Bujumbura", "Buy\u0169bura" },
            { "timezone.excity.Africa/Mogadishu", "Mugadisiku" },
            { "timezone.excity.America/Anguilla", "\u00c3gira" },
            { "timezone.excity.America/Asuncion", "As\u0169siy\u00f5" },
            { "timezone.excity.America/Barbados", "Barabadu" },
            { "timezone.excity.America/Dominica", "Duminika" },
            { "timezone.excity.America/Edmonton", "Edim\u0169t\u0169" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Masatar\u00e3" },
            { "timezone.excity.America/Miquelon", "Mikir\u0169" },
            { "timezone.excity.America/New_York", "Yurki Pisas\u00fa" },
            { "timezone.excity.America/Resolute", "Resoruti" },
            { "timezone.excity.America/Santarem", "S\u00e3tar\u1ebd" },
            { "timezone.excity.America/Santiago", "S\u00e3tiyagu" },
            { "timezone.excity.America/St_Johns", "S\u00e3ti Juni" },
            { "timezone.excity.America/St_Kitts", "S\u00e3 Kirituw\u00e3u" },
            { "timezone.excity.America/St_Lucia", "S\u00e3ta Lusiya" },
            { "timezone.excity.America/Winnipeg", "Win\u0129pegi" },
            { "timezone.excity.Antarctica/Casey", "Kasei" },
            { "timezone.excity.Antarctica/Davis", "Dawi" },
            { "timezone.excity.Antarctica/Syowa", "Siyowa" },
            { "timezone.excity.Asia/Krasnoyarsk", "Karasinoyarisiki" },
            { "timezone.excity.Asia/Novosibirsk", "Sibirisiki Pisas\u00fa" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ur\u00e3 Baturu" },
            { "timezone.excity.Asia/Vladivostok", "Waradiwosituki" },
            { "timezone.excity.Atlantic/Bermuda", "Bemuda" },
            { "timezone.excity.Atlantic/Stanley", "Isit\u00e3rei" },
            { "timezone.excity.Australia/Darwin", "Dariw\u0129" },
            { "timezone.excity.Australia/Hobart", "Hobati" },
            { "timezone.excity.Australia/Sydney", "Sidinei" },
            { "timezone.excity.Europe/Amsterdam", "Amiterid\u00e3" },
            { "timezone.excity.Europe/Astrakhan", "Asitarak\u00e3" },
            { "timezone.excity.Europe/Bucharest", "Bukareti" },
            { "timezone.excity.Europe/Gibraltar", "Gibaraut\u00e1" },
            { "timezone.excity.Europe/Ljubljana", "Riubiriana" },
            { "timezone.excity.Europe/Mariehamn", "Mari\u1ebdy\u00e3" },
            { "timezone.excity.Europe/Podgorica", "Pudigurika" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianuwiki" },
            { "timezone.excity.Europe/Volgograd", "Wugogaradu" },
            { "timezone.excity.Indian/Christmas", "Kiritima-ita" },
            { "timezone.excity.Indian/Kerguelen", "Kergel\u1ebd" },
            { "timezone.excity.Indian/Mauritius", "Maurisiyu" },
            { "timezone.excity.Pacific/Auckland", "\u00d3kir\u00e3di" },
            { "timezone.excity.Pacific/Honolulu", "Hunururu" },
            { "timezone.excity.Africa/Casablanca", "Uka Murut\u0129ga" },
            { "timezone.excity.Africa/Libreville", "Riberevili" },
            { "timezone.excity.Africa/Lubumbashi", "Lub\u0169baxi" },
            { "timezone.excity.Africa/Nouakchott", "Nowakixuti" },
            { "timezone.excity.Africa/Porto-Novo", "Igarapawa Pisas\u00fa" },
            { "timezone.excity.America/Anchorage", "\u00c3kurage" },
            { "timezone.excity.America/Araguaina", "Araguayina" },
            { "timezone.excity.America/Boa_Vista", "Buwa Vista" },
            { "timezone.excity.America/Catamarca", "Katamaka" },
            { "timezone.excity.America/Chihuahua", "Sivava" },
            { "timezone.excity.America/Fortaleza", "Futaresa" },
            { "timezone.excity.America/Glace_Bay", "Yrus\u00e3gusu-at\u00e3 Kuara" },
            { "timezone.excity.America/Goose_Bay", "Ipekawasu Kuara" },
            { "timezone.excity.America/Guatemala", "Guatemara" },
            { "timezone.excity.America/Guayaquil", "Guayakiu" },
            { "timezone.excity.America/Matamoros", "Moroitayuk\u00e1" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "timezone.excity.America/Monterrey", "M\u00f5terei" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3 Pauru" },
            { "timezone.excity.America/St_Thomas", "S\u00e3ti Tom\u00e1" },
            { "timezone.excity.America/Vancouver", "V\u00e3kuweri" },
            { "timezone.excity.Antarctica/Mawson", "Maus\u0169" },
            { "timezone.excity.Antarctica/Palmer", "Paumere" },
            { "timezone.excity.Antarctica/Vostok", "Wosituki" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuara R\u0169puru" },
            { "timezone.excity.Asia/Novokuznetsk", "Kusinetisiki Pisas\u00fa" },
            { "timezone.excity.Europe/Bratislava", "Baratisilawa" },
            { "timezone.excity.Europe/Copenhagen", "Kop\u1ebdyagi" },
            { "timezone.excity.Europe/Luxembourg", "Rux\u1ebdbugu" },
            { "timezone.excity.Europe/San_Marino", "S\u00e3 Marinu" },
            { "timezone.excity.Europe/Simferopol", "S\u0129werupu" },
            { "timezone.excity.Pacific/Enderbury", "\u1ebcdeburi" },
            { "timezone.excity.Pacific/Galapagos", "Garapagu-ita" },
            { "timezone.excity.Pacific/Kwajalein", "Kuayar\u1ebdi" },
            { "timezone.excity.Pacific/Marquesas", "Makesa-ita" },
            { "timezone.excity.Pacific/Pago_Pago", "Pagu Pagu" },
            { "timezone.excity.Pacific/Rarotonga", "Rarut\u0169ga" },
            { "timezone.excity.Pacific/Tongatapu", "T\u0169gatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adisi Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Barazawiri" },
            { "timezone.excity.Africa/Ouagadougou", "Uwagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kup\u00e9 Rika" },
            { "timezone.excity.America/Grand_Turk", "Was\u00fa Turiku" },
            { "timezone.excity.America/Guadeloupe", "Guadarupi" },
            { "timezone.excity.America/Hermosillo", "Hemusiru" },
            { "timezone.excity.America/Kralendijk", "Karar\u1ebddiki" },
            { "timezone.excity.America/Louisville", "Luwisiviri" },
            { "timezone.excity.America/Martinique", "Matinika" },
            { "timezone.excity.America/Metlakatla", "Metirakatira" },
            { "timezone.excity.America/Montevideo", "M\u0169tiwidewu" },
            { "timezone.excity.America/Montserrat", "M\u00f5tiserati" },
            { "timezone.excity.America/Paramaribo", "Paramaribu" },
            { "timezone.excity.America/Rio_Branco", "Paran\u00e3 Murut\u0129ga" },
            { "timezone.excity.America/St_Vincent", "S\u00e3 Wis\u1ebdti" },
            { "timezone.excity.America/Whitehorse", "Kawaru Murut\u0129ga" },
            { "timezone.excity.Antarctica/McMurdo", "MakiMudu" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Xeredinekorimiziki" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekater\u0129bugu" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikiyawiki" },
            { "timezone.excity.Atlantic/St_Helena", "S\u00e3ta Er\u1ebdna" },
            { "timezone.excity.Australia/Adelaide", "Aderaidi" },
            { "timezone.excity.Australia/Brisbane", "Biribani" },
            { "timezone.excity.Australia/Lindeman", "R\u0129dem\u00e3" },
            { "timezone.excity.Europe/Isle_of_Man", "M\u00e3 Kapu\u00e3ma" },
            { "timezone.excity.Europe/Kaliningrad", "Karin\u0129garadu" },
            { "timezone.excity.Africa/Johannesburg", "Juanesibugu" },
            { "timezone.excity.America/El_Salvador", "Eu Sawadu" },
            { "timezone.excity.America/Fort_Nelson", "Futi Neus\u0169" },
            { "timezone.excity.America/Mexico_City", "\u1ebcm\u00e3 t\u1ef9 M\u1ebdsiku" },
            { "timezone.excity.America/Porto_Velho", "Igarapawa Kuximawara" },
            { "timezone.excity.America/Puerto_Rico", "Igarapawa Riku" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigaupa" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyear Tawa-was\u00fa" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kabu Suikiri" },
            { "timezone.excity.Australia/Lord_Howe", "Lurudi Howe" },
            { "timezone.excity.Australia/Melbourne", "Meub\u00fani" },
            { "timezone.excity.Indian/Antananarivo", "\u00c3tananariu" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadaukanau" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Katuawa ruka" },
            { "timezone.excity.America/Blanc-Sablon", "Iwiku\u00ed Murut\u0129ga" },
            { "timezone.excity.America/Buenos_Aires", "Buwenusairi" },
            { "timezone.excity.America/Campo_Grande", "K\u00e3pu Wasu" },
            { "timezone.excity.America/Danmarkshavn", "Dinamarakas\u00e3v" },
            { "timezone.excity.America/Dawson_Creek", "Daus\u0169 Kiriki" },
            { "timezone.excity.America/Indiana/Knox", "Knox, \u0128diana" },
            { "timezone.excity.America/Indianapolis", "\u0128dianapuri" },
            { "timezone.excity.America/Punta_Arenas", "P\u0169ta Arena-ita" },
            { "timezone.excity.America/Rankin_Inlet", "R\u00e3k\u0129 Uikesawa" },
            { "timezone.excity.America/Scoresbysund", "Itukutumiti" },
            { "timezone.excity.Antarctica/Macquarie", "Makikuari" },
            { "timezone.excity.Pacific/Bougainville", "Buga\u0129wiri" },
            { "timezone.excity.Pacific/Port_Moresby", "Igarapawa Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "K\u1ebdbiriyi Kuara" },
            { "timezone.excity.America/Coral_Harbour", "Atikok\u00e3" },
            { "timezone.excity.America/Indiana/Vevay", "Wewai, \u0128diana" },
            { "timezone.excity.America/Lower_Princes", "Pir\u0129sipi Quarter Uirpewara" },
            { "timezone.excity.America/Port_of_Spain", "Esip\u00e3ya Igarapawa" },
            { "timezone.excity.America/Santo_Domingo", "S\u00e3tu Dum\u0129gu" },
            { "timezone.excity.America/St_Barthelemy", "S\u00e3 Batulumeu" },
            { "timezone.excity.America/Swift_Current", "Paran\u00e3 Pir\u00e3t\u00e3" },
            { "timezone.excity.Australia/Broken_Hill", "Iwitera Mupena\u00edra" },
            { "timezone.excity.America/Bahia_Banderas", "B\u00e3dera-ita Kuara" },
            { "timezone.excity.America/Port-au-Prince", "Igarapawa Pir\u0129sipi" },
            { "timezone.excity.Atlantic/South_Georgia", "Geugiya Su su\u00ed" },
            { "timezone.excity.America/Argentina/Salta", "Sauta" },
            { "timezone.excity.America/Indiana/Marengo", "Mar\u1ebdgu, \u0128diana" },
            { "timezone.excity.America/Indiana/Winamac", "Win\u00e3maki, \u0128diana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukum\u00e3" },
            { "timezone.excity.America/Argentina/Ushuaia", "Uxuwaya" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell Tawa-was\u00fa, \u0128diana" },
            { "timezone.excity.America/Indiana/Vincennes", "W\u0129sene-ita, \u0128diana" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ra Rioya" },
            { "timezone.excity.America/Argentina/San_Juan", "S\u00e3 Yuw\u00e3" },
            { "timezone.excity.America/Argentina/San_Luis", "S\u00e3 Rui" },
            { "timezone.excity.America/Indiana/Petersburg", "Pitirisibugi, \u0128diana" },
            { "timezone.excity.America/Kentucky/Monticello", "M\u0169tiseru, K\u1ebdtuki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beur, Dakota Nuti su\u00ed" },
            { "timezone.excity.America/North_Dakota/Center", "S\u1ebdte, Dakota Nuti su\u00ed" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Paran\u00e3 Garegu-ita" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Pisas\u00fa Sar\u1ebd, Dakota Nuti su\u00ed" },
        };
        return data;
    }
}
