/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;

public class SplashScreen
extends Window {
    private ImageIcon screen;

    public SplashScreen(Frame f) {
        super(f);
        this.setBackground(Color.white);
        URL url = this.getClass().getResource("/images/SplashScreen.jpg");
        if (url != null) {
            this.screen = new ImageIcon(url);
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.screen.getImage(), 0);
            try {
                mt.waitForAll();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void setVisible(boolean val) {
        if (this.screen == null) {
            return;
        }
        if (val) {
            this.setSize(this.screen.getIconWidth(), this.screen.getIconHeight());
            this.setLocation(-500, -500);
            super.setVisible(true);
            Dimension d = this.getToolkit().getScreenSize();
            Insets i = this.getInsets();
            int w = this.screen.getIconWidth() + i.left + i.right;
            int h = this.screen.getIconHeight() + i.top + i.bottom;
            this.setSize(w, h);
            this.setLocation(d.width / 2 - w / 2, d.height / 2 - h / 2);
        } else {
            super.setVisible(false);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.screen != null) {
            Dimension d = this.getSize();
            g.setColor(Color.black);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.drawImage(this.screen.getImage(), 1, 1, this);
        }
    }
}

